/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.servicehelper.taxunit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class TaxUnitServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxUnitServiceHelper.class);

    public static Map<Long, ExtendedDataEntity> fillIdToEntityMap(ExtendedDataEntity[] dataEntities) {
        Map<Long, ExtendedDataEntity> entityMap = Arrays.stream(dataEntities).filter(d -> d.getDataEntity().getLong("id") != 0L).collect(Collectors.toMap(d -> d.getDataEntity().getLong("id"), d -> d));
        List noIdTaxUnits = Arrays.stream(dataEntities).filter(d -> d.getDataEntity().getLong("id") == 0L).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(noIdTaxUnits)) {
            ORM orm = ORM.create();
            long[] ids = orm.genLongIds("hbss_taxunit", noIdTaxUnits.size());
            for (int i = 0; i < noIdTaxUnits.size(); ++i) {
                ((ExtendedDataEntity)noIdTaxUnits.get(i)).getDataEntity().set("id", (Object)ids[i]);
                entityMap.put(ids[i], (ExtendedDataEntity)noIdTaxUnits.get(i));
            }
        }
        return entityMap;
    }

    public static Map<Long, String> validateLawEntity(ExtendedDataEntity[] dataEntities) {
        List taxUnitIds = Arrays.stream(dataEntities).filter(entity -> entity.getDataEntity().getLong("id") != 0L).map(entity -> entity.getDataEntity().getLong("id")).collect(Collectors.toList());
        List lawEntityIds = Arrays.stream(dataEntities).filter(entity -> entity.getDataEntity().getLong("lawentity.id") != 0L).map(entity -> entity.getDataEntity().getLong("lawentity.id")).collect(Collectors.toList());
        HRBaseServiceHelper taxUnitHelper = new HRBaseServiceHelper("hbss_taxunit");
        QFilter filter = new QFilter("id", "not in", taxUnitIds);
        filter.and("lawentity.id", "in", lawEntityIds);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] taxUnitInDB = taxUnitHelper.query("lawentity.id", new QFilter[]{filter});
        HashMap taxUnitOfLawEntity = Maps.newHashMapWithExpectedSize((int)taxUnitInDB.length);
        for (DynamicObject object : taxUnitInDB) {
            taxUnitOfLawEntity.computeIfAbsent(object.getLong("lawentity.id"), k -> Lists.newArrayList()).add(object);
        }
        HashMap curRepeatMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        HashMap msgMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        String message = ResManager.loadKDString((String)"\u6cd5\u5f8b\u5b9e\u4f53\u201c{0}\u201d\u5df2\u88ab\u7eb3\u7a0e\u5355\u4f4d\u201c{1}\u201d\u5173\u8054\u3002", (String)"TaxUnitServiceHelper_0", (String)"hrmp-hbss-business", (Object[])new Object[0]);
        String symbol = ResManager.loadKDString((String)"\u201d\u3001\u201c", (String)"TaxUnitServiceHelper_2", (String)"hrmp-hbss-business", (Object[])new Object[0]);
        boolean isRelLawEntity = TaxUnitServiceHelper.getIsRelLawEntity();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject taxUnit = dataEntity.getDataEntity();
            long lawEntityId = taxUnit.getLong("lawentity.id");
            long taxUnitId = taxUnit.getLong("id");
            if (lawEntityId == 0L) {
                if (!isRelLawEntity) continue;
                msgMap.put(taxUnitId, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6cd5\u5f8b\u5b9e\u4f53\u201d\u3002", (String)"TaxUnitServiceHelper_1", (String)"hrmp-hbss-business", (Object[])new Object[0]));
                continue;
            }
            List repeatTaxUnits = (List)taxUnitOfLawEntity.get(lawEntityId);
            if (!CollectionUtils.isEmpty((Collection)repeatTaxUnits)) {
                List repeatName = repeatTaxUnits.stream().map(unit -> unit.getString("name")).collect(Collectors.toList());
                String errorMsg = String.join((CharSequence)symbol, repeatName);
                msgMap.put(taxUnitId, MessageFormat.format(message, taxUnit.getString("lawentity.name"), errorMsg));
                continue;
            }
            DynamicObject dynamicObject = curRepeatMap.putIfAbsent(lawEntityId, taxUnit);
            if (dynamicObject == null) continue;
            msgMap.put(taxUnitId, MessageFormat.format(message, taxUnit.getString("lawentity.name"), dynamicObject.getString("name")));
        }
        return msgMap;
    }

    public static boolean getIsRelLawEntity() {
        boolean isRelLawEntity = true;
        try {
            Map paramMap = (Map)HRMServiceHelper.invokeBizService((String)"swc", (String)"hsbs", (String)"IHSBSSalaryParameterService", (String)"getSalaryParam", (Object[])new Object[]{1790621731765991424L});
            if (paramMap != null) {
                isRelLawEntity = (Boolean)paramMap.get("isrellawentity");
            }
        }
        catch (Exception e) {
            LOGGER.error("TaxUnitServiceHelper getIsRelLawEntity error:", (Throwable)e);
        }
        return isRelLawEntity;
    }
}

