/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;

public class CloudAppUpgradeService
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle txHandle = TX.required();){
            DataSet cloudAppDataSetOne = DB.queryDataSet((String)"CloudAppUpgradeService1", (DBRoute)new DBRoute("hmp"), (String)"SELECT fid,fappid FROM t_hbss_cloudapp");
            HashMap appidAndFidMap = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList fidList = Lists.newArrayListWithCapacity((int)16);
            while (cloudAppDataSetOne.hasNext()) {
                Row next = cloudAppDataSetOne.next();
                Long fid = next.getLong("fid");
                fidList.add(fid);
                String fappid = next.getString("fappid");
                appidAndFidMap.put(fid, fappid);
            }
            DataSet cloudAppDataSet = DB.queryDataSet((String)"CloudAppUpgradeService1", (DBRoute)new DBRoute("hmp"), (String)"SELECT fid,fappid FROM t_hbss_cloudapp");
            DataSet appData_L = DB.queryDataSet((String)"CloudAppUpgradeService3", (DBRoute)DBRoute.meta, (String)"SELECT fid,fname,flocaleid FROM t_meta_bizapp_L");
            DataSet appnameData = cloudAppDataSet.join(appData_L.where("flocaleid = 'zh_CN'")).on("fappid", "fid").select(new String[]{"fappid", "fname"}).finish();
            int appNum = 0;
            HashMap appidAndNameMap = Maps.newHashMapWithExpectedSize((int)16);
            ArrayList<SqlParameter[]> sqlParameters = new ArrayList<SqlParameter[]>(16);
            String sql = "UPDATE t_hbss_cloudapp SET fappname =? WHERE fappid =?";
            while (appnameData.hasNext()) {
                ++appNum;
                Row next = appnameData.next();
                String fappid = next.getString("fappid");
                String fname = next.getString("fname") == null ? " " : next.getString("fname");
                appidAndNameMap.put(fappid, fname);
                sqlParameters.add(new SqlParameter[]{new SqlParameter("fappname", 12, (Object)fname), new SqlParameter("fappid", 12, (Object)fappid)});
            }
            if (sqlParameters.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("hmp"), (String)sql, sqlParameters);
            }
            String[] genLongIds = DBServiceHelper.genStringIds((String)"t_hbss_cloudapp_l", (int)appNum);
            String deleteSql = "delete from t_hbss_cloudapp_l";
            DB.execute((DBRoute)new DBRoute("hmp"), (String)deleteSql);
            String insertSql = "insert into t_hbss_cloudapp_l(fpkid,fid,flocaleid,fappname) values (?,?,'zh_CN',?)";
            ArrayList paramList = Lists.newArrayListWithExpectedSize((int)16);
            for (int idx = 0; idx < appNum; ++idx) {
                String appname = (String)appidAndNameMap.get(appidAndFidMap.get(fidList.get(idx)));
                paramList.add(new Object[]{genLongIds[idx], fidList.get(idx), appname == null ? " " : appname});
            }
            DB.executeBatch((DBRoute)new DBRoute("hmp"), (String)insertSql, (List)paramList);
            result.setLog(ResManager.loadKDString((String)"\u4e91\u4e0e\u5e94\u7528appname\u5b57\u6bb5\u5347\u7ea7\u6267\u884c\u5b8c\u6bd5", (String)"CloudAppUpgradeService_0", (String)"hrmp-hbss-business", (Object[])new Object[0]));
            result.setSuccess(true);
            result.setEl("warning");
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }
}

