/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.mservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.PersonRelaitionModel;
import kd.hr.hbss.bussiness.config.HRConfigServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.EmpGroupServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.HRBUCAServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.LawEntityServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.MsgCenterServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.PermFilesServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.PersonRoleRelServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.WorkRolesServiceHelper;
import kd.hr.hbss.bussiness.task.HRBuSync;
import kd.hr.hbss.common.constants.HRBUConstants;
import kd.hr.hbss.common.util.LocalCacheUtils;
import kd.hr.hbss.mservice.api.IHBSSService;

public class HBSSService
implements IHBSSService {
    private static final Log LOGGER = LogFactory.getLog(HBSSService.class);

    public DynamicObject getMainChargeRoleByRoleId(Long roleId) {
        return WorkRolesServiceHelper.getMainChargeRoleByRoleId((Long)roleId);
    }

    public Long getOrgIdByRoleId(Long roleId) {
        return WorkRolesServiceHelper.getOrgIdByRoleId((Long)roleId);
    }

    public DynamicObject getRoleByRoleId(Long roleId) {
        return WorkRolesServiceHelper.getRoleByRoleId((Long)roleId);
    }

    public Long getRoleIdByPositionId(Long positionId) {
        return WorkRolesServiceHelper.getRoleIdByPositionId((Long)positionId);
    }

    public DynamicObject getMainChargeRoleByOrgId(Long orgId) {
        return WorkRolesServiceHelper.getMainChargeRoleByOrgId((Long)orgId);
    }

    public DynamicObject[] getNotMainChargeRoleByOrgId(Long orgId) {
        return WorkRolesServiceHelper.getNotMainChargeRoleByOrgId((Long)orgId);
    }

    public DynamicObject getPositionByRoleId(Long RoleId) {
        return WorkRolesServiceHelper.getPositionByRoleId((Long)RoleId);
    }

    public void createNewReportingRelation(DynamicObject role, Long adminorgId, DynamicObject parentRole, String enable) {
        WorkRolesServiceHelper.createNewReportingRelation((DynamicObject)role, (Long)adminorgId, (DynamicObject)parentRole, (String)enable);
    }

    public void enableReportingRelation(Long roleId) {
        WorkRolesServiceHelper.enableReportingRelation((Long)roleId);
    }

    public DynamicObject getReportingRelationByRoleId(Long roleId) {
        return WorkRolesServiceHelper.getReportingRelationByRoleId((Long)roleId);
    }

    public void disableReportingRelation(Long roleId) {
        WorkRolesServiceHelper.disableReportingRelation((Long)roleId);
    }

    public void addNewPersonRoleRelations(Long roleId, Map<String, Object> person, Date date) {
        ArrayList<Map<String, Object>> personList = new ArrayList<Map<String, Object>>();
        personList.add(person);
        PersonRoleRelServiceHelper.addNewRelations((Long)roleId, personList, (Date)date);
    }

    public void deletePersonRoleRelations(Long roleId, Long personId, String personModel, Date endData) {
        PersonRoleRelServiceHelper.deleteRelation((Long)roleId, (Long)personId, (String)personModel, (Date)endData);
    }

    public DynamicObjectCollection getRoleByPersonId(Long personId) {
        return WorkRolesServiceHelper.getRolesByPersonId((Long)personId);
    }

    public DynamicObject[] getMainChargePeoByOrgId(List<Long> orgIdList) {
        return PersonRoleRelServiceHelper.getMainChargePeoByOrgId(orgIdList);
    }

    public List<Long> getOrgListFromPermFiles(Long userId) {
        return PermFilesServiceHelper.getOrgListFromPermFiles((Long)userId, (Boolean)Boolean.TRUE);
    }

    public List<Long> getEmpgrpListFromPermFiles(Long userId, String entityName, String appId) {
        return PermFilesServiceHelper.getEmpgrpListFromPermFiles((Long)userId, (Boolean)true, (String)entityName, (String)appId);
    }

    public void addNewPersonRolesRelations(List<Long> roleIds, Map<String, Object> personMap, Date effectDate) {
        PersonRoleRelServiceHelper.addNewRelations(roleIds, personMap, (Date)effectDate);
    }

    public void deletePersonRolesRelations(List<Long> roleIds, Long personId, String personModel, Date endDate) {
        PersonRoleRelServiceHelper.deleteRelations(roleIds, (Long)personId, (String)personModel, (Date)endDate);
    }

    public DynamicObjectCollection getRolesHisByPersonId(Long personId) {
        return WorkRolesServiceHelper.getRolesHisByPersonId((Long)personId);
    }

    public Map<Long, List<Long>> getSuperiorByAdministrativeReport(Long personId, Long roleId, Long empposorgrelId) {
        return WorkRolesServiceHelper.getSuperiorByAdministrativeReport((Long)personId, (Long)roleId, (Long)empposorgrelId);
    }

    public List<Long> getAllOrgListFromPermFiles(Long userId) {
        return PermFilesServiceHelper.getOrgListFromPermFiles((Long)userId, (Boolean)Boolean.FALSE);
    }

    public Map<Long, Map<Long, List<Long>>> getSuperiors(List<Long> personIds) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(personIds.size());
        for (Long personId : personIds) {
            HashMap<String, Long> tempMap = new HashMap<String, Long>();
            tempMap.put("id", personId);
            result.add(tempMap);
        }
        return this.getSuperiorsByParam(result);
    }

    public Map<Long, Map<Long, List<Long>>> getSuperiorsByParam(List<Map<String, Object>> params) {
        return WorkRolesServiceHelper.getSuperiors(params);
    }

    public void saveActionType(DynamicObject dy) {
        MsgCenterServiceHelper.saveActionType((DynamicObject)dy);
    }

    public void saveAction(DynamicObject dy) {
        MsgCenterServiceHelper.saveAction((DynamicObject)dy);
    }

    public void batchAddNewPersonRolesRelations(List<PersonRelaitionModel> relations) {
        PersonRoleRelServiceHelper.batchAddNewRelations(relations);
    }

    public Map<String, Object> getHrBuCaDyByAppNumber(String appNumber) {
        return HRBUCAServiceHelper.getHrBuCaDyByAppNumber((String)appNumber);
    }

    public DynamicObject[] getEnableBosOrgStructureByAppNumber(String appNumber) {
        return HRBUCAServiceHelper.getEnableBosOrgStructureByAppNumber((String)appNumber);
    }

    public List<Long> getEmpgroupByAppNumber(String appNumber) {
        return EmpGroupServiceHelper.getEmpgroupByAppNumber((String)appNumber);
    }

    public void integrationIData(DynamicObjectCollection iDataCollection) {
        OperationServiceImpl operationService = new OperationServiceImpl();
        operationService.localInvokeOperation("save", (DynamicObject[])iDataCollection.toArray((Object[])new DynamicObject[0]), OperateOption.create());
    }

    public Map<String, Object> getParamByEntity(String number) {
        return HRConfigServiceHelper.getParamByEntity((String)number);
    }

    public void relLawEntity(String entityName, String opKey, DynamicObject[] dataEntities) {
        LawEntityServiceHelper.relLawEntity((String)entityName, (String)opKey, (DynamicObject[])dataEntities);
    }

    public void syncDuty(String orgNumber) {
        String cacheKey;
        LOGGER.info("HBSSService.syncDuty start");
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("bos_org_structure");
        DynamicObject orgDy = orgHelper.queryOne("enable", new QFilter[]{new QFilter("org.number", "=", (Object)orgNumber), new QFilter("view", "=", (Object)HRBUConstants.HR_VIEW_ID)});
        if (Objects.isNull(orgDy)) {
            LOGGER.info("HBSSService.syncDuty not hrbu,return");
            return;
        }
        LocalCacheUtils instance = LocalCacheUtils.getInstance();
        LocalMemoryCache localCache = instance.getShortTimeLocalCache();
        Object cache = localCache.get(cacheKey = instance.getSyncDutyCacheKey(orgNumber));
        if (Objects.nonNull(cache)) {
            LOGGER.info("HBSSService.syncDuty has cached");
            return;
        }
        localCache.put(cacheKey, (Object)orgNumber);
        HRBuSync.syncHrBu();
        LOGGER.info("HBSSService.syncDuty end");
    }
}

