/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.mservice;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.PersonRoleRelServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.WorkRolesServiceHelper;
import kd.hr.hbss.mservice.api.IHBSSWorkFlowService;

public class HBSSWorkFlowService
implements IHBSSWorkFlowService {
    private static final Log logger = LogFactory.getLog(HBSSWorkFlowService.class);
    public static final String KEY_ADMINORG = "adminorg";
    public static final String KEY_POSITION = "position";
    private static final String FIELD_REPORTING_TYPE = "reportingtype";
    private static final String FIELD_PARENT_ID = "parent.id";
    private static HRBaseServiceHelper roleRelHelper = new HRBaseServiceHelper("hbss_personrolerel");
    private static HRBaseServiceHelper reportRelHelper = new HRBaseServiceHelper("hbss_reportingrelation");
    private static HRBaseServiceHelper adminOrgHelper = new HRBaseServiceHelper("haos_adminorghr");
    private static HRBaseServiceHelper positionHelper = new HRBaseServiceHelper("hbss_position");
    private static HRBaseServiceHelper positionEmpListHelper = new HRBaseServiceHelper("haos_positionemplist");
    private static final String PARAM_ROLETYPE = "roletype";
    private static final String PARAM_ADMINORG = "adminorg";
    private static final String PARAM_POSITION = "position";
    private static final Long LONG_NONVALUE = -1L;
    private static final Long REPORTTYPE_ADM = 1010L;
    private static final String RESULT_PERSONID_MSG = "resultPersonIds:";
    private static final String REFRENCEPERSON_MSG = "referencepersons:";
    private static final String ROLE_ID = "role.id";
    private static final String PERSON_ID = "person.id";

    private void printLog(String msg) {
        if (logger.isInfoEnabled()) {
            logger.info(msg);
        }
    }

    public List<Long> getSelfIdByRole(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        Long roleTypeId = this.getRoleTypeId(params);
        List<Long> adminOrgId = this.getParamId(params, "adminorg");
        List<Long> roleIds = this.getTargetTypeRoleIdsByPersonIds(referencePersons, roleTypeId, adminOrgId);
        List<Long> selfrRoleIds = this.getAdminRole(roleIds);
        List<Long> resultPersonIds = this.getPersonIdsByRoleIds(selfrRoleIds);
        this.printLog(REFRENCEPERSON_MSG + resultPersonIds);
        return resultPersonIds;
    }

    public List<Long> getIndirectSuperiorIdByRole(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        this.printLog(REFRENCEPERSON_MSG + referencePersons);
        Long roleTypeId = this.getRoleTypeId(params);
        List<Long> adminOrgId = this.getParamId(params, "adminorg");
        List<Long> roleIds = this.getTargetTypeRoleIdsByPersonIds(referencePersons, roleTypeId, adminOrgId);
        List<Long> superiorRoleIds = this.getParentsByRole(roleIds);
        List<Long> indirectSuperiorRoleIds = this.getParentsByRole(superiorRoleIds);
        List<Long> resultPersonIds = this.getPersonIdsByRoleIds(indirectSuperiorRoleIds);
        this.printLog(RESULT_PERSONID_MSG + resultPersonIds);
        return resultPersonIds;
    }

    public List<Long> getSuperiorIdByRole(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        this.printLog(REFRENCEPERSON_MSG + referencePersons);
        Long roleTypeId = this.getRoleTypeId(params);
        List<Long> adminOrgId = this.getParamId(params, "adminorg");
        List<Long> roleIds = this.getTargetTypeRoleIdsByPersonIds(referencePersons, roleTypeId, adminOrgId);
        List<Long> superiorRoleIds = this.getParentsByRole(roleIds);
        List<Long> resultPersonIds = this.getPersonIdsByRoleIds(superiorRoleIds);
        this.printLog(RESULT_PERSONID_MSG + resultPersonIds);
        return resultPersonIds;
    }

    public List<Long> getEqualIdByRole(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        this.printLog(REFRENCEPERSON_MSG + referencePersons);
        Long roleTypeId = this.getRoleTypeId(params);
        List<Long> adminOrgId = this.getParamId(params, "adminorg");
        List<Long> roleIds = this.getTargetTypeRoleIdsByPersonIds(referencePersons, roleTypeId, adminOrgId);
        List<Long> superiorRoleIds = this.getParentsByRole(roleIds);
        List<Long> equalRoleIds = this.getChildsByRole(superiorRoleIds);
        List<Long> resultPersonIds = this.getPersonIdsByRoleIds(equalRoleIds);
        for (Long referencePerson : referencePersons) {
            resultPersonIds.remove(referencePerson);
        }
        this.printLog(RESULT_PERSONID_MSG + resultPersonIds);
        return resultPersonIds;
    }

    public List<Long> getSubordinateIdByRole(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        this.printLog(REFRENCEPERSON_MSG + referencePersons);
        Long roleTypeId = this.getRoleTypeId(params);
        List<Long> adminOrgId = this.getParamId(params, "adminorg");
        List<Long> roleIds = this.getTargetTypeRoleIdsByPersonIds(referencePersons, roleTypeId, adminOrgId);
        List<Long> childRoleIds = this.getChildsByRole(roleIds);
        List<Long> resultPersonIds = this.getPersonIdsByRoleIds(childRoleIds);
        this.printLog(RESULT_PERSONID_MSG + resultPersonIds);
        return resultPersonIds;
    }

    public List<Long> getSelfIdByAdminorg(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> adminOrgIds = this.getParamId(params, "adminorg");
        List<Long> resultPersonIds = this.getMainLeaderIdByAdminOrg(adminOrgIds);
        return resultPersonIds;
    }

    public List<Long> getIndirectSuperiorIdByAdminorg(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> adminOrgIds = this.getParamId(params, "adminorg");
        List<Long> leaderOrgIds = this.getLeaderAdminOrg(adminOrgIds);
        List<Long> indirectLeaderOrgIds = this.getLeaderAdminOrg(leaderOrgIds);
        List<Long> resultPersonIds = this.getMainLeaderIdByAdminOrg(indirectLeaderOrgIds);
        return resultPersonIds;
    }

    public List<Long> getSuperiorIdByAdminorg(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> adminOrgIds = this.getParamId(params, "adminorg");
        List<Long> leaderOrgIds = this.getLeaderAdminOrg(adminOrgIds);
        List<Long> resultPersonIds = this.getMainLeaderIdByAdminOrg(leaderOrgIds);
        return resultPersonIds;
    }

    public List<Long> getEqualIdByAdminorg(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> adminOrgIds = this.getParamId(params, "adminorg");
        List<Long> leaderOrgIds = this.getLeaderAdminOrg(adminOrgIds);
        List<Long> equalOrgIds = this.getChildAdminOrg(leaderOrgIds);
        List<Long> resultPersonIds = this.getMainLeaderIdByAdminOrg(equalOrgIds);
        return resultPersonIds;
    }

    public List<Long> getSubordinateIdByAdminorg(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> adminOrgIds = this.getParamId(params, "adminorg");
        List<Long> equalOrgIds = this.getChildAdminOrg(adminOrgIds);
        List<Long> resultPersonIds = this.getMainLeaderIdByAdminOrg(equalOrgIds);
        return resultPersonIds;
    }

    public List<Long> getSelfIdByPosition(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> positionIds = this.getParamId(params, "position");
        List<Long> resultPersonIds = this.getPersonIdsByPositionIds(positionIds);
        return resultPersonIds;
    }

    public List<Long> getIndirectSuperiorIdByPosition(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> positionIds = this.getParamId(params, "position");
        List<Long> leaderIds = this.getLeaderPosition(positionIds);
        List<Long> indirectLeaderIds = this.getLeaderPosition(leaderIds);
        List<Long> resultPersonIds = this.getPersonIdsByPositionIds(indirectLeaderIds);
        return resultPersonIds;
    }

    public List<Long> getSuperiorIdByPosition(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> positionIds = this.getParamId(params, "position");
        List<Long> leaderIds = this.getLeaderPosition(positionIds);
        List<Long> resultPersonIds = this.getPersonIdsByPositionIds(leaderIds);
        return resultPersonIds;
    }

    public List<Long> getEqualIdByPosition(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> positionIds = this.getParamId(params, "position");
        List<Long> leaderIds = this.getLeaderPosition(positionIds);
        List<Long> equalIds = this.getChildPosition(leaderIds);
        List<Long> resultPersonIds = this.getPersonIdsByPositionIds(equalIds);
        return resultPersonIds;
    }

    public List<Long> getSubordinateIdByPosition(List<Long> referencePersons, String businessKey, String entityNumber, Map<String, Object> params) {
        List<Long> positionIds = this.getParamId(params, "position");
        List<Long> childIds = this.getChildPosition(positionIds);
        List<Long> resultPersonIds = this.getPersonIdsByPositionIds(childIds);
        return resultPersonIds;
    }

    private List<Long> getTargetTypeRoleIdsByPersonIds(List<Long> personIds, long roleTypeId, List<Long> adminOrgId) {
        QFilter filter = new QFilter("person", "in", personIds);
        QFilter filter2 = new QFilter("role.roletype", "=", (Object)roleTypeId);
        QFilter filter3 = new QFilter("role.adminorg", "in", adminOrgId);
        QFilter filter4 = new QFilter("iseffective", "=", (Object)Boolean.TRUE);
        String selProp = ROLE_ID;
        DynamicObject[] relDys = roleRelHelper.query(selProp, new QFilter[]{filter, filter2, filter3, filter4});
        ArrayList<Long> roleIds = new ArrayList<Long>(relDys.length);
        for (DynamicObject relDy : relDys) {
            roleIds.add(relDy.getLong(selProp));
        }
        return roleIds;
    }

    private List<Long> getPersonIdsByRoleIds(List<Long> roleIds) {
        QFilter filter = new QFilter(ROLE_ID, "in", roleIds);
        QFilter enableFilter = new QFilter("iseffective", "=", (Object)Boolean.TRUE);
        String selProp = PERSON_ID;
        DynamicObject[] relDys = roleRelHelper.query(selProp, new QFilter[]{filter, enableFilter});
        ArrayList<Long> personIds = new ArrayList<Long>(relDys.length);
        for (DynamicObject relDy : relDys) {
            personIds.add(relDy.getLong(selProp));
        }
        return personIds;
    }

    private Long getRoleTypeId(Map<String, Object> params) {
        if (params.get(PARAM_ROLETYPE) instanceof DynamicObject) {
            DynamicObject roleType = (DynamicObject)params.get(PARAM_ROLETYPE);
            if (roleType == null) {
                return LONG_NONVALUE;
            }
            Long roleTypeId = roleType.getLong("id");
            return roleTypeId;
        }
        return LONG_NONVALUE;
    }

    private List<Long> getParamId(Map<String, Object> params, String paramKey) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (params.get(paramKey) instanceof DynamicObject) {
            DynamicObject paramDy = (DynamicObject)params.get(paramKey);
            if (paramDy == null) {
                return result;
            }
            Long paramId = paramDy.getLong("id");
            result.add(paramId);
        } else if (params.get(paramKey) instanceof List) {
            List orgs = (List)params.get(paramKey);
            this.putIdToList(orgs, result);
        }
        return result;
    }

    private void putIdToList(List<Object> params, List<Long> list) {
        for (Object param : params) {
            if (param instanceof DynamicObject) {
                DynamicObject orgDy = (DynamicObject)param;
                list.add(orgDy.getLong("id"));
                continue;
            }
            if (!(param instanceof List)) continue;
            this.putIdToList((List)param, list);
        }
    }

    private List<Long> getParentsByRole(List<Long> currentId) {
        QFilter filter = new QFilter("role", "in", currentId);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        QFilter filter3 = new QFilter(FIELD_REPORTING_TYPE, "=", (Object)REPORTTYPE_ADM);
        String selProp = FIELD_PARENT_ID;
        DynamicObject[] roleDys = reportRelHelper.query(selProp, new QFilter[]{filter, filter2, filter3});
        ArrayList<Long> roleIds = new ArrayList<Long>(roleDys.length);
        for (DynamicObject roleDy : roleDys) {
            roleIds.add(roleDy.getLong(selProp));
        }
        return roleIds;
    }

    private List<Long> getChildsByRole(List<Long> currentId) {
        QFilter filter = new QFilter("parent", "in", currentId);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        QFilter filter3 = new QFilter(FIELD_REPORTING_TYPE, "=", (Object)REPORTTYPE_ADM);
        String selProp = ROLE_ID;
        DynamicObject[] roleDys = reportRelHelper.query(selProp, new QFilter[]{filter, filter2, filter3});
        ArrayList<Long> roleIds = new ArrayList<Long>(roleDys.length);
        for (DynamicObject roleDy : roleDys) {
            roleIds.add(roleDy.getLong(selProp));
        }
        return roleIds;
    }

    private List<Long> getAdminRole(List<Long> currentId) {
        QFilter filter = new QFilter(ROLE_ID, "in", currentId);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        QFilter filter3 = new QFilter(FIELD_REPORTING_TYPE, "=", (Object)REPORTTYPE_ADM);
        String selProp = ROLE_ID;
        DynamicObject[] roleDys = reportRelHelper.query(selProp, new QFilter[]{filter, filter2, filter3});
        ArrayList<Long> roleIds = new ArrayList<Long>(roleDys.length);
        for (DynamicObject roleDy : roleDys) {
            roleIds.add(roleDy.getLong(selProp));
        }
        return roleIds;
    }

    private List<Long> distinctLong(List<Long> list) {
        HashSet<Long> set = new HashSet<Long>(list);
        return new ArrayList<Long>(set);
    }

    private List<Long> getLeaderAdminOrg(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        String selProp = FIELD_PARENT_ID;
        DynamicObject[] dys = adminOrgHelper.query(selProp, new QFilter[]{filter, filter2});
        ArrayList<Long> result = new ArrayList<Long>(dys.length);
        for (DynamicObject dy : dys) {
            result.add(dy.getLong(selProp));
        }
        return result;
    }

    private List<Long> getChildAdminOrg(List<Long> ids) {
        QFilter filter = new QFilter("parent", "in", ids);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dys = adminOrgHelper.query(new QFilter[]{filter, filter2});
        ArrayList<Long> result = new ArrayList<Long>(dys.length);
        for (DynamicObject dy : dys) {
            result.add(dy.getLong("id"));
        }
        return result;
    }

    private List<Long> getMainLeaderIdByAdminOrg(List<Long> ids) {
        DynamicObject[] roleDys = PersonRoleRelServiceHelper.getMainChargePeoByOrgId(ids);
        ArrayList<Long> roleIds = new ArrayList<Long>(roleDys.length);
        for (DynamicObject roleDy : roleDys) {
            roleIds.add(roleDy.getLong(PERSON_ID));
        }
        return roleIds;
    }

    private List<Long> getRoleByPositionId(List<Long> positionIds) {
        DynamicObject[] roleIds = WorkRolesServiceHelper.getRoleByPositionId(positionIds, (String)"id");
        ArrayList<Long> result = new ArrayList<Long>(roleIds.length);
        for (DynamicObject roleId : roleIds) {
            result.add(roleId.getLong("id"));
        }
        return result;
    }

    private List<Long> getLeaderPosition(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        String selProp = FIELD_PARENT_ID;
        DynamicObject[] dys = positionHelper.query(selProp, new QFilter[]{filter, filter2});
        ArrayList<Long> result = new ArrayList<Long>(dys.length);
        for (DynamicObject dy : dys) {
            result.add(dy.getLong(selProp));
        }
        return result;
    }

    private List<Long> getChildPosition(List<Long> ids) {
        QFilter filter = new QFilter("parent", "in", ids);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        String selProp = "id";
        DynamicObject[] dys = positionHelper.query(selProp, new QFilter[]{filter, filter2});
        ArrayList<Long> result = new ArrayList<Long>(dys.length);
        for (DynamicObject dy : dys) {
            result.add(dy.getLong(selProp));
        }
        return result;
    }

    private List<Long> getPersonIdsByPositionIds(List<Long> positionIds) {
        QFilter positionfilter = new QFilter("position.id", "in", positionIds);
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        String selProp = PERSON_ID;
        DynamicObject[] relDys = positionEmpListHelper.query(selProp, new QFilter[]{positionfilter, statusFilter});
        ArrayList<Long> personIds = new ArrayList<Long>(relDys.length);
        for (DynamicObject relDy : relDys) {
            personIds.add(relDy.getLong(selProp));
        }
        return personIds;
    }
}

