/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.mservice.update;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class UserPermfileUpgradeService
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog(" update permfile history data ");
        this.upgradeUserPermfile();
        result.setSuccess(true);
        return result;
    }

    private void upgradeUserPermfile() {
        Serializable userId;
        DBRoute hbssDbRoute = new DBRoute("hmp");
        DBRoute sysDbRoute = new DBRoute("sys");
        String permfileSql = "select fid,fuserid from t_hbss_permfiles ";
        String updateSql = "update t_hbss_permfiles set fname = ? where fid = ? ";
        HashSet userSet = Sets.newHashSetWithExpectedSize((int)16);
        LinkedHashMap permfileMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"UserPermfileUpgradeService_permfile", (DBRoute)hbssDbRoute, (String)permfileSql, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                userId = row.getLong("fuserid");
                Long permfileId = row.getLong("fid");
                userSet.add(((Long)userId).toString());
                permfileMap.put(permfileId, userId);
            }
        }
        if (userSet.size() == 0) {
            return;
        }
        String userSql = "select fid,ftruename from t_sec_user where fid in (" + String.join((CharSequence)",", userSet) + ") ";
        HashMap userMap = Maps.newHashMapWithExpectedSize((int)16);
        DataSet dataSet = HRDBUtil.queryDataSet((String)"UserPermfileUpgradeService_user", (DBRoute)sysDbRoute, (String)userSql, null);
        userId = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long userId2 = row.getLong("fid");
                String userName = row.getString("ftruename");
                if (HRStringUtils.isEmpty((String)userName)) continue;
                userMap.put(userId2, userName);
            }
        }
        catch (Throwable throwable) {
            userId = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (userId != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)userId).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        Object[] paramArr = null;
        for (Map.Entry permfile : permfileMap.entrySet()) {
            String name = (String)userMap.get(permfile.getValue());
            if (HRStringUtils.isEmpty((String)name)) continue;
            paramArr = new Object[]{userMap.get(permfile.getValue()), permfile.getKey()};
            paramsList.add(paramArr);
            if (paramsList.size() <= 5000) continue;
            HRDBUtil.executeBatch((DBRoute)hbssDbRoute, (String)updateSql, paramsList);
            paramsList = new ArrayList(16);
        }
        if (paramsList.size() > 0) {
            HRDBUtil.executeBatch((DBRoute)hbssDbRoute, (String)updateSql, paramsList);
        }
    }
}

