/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hbss.formplugin.web.EntityFieldListDataProvider;
import kd.hr.hbss.formplugin.web.help.EntityFieldHelper;

public class EntityFieldList
extends HRDataBaseList {
    private static final String BTNOK = "btnok";
    private static final String BILLISTAP = "billlistap";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        EntityFieldListDataProvider provider = new EntityFieldListDataProvider();
        args.setListDataProvider((IListDataProvider)provider);
    }

    public void setFilter(SetFilterEvent event) {
        String entityNumber = this.getEntityNumber();
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        QFilter entityNumberFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
        event.getQFilters().add(entityNumberFilter);
    }

    public void beforeClick(BeforeClickEvent evt) {
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            if (BTNOK.equalsIgnoreCase(btn.getKey())) {
                this.getView().returnDataToParent((Object)this.getFieldData());
                this.getView().close();
            }
        } else {
            super.beforeClick(evt);
        }
    }

    public ListSelectedRowCollection getFieldData() {
        List<IDataEntityProperty> fields = EntityFieldHelper.getFields(this.getEntityNumber());
        BillList billlist = (BillList)this.getControl(BILLISTAP);
        ListSelectedRowCollection rows = billlist.getSelectedRows();
        rows.forEach(row -> {
            int index = row.getRowKey();
            DynamicProperty property = (DynamicProperty)fields.get(index);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("fieldname", property.getName());
            result.put("fieldalias", (String)property.getDisplayName());
            result.put("ftblfield", property.getAlias());
            row.setDataMap(result);
        });
        return rows;
    }

    private String getEntityNumber() {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (!HRStringUtils.isEmpty((String)entityNumber)) {
            return entityNumber;
        }
        IFormView parentView = this.getView().getParentView();
        if (this.isParentStructConfig(parentView)) {
            return parentView.getModel().getValue("entitynumber").toString();
        }
        return "";
    }

    private boolean isParentStructConfig(IFormView parentView) {
        return "hbss_structconfig".equals(parentView.getFormShowParameter().getFormId());
    }
}

