/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.formplugin.web.QueryStructEdit;
import kd.hr.hbss.formplugin.web.help.EntityFieldHelper;

public class FileSyncEdit
extends HRDataBaseEdit
implements CellClickListener {
    private static final String FIELD_MAP = "fieldmap";
    private static final String PREFILE_FIELD = "prefilefield";
    private static final String EMPFILE_FIELD = "empfilefield";
    private static final String PREFILE_TABLE = "prefiletable";
    private static final String EMPFILE_TABLE = "empfiletable";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid structColumn = (EntryGrid)this.getControl(FIELD_MAP);
        structColumn.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent event) {
        if (HRStringUtils.equals((String)PREFILE_FIELD, (String)event.getFieldKey())) {
            this.openPreFileFieldF7();
            return;
        }
        if (HRStringUtils.equals((String)EMPFILE_FIELD, (String)event.getFieldKey())) {
            this.openEmpFileFieldF7();
            return;
        }
    }

    private void openEmpFileFieldF7() {
        DynamicObject empFilEntity = (DynamicObject)this.getModel().getValue(EMPFILE_TABLE);
        if (null == empFilEntity) {
            return;
        }
        String entityNumber = empFilEntity.getString("number");
        this.openFieldF7(EMPFILE_FIELD, false, entityNumber);
    }

    private void openPreFileFieldF7() {
        DynamicObject preFilEntity = (DynamicObject)this.getModel().getValue(PREFILE_TABLE);
        if (null == preFilEntity) {
            return;
        }
        String entityNumber = preFilEntity.getString("number");
        this.openFieldF7(PREFILE_FIELD, false, entityNumber);
    }

    private void openFieldF7(String actionId, boolean isMultiSelect, String entityNumber) {
        ListShowParameter formShowParameter = EntityFieldHelper.createFieldF7ShowParam(actionId, isMultiSelect, "hbss_entityfield", (IFormPlugin)this);
        formShowParameter.setCustomParam("entitynumber", (Object)entityNumber);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        int index;
        Map<String, Object> dataMap;
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(PREFILE_FIELD)) {
            dataMap = QueryStructEdit.getSelectedRowDataMap(closedCallBackEvent);
            if (null == dataMap) {
                return;
            }
            index = this.getModel().getEntryCurrentRowIndex(FIELD_MAP);
            this.getModel().setValue(PREFILE_FIELD, dataMap.get("fieldname"), index);
        }
        if (actionId.equals(EMPFILE_FIELD)) {
            dataMap = QueryStructEdit.getSelectedRowDataMap(closedCallBackEvent);
            if (null == dataMap) {
                return;
            }
            index = this.getModel().getEntryCurrentRowIndex(FIELD_MAP);
            this.getModel().setValue(EMPFILE_FIELD, dataMap.get("fieldname"), index);
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

