/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.formplugin.web.HREntityObjectDataProvider;

public class HREntityObjectPlugin
extends StandardTreeListPlugin
implements RowClickEventListener,
ClickListener {
    private static final String BILLISTAP = "billlistap";
    private static final String BTNOK = "btnok";
    private static final String HRCLOUDID = "11FWSEDXBS99";
    private static final String HBSS_QUERYREGIST = "hbss_querypageregist";
    private static final String SELECTACTION = "selectaction";
    private static final String FIELD_EDIT = "FieldEdit";
    private static final String DO_OPEN_PARENT = "doOpenParent";
    private static final String PAGEINFO = "pageinfo";
    private static final String NUMBER = "number";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String META_TYPE = "metaType";
    private static final String ITEM_ID = "itemId";
    private static final String VALUE = "value";

    public void initializeTree(EventObject e) {
        this.intiTree();
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button btn = (Button)this.getControl(BTNOK);
        if (btn != null) {
            btn.addClickListener((ClickListener)this);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new HREntityObjectDataProvider());
    }

    private String booleanConvert(Boolean temp) {
        return temp != false ? "1" : "0";
    }

    private List<QFilter> addModelFilter(Boolean isTemplate, Map<String, Boolean> businessControlConfig) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (isTemplate.booleanValue()) {
            list.add(new QFilter("istemplate", "=", (Object)"1"));
        }
        if (businessControlConfig != null && businessControlConfig.size() > 0) {
            Boolean voucherValue;
            Boolean botpValue;
            Boolean workflowValue;
            Boolean billtypeValue;
            Boolean codenumberValue = businessControlConfig.get("codenumber");
            if (Objects.nonNull(codenumberValue)) {
                list.add(new QFilter("codenumber", "=", (Object)this.booleanConvert(codenumberValue)));
            }
            if (Objects.nonNull(billtypeValue = businessControlConfig.get("billtype"))) {
                list.add(new QFilter("billtype", "=", (Object)this.booleanConvert(billtypeValue)));
            }
            if (Objects.nonNull(workflowValue = businessControlConfig.get("workflow"))) {
                list.add(new QFilter("workflow", "=", (Object)this.booleanConvert(workflowValue)));
            }
            if (Objects.nonNull(botpValue = businessControlConfig.get("botp"))) {
                list.add(new QFilter("botp", "=", (Object)this.booleanConvert(botpValue)));
            }
            if (Objects.nonNull(voucherValue = businessControlConfig.get("voucher"))) {
                list.add(new QFilter("voucher", "=", (Object)this.booleanConvert(voucherValue)));
            }
        }
        return list;
    }

    public void beforeClick(BeforeClickEvent evt) {
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            String type = (String)this.getView().getFormShowParameter().getCustomParam(SELECTACTION);
            if (type != null) {
                if (BTNOK.equalsIgnoreCase(btn.getKey()) && type.equals(FIELD_EDIT)) {
                    this.returnData();
                } else if (BTNOK.equalsIgnoreCase(btn.getKey()) && type.equals(DO_OPEN_PARENT)) {
                    this.getView().returnDataToParent(this.getCurrentSelector());
                    this.getView().close();
                }
            } else {
                BillList billList = (BillList)this.getView().getControl(BILLISTAP);
                this.getView().returnDataToParent((Object)billList.getSelectedRows());
                if (this.getView().getParentView().getEntityId().equals(HBSS_QUERYREGIST)) {
                    this.getView().getParentView().getModel().setValue(PAGEINFO, (Object)billList.getSelectedRows().get(0));
                    this.getView().getParentView().getModel().setValue("name", (Object)billList.getSelectedRows().get(0).getName());
                    this.getView().getParentView().getModel().setValue(NUMBER, (Object)billList.getSelectedRows().get(0).getNumber());
                }
                this.getView().close();
            }
            evt.setCancel(true);
        } else {
            super.beforeClick(evt);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam(SELECTACTION);
        if (type != null) {
            if (BTNOK.equalsIgnoreCase(evt.getItemKey()) && type.equals(FIELD_EDIT)) {
                this.returnData();
            } else if (BTNOK.equalsIgnoreCase(evt.getItemKey()) && type.equals(DO_OPEN_PARENT)) {
                this.getView().returnDataToParent(this.getCurrentSelector());
                this.getView().close();
            }
        } else {
            BillList billList = (BillList)this.getView().getControl(BILLISTAP);
            this.getView().returnDataToParent((Object)billList.getSelectedRows());
            if (this.getView().getParentView().getEntityId().equals(HBSS_QUERYREGIST)) {
                this.getView().getParentView().getModel().setValue(PAGEINFO, (Object)billList.getSelectedRows().get(0));
                this.getView().getParentView().getModel().setValue("name", (Object)billList.getSelectedRows().get(0).getName());
                this.getView().getParentView().getModel().setValue(NUMBER, (Object)billList.getSelectedRows().get(0).getNumber());
            }
            this.getView().close();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        this.clickEvent();
        evt.setCancel(true);
    }

    public void returnData() {
        Object oldId;
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null && !ObjectUtils.nullSafeEquals(oldId = this.getView().getFormShowParameter().getCustomParams().get(VALUE), (Object)row.get(NUMBER))) {
            ArrayList paras = new ArrayList();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put(VALUE, row.get("id"));
            para.put("alias", row.get("name").toString());
            paras.add(para);
            para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, "RefProps");
            para.put(VALUE, new ArrayList());
            paras.add(para);
            para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, "DefValue");
            para.put(VALUE, "");
            paras.add(para);
            para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, "RefLayout");
            para.put(VALUE, "");
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"btnnew", "btnedit", "btndel"});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"btnnew"});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{"btnedit", "btndel"});
        }
    }

    public Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ListSelectedRow lsr = ((BillList)this.getView()).getCurrentSelectedRowInfo();
        if (lsr == null) {
            return null;
        }
        ORM orm = ORM.create();
        QFilter filter = new QFilter(NUMBER, "=", lsr.getPrimaryKeyValue());
        DynamicObject doj = orm.queryOne("bos_entityobject", new QFilter[]{filter});
        ret.put("id", doj.get("dentityid"));
        ret.put(NUMBER, doj.get(NUMBER));
        ret.put("name", doj.get("name"));
        return ret;
    }

    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("dentityid", "is not null", (Object)"");
        } else if (isCloud) {
            List<String> units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter("bizappid", "in", units);
        } else {
            qFilter = new QFilter("bizappid", "=", (Object)nodeId);
        }
        return qFilter;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        super.buildTreeListFilter(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        QFilter modelFilter = this.filter();
        modelFilter.and(this.getModelFilter(nodeId));
        nodeEvent.addQFilter(modelFilter);
        nodeEvent.setCancel(true);
    }

    public void setFilter(SetFilterEvent event) {
        QFilter typeFilter = this.filter();
        Boolean ismodel = (Boolean)this.getView().getFormShowParameter().getCustomParam("ismodel");
        Map businessControlConfig = (Map)this.getView().getFormShowParameter().getCustomParam("businesscontrol");
        List<QFilter> list = ismodel != null ? this.addModelFilter(ismodel, businessControlConfig) : this.addModelFilter(Boolean.FALSE, businessControlConfig);
        for (QFilter filters : list) {
            typeFilter.and(filters);
        }
        ArrayList<QFilter> templist1 = new ArrayList<QFilter>();
        templist1.add(typeFilter);
        List filters1 = event.getQFilters();
        filters1.addAll(templist1);
        event.setQFilters(filters1);
    }

    private void intiTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"HREntityObjectPlugin_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        for (TreeNode treeNode : cloudNodes) {
            List<TreeNode> groupNodes = this.getAppNodes(treeNode.getId());
            this.addChildNode(treeNode, groupNodes);
        }
        root.addChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.clickEvent();
        evt.setCancel(true);
    }

    private void clickEvent() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam(SELECTACTION);
        if (type != null) {
            if (type.equals(FIELD_EDIT)) {
                this.returnData();
            } else if (type.equals(DO_OPEN_PARENT)) {
                this.getView().returnDataToParent(this.getCurrentSelector());
                this.getView().close();
            }
        } else {
            BillList billList = (BillList)this.getView().getControl(BILLISTAP);
            if (this.getView().getParentView().getEntityId().equals(HBSS_QUERYREGIST)) {
                this.getView().getParentView().getModel().setValue(PAGEINFO, (Object)billList.getSelectedRows().get(0));
                this.getView().getParentView().getModel().setValue("name", (Object)billList.getSelectedRows().get(0).getName());
                this.getView().getParentView().getModel().setValue(NUMBER, (Object)billList.getSelectedRows().get(0).getNumber());
            }
            this.getView().returnDataToParent((Object)billList.getSelectedRows());
            this.getView().close();
        }
    }

    private List<TreeNode> getCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            if (!HRStringUtils.equals((String)dynamicObject.getString("id"), (String)HRCLOUDID)) continue;
            node.setId(dynamicObject.getString("id"));
            node.setText(dynamicObject.getString("name"));
            node.setParentid("-1");
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private List<TreeNode> getAppNodes(String cloudId) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
        for (DynamicObject dynamicObject : dynamicObjects) {
            TreeNode node = new TreeNode();
            String nodeId = dynamicObject.getString("id");
            node.setId(nodeId);
            node.setText(dynamicObject.getString("name"));
            node.setParentid(cloudId);
            appNodes.add(node);
        }
        return appNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    public void refreshNode(RefreshNodeEvent event) {
        List<TreeNode> childNodes = this.getChildNodes(event.getNodeId());
        event.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(Object parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getCloudNodes();
            for (TreeNode treeNode : cloudNodes) {
                List<TreeNode> groupNodes = this.getAppNodes(treeNode.getId());
                this.addChildNode(treeNode, groupNodes);
            }
        }
        return cloudNodes;
    }

    protected List<String> getModelFilterContent() {
        String modeltype = (String)this.getView().getFormShowParameter().getCustomParam("modeltype");
        ArrayList<String> modelFilterContent = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)modeltype)) {
            modelFilterContent.add(modeltype);
        } else {
            modelFilterContent.add("BaseFormModel");
            modelFilterContent.add("BillFormModel");
            modelFilterContent.add("ReportFormModel");
            modelFilterContent.add("DynamicFormModel");
        }
        modelFilterContent.add("PCLayoutModel");
        return modelFilterContent;
    }

    protected QFilter filter() {
        return new QFilter("modeltype", "in", this.getModelFilterContent());
    }

    protected List<String> getUnitIdsByCloudId(String bizCloudId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("bizcloud", "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id";
        DynamicObjectCollection query = orm.query("bos_devportal_bizapp", selectFields, filters, "sequence asc");
        ArrayList<String> unitIds = new ArrayList<String>(query.size());
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String bizAppId = dynamicObject.getString("id");
            unitIds.add(bizAppId);
        }
        return unitIds;
    }
}

