/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.formplugin.web.help.EntityFieldHelper;

public class QueryConfigEdit
extends HRDataBaseEdit
implements CellClickListener {
    private static final String QUERY_COLUMN = "querycolumn";
    private static final String ADD_FIELD = "addfield";
    private static final String FIELDNAME = "fieldname";
    private static final String STRUCT_COLUMN = "structcolumn";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setStructConfig((DynamicObject)this.getModel().getValue("structconfig"));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        ChangeData[] changeDataArray = args.getChangeSet();
        if (changeDataArray.length < 1) {
            return;
        }
        DynamicObject dataEntity = changeDataArray[0].getDataEntity();
        switch (propertyName) {
            case "structconfig": {
                DynamicObject structConfig = dataEntity.getDynamicObject("structconfig");
                this.setStructConfig(structConfig);
                break;
            }
        }
    }

    private void setStructConfig(DynamicObject structConfig) {
        if (null == structConfig) {
            return;
        }
        DynamicObject configScm = structConfig.getDynamicObject("group");
        this.getModel().setValue("group", (Object)configScm);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid queryColumn = (EntryGrid)this.getControl(QUERY_COLUMN);
        queryColumn.addCellClickListener((CellClickListener)this);
        this.addItemClickListeners(new String[]{"querycolumntoolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (HRStringUtils.equals((String)ADD_FIELD, (String)evt.getItemKey())) {
            this.openQueryFieldF7(ADD_FIELD, true);
        }
    }

    public void cellClick(CellClickEvent event) {
        if (HRStringUtils.equals((String)FIELDNAME, (String)event.getFieldKey()) || HRStringUtils.equals((String)STRUCT_COLUMN, (String)event.getFieldKey())) {
            this.openQueryFieldF7(FIELDNAME, false);
            return;
        }
    }

    private void openQueryFieldF7(String actionId, boolean isMultiSelect) {
        ListShowParameter formShowParameter = EntityFieldHelper.createFieldF7ShowParam(actionId, isMultiSelect, "hbss_structcolumn", (IFormPlugin)this);
        DynamicObject structConfig = (DynamicObject)this.getModel().getValue("structconfig");
        if (null != structConfig) {
            formShowParameter.setCustomParam("structconfig", (Object)structConfig.getString("id"));
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(ADD_FIELD)) {
            ListSelectedRowCollection returnRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (null == returnRows || 0 == returnRows.size()) {
                return;
            }
            returnRows.forEach(row -> {
                Object fieldId = row.getPrimaryKeyValue();
                int index = this.getModel().createNewEntryRow(QUERY_COLUMN);
                this.setQueryColumn(fieldId, index);
            });
        }
        if (actionId.equals(FIELDNAME)) {
            ListSelectedRow row2 = this.getSelectedRow(closedCallBackEvent);
            if (null == row2) {
                return;
            }
            Object fieldId = row2.getPrimaryKeyValue();
            int index = this.getModel().getEntryCurrentRowIndex(QUERY_COLUMN);
            this.setQueryColumn(fieldId, index);
        }
    }

    private ListSelectedRow getSelectedRow(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == returnRows || 0 == returnRows.size()) {
            return null;
        }
        return returnRows.get(0);
    }

    private void setQueryColumn(Object fieldId, int index) {
        DynamicObject fieldInfo = this.getFieldInfoById(fieldId);
        this.getModel().setValue(FIELDNAME, (Object)fieldInfo.getString(FIELDNAME), index);
        this.getModel().setValue("fieldalias", (Object)fieldInfo.getString("fieldalias"), index);
        this.getModel().setValue(STRUCT_COLUMN, (Object)fieldInfo, index);
    }

    private DynamicObject getFieldInfoById(Object fieldId) {
        HRBaseServiceHelper structColumnHelper = new HRBaseServiceHelper("hbss_structcolumn");
        return structColumnHelper.queryOne(fieldId);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

