/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.formplugin.web.help.EntityFieldHelper;

public class QueryStructEdit
extends HRDataBaseEdit
implements CellClickListener {
    private static final String STRUCT_COLUMN = "structcolumn";
    private static final String FIELDNAME = "fieldname";
    private static final String ADD_OUTPUT_FIELD = "addoutputfield";
    private static final String OUTPUT_TOOLBAR = "outputtoolbarap";
    private static final String STRUCTJOIN_FIELDNAME = "currenttblfield";
    private static final String PARENTFIELD = "parentfield";
    private static final String PARENT = "parent";
    private static final String STRUCT_JOIN_COND = "structjoincond";
    private static final String LONG_NUMBER = "longnumber";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setOriginTableInfo((DynamicObject)this.getModel().getValue("bosentity"));
        this.setParentInfo((DynamicObject)this.getModel().getValue(PARENT));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid structColumn = (EntryGrid)this.getControl(STRUCT_COLUMN);
        structColumn.addCellClickListener((CellClickListener)this);
        this.addItemClickListeners(new String[]{OUTPUT_TOOLBAR});
        EntryGrid structJoin = (EntryGrid)this.getControl(STRUCT_JOIN_COND);
        structJoin.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent event) {
        String currentEntityNumber = this.getModel().getValue("entitynumber").toString();
        if (HRStringUtils.equals((String)FIELDNAME, (String)event.getFieldKey())) {
            this.openFieldF7(FIELDNAME, false, currentEntityNumber);
            return;
        }
        if (HRStringUtils.equals((String)STRUCTJOIN_FIELDNAME, (String)event.getFieldKey())) {
            this.openFieldF7(STRUCTJOIN_FIELDNAME, false, currentEntityNumber);
            return;
        }
        if (HRStringUtils.equals((String)PARENTFIELD, (String)event.getFieldKey())) {
            this.openParentFieldF7(PARENTFIELD);
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String currentEntityNumber = this.getModel().getValue("entitynumber").toString();
        if (HRStringUtils.equals((String)ADD_OUTPUT_FIELD, (String)evt.getItemKey())) {
            this.openFieldF7(ADD_OUTPUT_FIELD, true, currentEntityNumber);
        }
    }

    private void openFieldF7(String actionId, boolean isMultiSelect, String entityNumber) {
        ListShowParameter formShowParameter = EntityFieldHelper.createFieldF7ShowParam(actionId, isMultiSelect, "hbss_entityfield", (IFormPlugin)this);
        formShowParameter.setCustomParam("entitynumber", (Object)entityNumber);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void openParentFieldF7(String actionId) {
        DynamicObject parent = (DynamicObject)this.getModel().getValue(PARENT);
        if (null == parent) {
            return;
        }
        DynamicObject bosEntity = parent.getDynamicObject("bosentity");
        String entityNumber = bosEntity.getString("number");
        ListShowParameter formShowParameter = EntityFieldHelper.createFieldF7ShowParam(actionId, false, "hbss_entityfield", (IFormPlugin)this);
        formShowParameter.setCustomParam("entitynumber", (Object)entityNumber);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        ChangeData[] changeDataArray = args.getChangeSet();
        if (changeDataArray.length < 1) {
            return;
        }
        DynamicObject dataEntity = changeDataArray[0].getDataEntity();
        switch (propertyName) {
            case "bosentity": {
                DynamicObject bosEntity = dataEntity.getDynamicObject("bosentity");
                this.setOriginTableInfo(bosEntity);
                break;
            }
            case "parent": {
                DynamicObject parent = dataEntity.getDynamicObject(PARENT);
                this.setParentInfo(parent);
                this.generateLongNumber();
                break;
            }
            case "number": {
                this.generateLongNumber();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "addoutputfield": {
                this.handleAddOutputField(closedCallBackEvent);
                break;
            }
            case "fieldname": {
                this.handleFieldName(closedCallBackEvent);
                break;
            }
            case "parentfield": {
                this.handleParentField(closedCallBackEvent);
                break;
            }
            case "currenttblfield": {
                this.handleParentTblField(closedCallBackEvent);
                break;
            }
        }
    }

    private void handleAddOutputField(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == returnRows || 0 == returnRows.size()) {
            return;
        }
        returnRows.forEach(row -> {
            Map dataMap = row.getDataMap();
            if (null == dataMap) {
                return;
            }
            int index = this.getModel().createNewEntryRow(STRUCT_COLUMN);
            this.setOutputField(dataMap, index);
        });
    }

    private void handleFieldName(ClosedCallBackEvent closedCallBackEvent) {
        Map<String, Object> dataMap = QueryStructEdit.getSelectedRowDataMap(closedCallBackEvent);
        if (null == dataMap) {
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex(STRUCT_COLUMN);
        this.setOutputField(dataMap, index);
    }

    private void handleParentField(ClosedCallBackEvent closedCallBackEvent) {
        Map<String, Object> dataMap = QueryStructEdit.getSelectedRowDataMap(closedCallBackEvent);
        if (null == dataMap) {
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex(STRUCT_JOIN_COND);
        this.setJoinParentField(dataMap, index);
    }

    private void handleParentTblField(ClosedCallBackEvent closedCallBackEvent) {
        Map<String, Object> dataMap = QueryStructEdit.getSelectedRowDataMap(closedCallBackEvent);
        if (null == dataMap) {
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex(STRUCT_JOIN_COND);
        this.setJoinField(dataMap, index);
    }

    public static Map<String, Object> getSelectedRowDataMap(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == returnRows || 0 == returnRows.size()) {
            return null;
        }
        Map dataMap = returnRows.get(0).getDataMap();
        return dataMap;
    }

    private void setJoinField(Map<String, Object> dataMap, int index) {
        this.getModel().setValue(STRUCTJOIN_FIELDNAME, dataMap.get(FIELDNAME), index);
        this.getModel().setValue("currentfiledalias", dataMap.get("fieldalias"), index);
    }

    private void setJoinParentField(Map<String, Object> dataMap, int index) {
        this.getModel().setValue(PARENTFIELD, dataMap.get(FIELDNAME), index);
        this.getModel().setValue("parentfieldalias", dataMap.get("fieldalias"), index);
    }

    private void setOutputField(Map<String, Object> dataMap, int index) {
        this.getModel().setValue(FIELDNAME, dataMap.get(FIELDNAME), index);
        this.getModel().setValue("fieldalias", dataMap.get("fieldalias"), index);
        this.getModel().setValue("ftblfield", dataMap.get("ftblfield"), index);
    }

    private void setOriginTableInfo(DynamicObject bosEntity) {
        if (null == bosEntity) {
            return;
        }
        String entityNumber = bosEntity.getString("number");
        this.getModel().setValue("entitynumber", (Object)entityNumber);
        String dbTableName = this.getTableNameByNumber(entityNumber);
        this.getModel().setValue("dbtablename", (Object)dbTableName);
        DynamicObject app = bosEntity.getDynamicObject("app");
        DynamicObject bizcloud = bosEntity.getDynamicObject("bizcloud");
        this.getModel().setValue("cloud", (Object)bizcloud);
        this.getModel().setValue("app", (Object)app);
    }

    private String getTableNameByNumber(String entityNumber) {
        MainEntityType entityType = (MainEntityType)new HRBaseServiceHelper(entityNumber).generateEmptyDynamicObject().getDataEntityType();
        String dbTableName = ((EntityType)entityType.getAllEntities().get(entityType.getName())).getAlias();
        return dbTableName;
    }

    private void setParentInfo(DynamicObject parent) {
        if (null == parent) {
            return;
        }
        DynamicObject bosEntity = parent.getDynamicObject("bosentity");
        String dbTableName = this.getTableNameByNumber(bosEntity.getString("number"));
        this.getModel().setValue("parenttablename", (Object)dbTableName);
    }

    private void generateLongNumber() {
        DynamicObject parent = (DynamicObject)this.getModel().getValue(PARENT);
        StringBuilder longNumber = new StringBuilder();
        if (null != parent) {
            longNumber.append(parent.getString(LONG_NUMBER));
            longNumber.append('!');
        }
        longNumber.append(this.getModel().getValue("number"));
        this.getModel().setValue(LONG_NUMBER, (Object)longNumber.toString());
    }
}

