/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.capacity;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.bussiness.service.hrbu.capacity.CapacityDictionaryService;

public class CapacityDimEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(CapacityDimEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit parentDim = (BasedataEdit)this.getView().getControl("parentdim");
        parentDim.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        super.beforeDoOperation(args);
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey)) {
            this.getModel().setValue("parentdim", this.getModel().getValue("parent"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            String handleNodeId = this.getModel().getDataEntity().getString("id");
            HashMap<String, String> returnDataMap = new HashMap<String, String>(1);
            returnDataMap.put("handleDimNodeId", handleNodeId);
            this.getView().returnDataToParent(returnDataMap);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setAndUpdateType();
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hbss_parameterconfig");
        DynamicObject paramConfig = configHelper.queryOne("auditcheck", new QFilter[]{new QFilter("basedatafield", "=", (Object)"hbss_capacitygroup")});
        if (null != paramConfig) {
            String status;
            boolean isAudit = (Boolean)paramConfig.get("auditcheck");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (isAudit && null != dataEntity.getPkValue() && 0L != dataEntity.getLong("id") && ("B".equals(status = dataEntity.getString("status")) || "C".equals(status))) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String changeProperty = args.getProperty().getName();
        if ("parentdim".equals(changeProperty)) {
            this.setAndUpdateType();
        }
        if ("parent".equals(changeProperty)) {
            this.getModel().setValue("parentdim", this.getModel().getValue("parent"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"parentdim")) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (null == dataEntity) {
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject parentDim = dataEntity.getDynamicObject("parentdim");
            if (null != parentDim) {
                showParameter.setCustomParam("focusDimNodeId", (Object)String.valueOf(parentDim.getPkValue()));
            }
            if (dataEntity.getPkValue() != null && dataEntity.getLong("id") != 0L) {
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                String currNodeId = this.getModel().getDataEntity().getString("id");
                TreeNode root = CapacityDictionaryService.buildAllDimTreeRoot((boolean)false, (boolean)true);
                Set childrenNodeIds = CapacityDictionaryService.getAllChildrenNodeIds((TreeNode)root, (String)currNodeId);
                ArrayList<Long> filterNodeIds = new ArrayList<Long>(childrenNodeIds.size() + 1);
                filterNodeIds.add(Long.parseLong(currNodeId));
                childrenNodeIds.forEach(childrenNodeId -> filterNodeIds.add(Long.parseLong(childrenNodeId)));
                QFilter qFilter = new QFilter("id", "not in", filterNodeIds);
                listFilterParameter.getQFilters().add(qFilter);
            }
        }
    }

    private void setAndUpdateType() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject parentDim = dataEntity.getDynamicObject("parent");
        if (parentDim != null) {
            this.getModel().setValue("type", parentDim.get("type"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"type"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"type"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

