/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.capacity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbss.bussiness.service.hrbu.capacity.CapacityDictionaryService;
import kd.hr.hbss.common.constants.CapacityItemConstants;

public class CapacityItemEditPlugin
extends AbstractFormPlugin
implements CapacityItemConstants,
RowClickEventListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap_fw", "advcontoolbarap_ng"});
        BasedataEdit dim = (BasedataEdit)this.getView().getControl("group");
        dim.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.showAndVisibleByCacheFlag();
        this.getModel().setValue("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean hisPage = "fromHisAction".equals(customParams.get("fromPage"));
        String deleteGroup = this.getView().getPageCache().get("deletegroup");
        if (!"true".equals(deleteGroup) && !hisPage.booleanValue()) {
            this.getModel().setValue("group", null);
            this.getView().getPageCache().put("deletegroup", "true");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"group")) {
            Long userId = RequestContext.get().getCurrUserId();
            String appId = AppMetadataCache.getAppInfo((String)"tdcs").getId();
            QFilter dataRuleFilter = CapacityDictionaryService.getDataRuleFilter((long)userId, (String)appId, (String)"hbss_capacitygroup", (String)"47150e89000000ac");
            if (null != dataRuleFilter) {
                beforeF7SelectEvent.addCustomQFilter(dataRuleFilter);
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject group = this.getModel().getDataEntity().getDynamicObject("group");
            if (null != group && group.getPkValue() != null) {
                showParameter.setSelectedRow(group.getPkValue());
                showParameter.setCustomParam("focusDimNodeId", (Object)String.valueOf(group.getPkValue()));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showAndVisibleDescFlex();
        this.showIsNagBehavior();
        this.showAndVisibleRankEntry();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String changeProperty = args.getProperty().getName();
        if ("isnagbehavior".equals(changeProperty)) {
            this.showIsNagBehavior();
        }
        if ("type".equals(changeProperty)) {
            this.showAndVisibleDescFlex();
            this.clearSchemeAndBehaviorInfo();
        }
        this.caprankSchemeChanged(args);
        if ("group".equals(changeProperty)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject group = dataEntity.getDynamicObject("group");
            if (group != null) {
                this.getModel().setValue("type", group.get("type"));
                this.getView().setEnable(Boolean.FALSE, new String[]{"type"});
            } else {
                this.getModel().setValue("type", null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"type"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("save".equals(formOperate.getOperateKey()) || "submit".equals(formOperate.getOperateKey()) || this.isConfireChangeBtn(formOperate.getOperateKey())) {
            this.checkIsNagBehavior();
            this.checkHasDimDataRuleRight(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        this.cacheFlagByChangeBtn(operateKey);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("caprankSchemeSureChange".equals(event.getCallBackId()) && "Yes".equals(event.getResultValue())) {
            this.buildRankSchemeEntry();
            this.showAndVisibleRankEntry();
        } else if ("caprankSchemeSureChange".equals(event.getCallBackId()) && "Cancel".equals(event.getResultValue())) {
            Long oldCaprankScheme = Long.parseLong(this.getPageCache().get("caprankscheme"));
            this.getModel().beginInit();
            this.getView().getPageCache().put("caprankschemeCallBack", "true");
            this.getModel().setValue("caprankscheme", (Object)oldCaprankScheme);
            this.getView().updateView("caprankscheme");
            this.getModel().endInit();
            this.showAndVisibleRankEntry();
        }
    }

    private boolean isConfireChangeBtn(String opKey) {
        return "confirmchange".equals(opKey) || "confirmchangenoaudit".equals(opKey);
    }

    private void cacheFlagByChangeBtn(String operateKey) {
        if (null == this.getView().getParentView()) {
            return;
        }
        if ("insertdata_his".equals(operateKey) || this.isConfireChangeBtn(operateKey)) {
            String editViewPageId = this.getView().getPageId();
            IPageCache parentPageAche = this.getView().getParentView().getPageCache();
            parentPageAche.put("editViewPageId", this.getView().getPageId());
            if ("insertdata_his".equals(operateKey)) {
                parentPageAche.put(editViewPageId + "insertdata_his", "insertdata_his");
            }
            if (this.isConfireChangeBtn(operateKey)) {
                parentPageAche.put(editViewPageId + "confirmchange", "confirmchange");
            }
        }
    }

    private void showAndVisibleByCacheFlag() {
        if (null == this.getView().getParentView()) {
            return;
        }
        IPageCache parentPageAche = this.getView().getParentView().getPageCache();
        if (null == parentPageAche) {
            return;
        }
        String editViewPageId = parentPageAche.get("editViewPageId");
        String chgCacheFlag = parentPageAche.get(editViewPageId + "insertdata_his");
        String confirmChgCacheFlag = parentPageAche.get(editViewPageId + "confirmchange");
        if (null != editViewPageId) {
            parentPageAche.remove(editViewPageId);
        }
        if (chgCacheFlag != null) {
            parentPageAche.remove(editViewPageId + "insertdata_his");
        }
        if (confirmChgCacheFlag != null) {
            parentPageAche.remove(editViewPageId + "confirmchange");
        }
    }

    private void caprankSchemeChanged(PropertyChangedArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String type = dataEntity.getString("type");
        String name = args.getProperty().getName();
        if ("caprankscheme".equals(name) && "1".equals(type)) {
            DynamicObject oldValue = (DynamicObject)args.getChangeSet()[0].getOldValue();
            if (oldValue == null) {
                this.buildRankSchemeEntry();
                this.showAndVisibleRankEntry();
            } else {
                String caprankSchemeId = oldValue.getString("id");
                IPageCache pageCache = this.getView().getPageCache();
                pageCache.put("caprankscheme", caprankSchemeId);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u80fd\u529b\u7b49\u7ea7\u65b9\u6848\u540e\uff0c\u5df2\u586b\u7684\u7b49\u7ea7\u63cf\u8ff0\u4fe1\u606f\u5c06\u88ab\u6e05\u9664\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u5207\u6362\uff1f", (String)"CapacityItemEditPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("caprankSchemeSureChange", (IFormPlugin)this));
            }
        }
    }

    private List<DynamicObject> getSortedCapacityRankSchemeEntity() {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("caprankscheme");
        if (dynamicObject != null) {
            DynamicObjectCollection caprankSchemeEntryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            return caprankSchemeEntryEntity.stream().sorted(Comparator.comparingInt(s -> s.getInt("order"))).collect(Collectors.toList());
        }
        return new ArrayList<DynamicObject>();
    }

    private void clearSchemeAndBehaviorInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String type = dataEntity.getString("type");
        if ("2".equals(type)) {
            this.getModel().setValue("caprankscheme", null);
            this.deleteEntry("leftentryentity");
            this.showAndVisibleRankEntry();
        }
        this.buildRankSchemeEntry();
    }

    private void buildRankSchemeEntry() {
        IDataModel model = this.getModel();
        List<DynamicObject> rankSchemeEntries = this.getSortedCapacityRankSchemeEntity();
        int oldEntryRowCount = model.getEntryRowCount("leftentryentity");
        model.deleteEntryRows("leftentryentity", this.getIntArray(oldEntryRowCount));
        model.setDataChanged(false);
        if (!CollectionUtils.isEmpty(rankSchemeEntries)) {
            DynamicObjectCollection entityVerCpEntries = this.getModel().getEntryEntity("leftentryentity");
            if (CollectionUtils.isEmpty((Collection)entityVerCpEntries)) {
                model.batchCreateNewEntryRow("leftentryentity", rankSchemeEntries.size());
                model.beginInit();
                int idx = 0;
                for (int i = 0; i < rankSchemeEntries.size(); ++i) {
                    model.setValue("grouprankname", rankSchemeEntries.get(i).get("entryname"), idx);
                    ++idx;
                }
                model.endInit();
            } else {
                for (int i = 0; i < entityVerCpEntries.size(); ++i) {
                    model.setValue("grouprankname", rankSchemeEntries.get(i).get("entryname"), i);
                }
            }
        }
    }

    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int rowI = 0; rowI < intArray.length; ++rowI) {
            intArray[rowI] = rowI;
        }
        return intArray;
    }

    private void showAndVisibleDescFlex() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String type = dataEntity.getString("type");
        if ("2".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_rank"});
        } else if ("1".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_rank"});
        }
    }

    private void showIsNagBehavior() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Boolean isNagBehavior = dataEntity.getBoolean("isnagbehavior");
        if (isNagBehavior.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"nagbehavior"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"nagbehavior"});
        }
    }

    private void showAndVisibleRankEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject capRankScheme = dataEntity.getDynamicObject("caprankscheme");
        if (capRankScheme != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"leftentryentity"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"leftentryentity"});
        }
    }

    private void deleteEntry(String entryFlag) {
        if (StringUtils.isEmpty((CharSequence)entryFlag)) {
            return;
        }
        int oldEntryRowCount = this.getModel().getEntryRowCount(entryFlag);
        this.getModel().deleteEntryRows(entryFlag, this.getIntArray(oldEntryRowCount));
    }

    private void checkIsNagBehavior() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isNagBehavior = dataEntity.getBoolean("isnagbehavior");
        if (!isNagBehavior) {
            this.getModel().setValue("nagbehavior", null);
        }
    }

    private void checkHasDimDataRuleRight(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject dim = dataEntity.getDynamicObject("group");
        if (null != dim) {
            long currUserId = RequestContext.get().getCurrUserId();
            Long pkId = dim.getLong("id");
            String appId = AppMetadataCache.getAppInfo((String)"tdcs").getId();
            QFilter dataRuleFilter = CapacityDictionaryService.getDataRuleFilter((long)currUserId, (String)appId, (String)"hbss_capacitygroup", (String)"47150e89000000ac");
            if (null != dataRuleFilter) {
                HRBaseServiceHelper CAP_DIM_HELPER = new HRBaseServiceHelper("hbss_capacitygroup");
                boolean isExistsDim = CAP_DIM_HELPER.isExists(new QFilter[]{dataRuleFilter, new QFilter("id", "=", (Object)pkId)});
                if (!isExistsDim) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6240\u9009\u7ef4\u5ea6\u201d{0}\u201d\u7684\u64cd\u4f5c\u6743\u9650", (String)"CapacityItemEditPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[]{dim.getString("name")}));
                    args.setCancel(Boolean.TRUE.booleanValue());
                }
            }
        }
    }
}

