/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.capacity;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;

public class CapacityItemImportValidator
extends AbstractValidateHandler {
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> list, ImportLog importLog) {
        MainEntityType capItemEntityType = MetadataServiceHelper.getDataEntityType((String)"hbss_capacityitem");
        ComboProp typeComboProp = (ComboProp)capItemEntityType.getProperties().get((Object)"type");
        Map<String, String> nameValMap = typeComboProp.getComboItems().stream().collect(Collectors.toMap(vmi -> vmi.getName().getLocaleValue(), vmi -> vmi.getValue(), (v1, v2) -> v2));
        String currLangName = RequestContext.get().getLang().name();
        HashSet rankSchemeIds = new HashSet(list.size());
        HashSet groupIds = new HashSet(list.size());
        for (ImportBillData importBillData : list) {
            JSONObject group;
            JSONObject data = importBillData.getData().getJSONObject("hbss_capacityitem");
            if (data == null) continue;
            JSONObject capRankScheme = data.getJSONObject("caprankscheme");
            if (capRankScheme != null) {
                Long rankSchemeId = capRankScheme.getLong("id");
                Optional.ofNullable(rankSchemeId).ifPresent(rankSchemeIds::add);
            }
            if ((group = data.getJSONObject("group")) == null) continue;
            Long groupId = group.getLong("id");
            Optional.ofNullable(groupId).ifPresent(groupIds::add);
        }
        Map capacityGroupMap = new HashMap(16);
        if (!groupIds.isEmpty()) {
            capacityGroupMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_capacitygroup", (String)"id,type", (QFilter[])new QFilter[]{new QFilter("id", "in", groupIds)});
        }
        Map rankSchemeMap = new HashMap(16);
        if (!rankSchemeIds.isEmpty()) {
            rankSchemeMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_capacityrankscheme", (String)"id,entryentity.entrynumber,entryentity.entryname", (QFilter[])new QFilter[]{new QFilter("id", "in", rankSchemeIds)});
        }
        for (ImportBillData importBillData : list) {
            JSONObject nagbehavior;
            DynamicObject groupDynObj;
            String groupType;
            JSONObject data = importBillData.getData().getJSONObject("hbss_capacityitem");
            String typeName = data.getString("type");
            JSONObject group = data.getJSONObject("group");
            if (HRStringUtils.isBlank((CharSequence)typeName) || group == null || group.getLong("id") == null) continue;
            String typeVal = nameValMap.get(typeName);
            if (!HRStringUtils.equals((String)typeVal, (String)(groupType = Optional.ofNullable(groupDynObj = (DynamicObject)capacityGroupMap.get(group.getLong("id"))).map(dyObj -> dyObj.getString("type")).orElse("")))) {
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u63cf\u8ff0\u65b9\u5f0f\u4e0e\u201c\u6240\u5c5e\u7ef4\u5ea6\u201d\u7684\u5c5e\u6027\u503c\u662f\u5426\u4e00\u81f4\uff0c\u786e\u4fdd\u586b\u5199\u6b63\u786e\u3002", (String)"CapacityItemImportValidator_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
                continue;
            }
            if ("1".equals(typeVal)) {
                JSONObject capRankScheme = data.getJSONObject("caprankscheme");
                if (capRankScheme == null) {
                    String errorMsg = ResManager.loadKDString((String)"\u63cf\u8ff0\u65b9\u5f0f\u4e3a\u201c\u7b49\u7ea7\u63cf\u8ff0\u201d\uff0c\u8bf7\u586b\u5199\u80fd\u529b\u7b49\u7ea7\u65b9\u6848\u3002", (String)"CapacityItemImportValidator_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                    importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
                    continue;
                }
                if (capRankScheme.getLong("id") == null) continue;
                JSONArray leftEntryEntity = data.getJSONArray("leftentryentity");
                if (leftEntryEntity == null || leftEntryEntity.isEmpty()) {
                    String errorMsg = ResManager.loadKDString((String)"\u63cf\u8ff0\u65b9\u5f0f\u4e3a\u201c\u7b49\u7ea7\u63cf\u8ff0\u201d\uff0c\u8bf7\u586b\u5199\u7b49\u7ea7\u540d\u79f0\u3002", (String)"CapacityItemImportValidator_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                    importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
                    continue;
                }
                Long capRankSchemeId = capRankScheme.getLong("id");
                DynamicObject capRankSchemeDynObj = (DynamicObject)rankSchemeMap.get(capRankSchemeId);
                Set entryNameSet = capRankSchemeDynObj.getDynamicObjectCollection("entryentity").stream().map(entryRow -> entryRow.getString("entryname")).collect(Collectors.toSet());
                HashSet entryNameRemoveSet = new HashSet(entryNameSet);
                boolean groupRankNameAllMatch = true;
                for (Object leftEntryRow2 : leftEntryEntity) {
                    JSONObject groupRankNameObj = ((JSONObject)leftEntryRow2).getJSONObject("grouprankname");
                    String groupRankName = Optional.ofNullable(groupRankNameObj).map(jsonObject -> jsonObject.getString(currLangName)).orElse("");
                    entryNameRemoveSet.remove(groupRankName);
                    if (entryNameSet.contains(groupRankName)) continue;
                    groupRankNameAllMatch = false;
                }
                if (!entryNameRemoveSet.isEmpty()) {
                    StringBuilder nameBuilder = new StringBuilder();
                    int index = 0;
                    for (String name : entryNameRemoveSet) {
                        nameBuilder.append(name);
                        if (index != entryNameRemoveSet.size() - 1) {
                            nameBuilder.append("\u3001");
                        }
                        ++index;
                    }
                    String errorMsg = ResManager.loadKDString((String)"\u7b49\u7ea7\u586b\u5199\u4e0d\u5b8c\u6574\uff0c\u5f53\u524d\u7b49\u7ea7\u65b9\u6848\u9700\u5b8c\u6210{0}\u7684\u5b9a\u4e49\u3002", (String)"CapacityItemImportValidator_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[]{nameBuilder.toString()});
                    importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
                    continue;
                }
                if (!groupRankNameAllMatch) {
                    String errorMsg = ResManager.loadKDString((String)"\u7b49\u7ea7\u540d\u79f0\u9700\u4e3a\u7b49\u7ea7\u65b9\u6848\u5185\u5df2\u6709\u7684\u503c\uff0c\u8bf7\u6821\u9a8c\u503c\u662f\u5426\u586b\u5199\u6b63\u786e\u3002", (String)"CapacityItemImportValidator_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                    importLog.writeRowLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), errorMsg);
                    continue;
                }
                Map nameRowMap = leftEntryEntity.stream().collect(Collectors.toMap(leftEntryRow -> ((JSONObject)leftEntryRow).getJSONObject("grouprankname").getString(currLangName), Function.identity(), (v1, v2) -> v2));
                leftEntryEntity = new JSONArray(new ArrayList(nameRowMap.values()));
                Map rankNameMap = leftEntryEntity.stream().collect(Collectors.toMap(leftEntryRow -> ((JSONObject)leftEntryRow).getJSONObject("grouprankname").getString(currLangName), Function.identity()));
                DynamicObjectCollection entryEntity = capRankSchemeDynObj.getDynamicObjectCollection("entryentity");
                JSONArray leftEntryRows = new JSONArray();
                for (DynamicObject entryRow2 : entryEntity) {
                    String entryName = entryRow2.getString("entryname");
                    leftEntryRows.add(rankNameMap.get(entryName));
                }
                data.put("leftentryentity", (Object)leftEntryRows);
            } else {
                data.remove((Object)"caprankscheme");
                data.remove((Object)"leftentryentity");
            }
            if ((nagbehavior = data.getJSONObject("nagbehavior")) == null) continue;
            data.put("isnagbehavior", (Object)true);
        }
    }
}

