/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRCloudAppListPlugin
extends AbstractTreeListPlugin {
    private static final Log logger = LogFactory.getLog(HRCloudAppListPlugin.class);
    private static final String ROOT_NODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String TREE_CLOUD_APP = "treeview";
    private static final String BAR_ADD = "bar_add";
    private static final String HBSS_CLOUD_APP = "hbss_cloud_app";
    private static final String HBSS_CLOUD = "hbss_cloud";
    private static final String BAR_DEL = "bar_del";
    private static final String BAR_REFRESH = "bar_refresh";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String DEFAULT_APP_ID = "XYRL3+A8Z+Z";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BAR_ADD});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_refresh": {
                this.refresh();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HBSS_CLOUD.equals(actionId)) {
            this.refresh();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"deletecloud")) {
            TreeView tv = (TreeView)this.getControl(TREE_CLOUD_APP);
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (HRStringUtils.isEmpty((String)focusNodeId)) {
                this.getView().showTipNotification(this.getNotRootNodeText(), Integer.valueOf(2000));
                return;
            }
            if (ROOT_NODE.equals(focusNodeId)) {
                this.getView().showTipNotification(this.getNotRootNodeText(), Integer.valueOf(2000));
                return;
            }
            boolean cloudApp = this.getCloudApp(focusNodeId);
            if (cloudApp) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u9884\u7f6e\u5e94\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"HRCloudAppListPlugin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("confirm_delete_cloud", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u79fb\u9664\u8be5\u6761\u8bb0\u5f55?", (String)"HRBUCAViewTreeList_7", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, callBackListener);
        } else if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"update")) {
            TreeView tv = (TreeView)this.getControl(TREE_CLOUD_APP);
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (ROOT_NODE.equals(focusNodeId)) {
                this.getView().showTipNotification(this.getNotRootNodeText(), Integer.valueOf(2000));
                return;
            }
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(HBSS_CLOUD);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, HBSS_CLOUD));
            DynamicObject hrCloudByCloudId = this.getHrCloudByCloudId(focusNodeId);
            showParameter.setPkId((Object)hrCloudByCloudId.getLong("id"));
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"addcloud")) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(HBSS_CLOUD);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, HBSS_CLOUD));
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("delete".equals(operate.getOperateKey())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            listSelectedData.forEach(row -> {
                Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
                if (this.isSysPresetApp(primaryKeyValue)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"HRCloudAppListPlugin_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            });
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void confirmCallBack(MessageBoxClosedEvent boxClosedEvent) {
        super.confirmCallBack(boxClosedEvent);
        if ("confirm_delete_cloud".equals(boxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)boxClosedEvent.getResult())) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(BOS_DEVPORTAL_BIZAPP);
            QFilter appFilter = new QFilter("number", "=", (Object)"hbss");
            DynamicObject appDy = serviceHelper.queryOne("id", appFilter);
            String appId = appDy == null ? DEFAULT_APP_ID : appDy.getString("id");
            Long userId = RequestContext.get().getCurrUserId();
            boolean hbss_cloud_app = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)HBSS_CLOUD_APP, (String)"4715e1f1000000ac");
            if (!hbss_cloud_app) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201cHR\u4e91\u4e0e\u5e94\u7528\u201d\u7684\u201c\u5220\u9664\u4e91\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRCloudAppListPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeView tv = (TreeView)this.getControl(TREE_CLOUD_APP);
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            this.deleteCloud(focusNodeId);
            this.deleteCloudApp(focusNodeId);
            this.refresh();
            TreeNode root = new TreeNode();
            root.setParentid("");
            root.setId(ROOT_NODE);
            tv.focusNode(root);
            tv.treeNodeClick(root.getParentid(), root.getId());
        }
    }

    private void refresh() {
        this.initCloudAppTree((TreeView)this.getControl(TREE_CLOUD_APP));
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        TreeNode root = null;
        try {
            root = this.initCloudAppTree((TreeView)this.getControl(TREE_CLOUD_APP));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            logger.error((Throwable)ex);
            return;
        }
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardview"});
    }

    protected QFilter nodeClickFilter() {
        TreeView tv = (TreeView)this.getControl(TREE_CLOUD_APP);
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        this.getPageCache().put("focusNodeId", focusNodeId);
        QFilter filter = ROOT_NODE.equals(focusNodeId) ? new QFilter("1", "=", (Object)1) : new QFilter("app.bizcloud", "=", (Object)focusNodeId);
        return filter;
    }

    private TreeNode initCloudAppTree(TreeView tv) {
        Map focusNodeMap = tv.getTreeState().getFocusNode();
        tv.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(ROOT_NODE);
        root.setText(ResManager.loadKDString((String)"HR\u9886\u57df\u4e91", (String)"HRCloudAppListPlugin_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        tv.addNode(root);
        DynamicObject[] hrClouds = this.getHrCloud();
        ArrayList treeNodeList = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject hrCloud : hrClouds) {
            String coudid = hrCloud.getString("cloud.id");
            String name = hrCloud.getString("cloud.name");
            TreeNode node = new TreeNode();
            node.setId(coudid);
            node.setText(name);
            node.setParentid(ROOT_NODE);
            node.setIsOpened(false);
            treeNodeList.add(node);
        }
        root.addChildren((List)treeNodeList);
        if (!CollectionUtils.isEmpty((Map)focusNodeMap)) {
            TreeNode focusNode = new TreeNode();
            String id = (String)focusNodeMap.get("id");
            String parentid = (String)focusNodeMap.get("parentid");
            focusNode.setParentid(parentid);
            focusNode.setId(id);
            tv.focusNode(focusNode);
            tv.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        } else {
            tv.focusNode(root);
            tv.treeNodeClick(root.getParentid(), root.getId());
        }
        return root;
    }

    private DynamicObject[] getHrCloud() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HBSS_CLOUD);
        return serviceHelper.query("id,cloud,cloud.id,cloud.name,index", new QFilter[0], "index asc");
    }

    private DynamicObject getHrCloudByCloudId(String cloudId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HBSS_CLOUD);
        return serviceHelper.queryOne("id,cloud,cloud.id,cloud.name,index", new QFilter[]{new QFilter("cloud", "=", (Object)cloudId)});
    }

    @ExcludeFromJacocoGeneratedReport
    private int deleteCloud(String cloudId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HBSS_CLOUD);
        return serviceHelper.deleteByFilter(new QFilter[]{new QFilter("cloud", "=", (Object)cloudId)});
    }

    @ExcludeFromJacocoGeneratedReport
    private int deleteCloudApp(String cloudId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HBSS_CLOUD_APP);
        return serviceHelper.deleteByFilter(new QFilter[]{new QFilter("app.bizcloud.id", "=", (Object)cloudId)});
    }

    private String getNotRootNodeText() {
        return ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u53ef\u4fee\u6539\u6216\u5220\u9664\uff0c\u8bf7\u9009\u62e9\u5b50\u8282\u70b9\u3002", (String)"HRCloudAppListPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    private boolean getCloudApp(String cloudId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HBSS_CLOUD_APP);
        return serviceHelper.isExists(new QFilter[]{new QFilter("app.bizcloud.id", "=", (Object)cloudId), new QFilter("issyspreset", "=", (Object)"1")});
    }

    private boolean isSysPresetApp(Long appId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HBSS_CLOUD_APP);
        return serviceHelper.isExists(new QFilter[]{new QFilter("id", "=", (Object)appId), new QFilter("issyspreset", "=", (Object)"1")});
    }
}

