/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.bussiness.config.HRBdWhiteListServiceHelper;

public class ParamWhiteListEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String BASEDATAFIELD = "basedata";
    private static final String REFBASEDATAFIELD = "refbasedata";
    private static final String MODIFYENABLE = "modifyenable";
    private static final String PARAMTYPE = "paramtype";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DEFVAL = "defval";
    private static final String APP = "app";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        DynamicObject refBdDyo = (DynamicObject)this.getModel().getValue(REFBASEDATAFIELD);
        if (HRStringUtils.equals((String)"save", (String)formOperate.getOperateKey())) {
            DynamicObject basedataDyo;
            boolean existsCircularDep;
            if (refBdDyo != null && (existsCircularDep = HRBdWhiteListServiceHelper.existsCircularDep((String)(basedataDyo = (DynamicObject)this.getModel().getValue(BASEDATAFIELD)).getString("number"), (String)refBdDyo.getString("number")))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"ParamWhiteListEditPlugin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < entryEntity.size(); ++i) {
                String defVal;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String modifyEnable = dynamicObject.getString(MODIFYENABLE);
                if (HRStringUtils.isEmpty((String)modifyEnable)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u662f\u5426\u5141\u8bb8\u8c03\u6574\u201d\u3002", (String)"ParamWhiteListEditPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[]{i + 1}));
                    args.setCancel(true);
                    return;
                }
                if (!"0".equals(modifyEnable) || refBdDyo != null || !HRStringUtils.isEmpty((String)(defVal = dynamicObject.getString(DEFVAL)))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u7b2c%s\u884c\u201c\u9ed8\u8ba4\u503c\u201d\u3002", (String)"ParamWhiteListEditPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[]{i + 1}));
                args.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propertyName = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        if (BASEDATAFIELD.equalsIgnoreCase(propertyName)) {
            DynamicObject appDynamicObject = (DynamicObject)this.getModel().getValue(BASEDATAFIELD);
            if (appDynamicObject != null) {
                String appId = BizAppServiceHelp.getAppIdByFormNum((String)appDynamicObject.getString("number"));
                this.getModel().setValue(APP, (Object)appId);
            } else {
                this.getModel().setValue(APP, null);
            }
        } else if (MODIFYENABLE.equalsIgnoreCase(propertyName)) {
            ChangeData changeData = changeSet[0];
            Object newValue = changeData.getNewValue();
            boolean showVal = newValue == null || "0".equals(newValue.toString());
            int rowIndex = changeData.getRowIndex();
            if (!showVal) {
                this.getModel().setValue(DEFVAL, null, rowIndex);
            }
            this.getView().setEnable(Boolean.valueOf(showVal), rowIndex, new String[]{DEFVAL});
        } else if (REFBASEDATAFIELD.equalsIgnoreCase(propertyName)) {
            ChangeData changeData = changeSet[0];
            Object newValue = changeData.getNewValue();
            if (newValue != null) {
                this.getModel().setValue(MODIFYENABLE, (Object)"0", 0);
                this.getModel().setValue(MODIFYENABLE, (Object)"0", 1);
                this.getModel().setValue(MODIFYENABLE, (Object)"0", 2);
                this.getModel().setValue(DEFVAL, null, 0);
                this.getModel().setValue(DEFVAL, null, 1);
                this.getModel().setValue(DEFVAL, null, 2);
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{MODIFYENABLE});
                this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{MODIFYENABLE});
                this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{MODIFYENABLE});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{DEFVAL});
                this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{DEFVAL});
                this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{DEFVAL});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{MODIFYENABLE});
                this.getView().setEnable(Boolean.valueOf(true), 1, new String[]{MODIFYENABLE});
                this.getView().setEnable(Boolean.valueOf(true), 2, new String[]{MODIFYENABLE});
                this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{DEFVAL});
                this.getView().setEnable(Boolean.valueOf(true), 1, new String[]{DEFVAL});
                this.getView().setEnable(Boolean.valueOf(true), 2, new String[]{DEFVAL});
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(BASEDATAFIELD);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        Object newValue;
        super.afterBindData(e);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryentity.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 3);
            this.getModel().setValue(PARAMTYPE, (Object)"audit", 0);
            this.getModel().setValue(PARAMTYPE, (Object)"enable", 1);
            this.getModel().setValue(PARAMTYPE, (Object)"log", 2);
        }
        if ((newValue = this.getModel().getValue(REFBASEDATAFIELD)) != null) {
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{MODIFYENABLE});
            this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{MODIFYENABLE});
            this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{MODIFYENABLE});
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{DEFVAL});
            this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{DEFVAL});
            this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{DEFVAL});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{MODIFYENABLE});
            this.getView().setEnable(Boolean.valueOf(true), 1, new String[]{MODIFYENABLE});
            this.getView().setEnable(Boolean.valueOf(true), 2, new String[]{MODIFYENABLE});
            this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{DEFVAL});
            this.getView().setEnable(Boolean.valueOf(true), 1, new String[]{DEFVAL});
            this.getView().setEnable(Boolean.valueOf(true), 2, new String[]{DEFVAL});
        }
        Object viewBlackListFlag = this.getView().getFormShowParameter().getCustomParam("view_whitelist");
        if (viewBlackListFlag != null) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row >= 0) {
            String paramType = this.getModel().getEntryRowEntity(ENTRYENTITY, row).getString(PARAMTYPE);
            String modifyEnable = this.getModel().getEntryRowEntity(ENTRYENTITY, row).getString(MODIFYENABLE);
            boolean showVal = "0".equals(modifyEnable);
            ComboProp comboProp = (ComboProp)this.getModel().getProperty(DEFVAL);
            ArrayList items = Lists.newArrayListWithCapacity((int)10);
            List comboItems = comboProp.getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                ComboItem item = new ComboItem();
                item.setCaption(comboItem.getName());
                item.setValue(comboItem.getValue());
                if (comboItem.getValue().startsWith(paramType) && showVal) {
                    item.setItemVisible(true);
                } else {
                    item.setItemVisible(false);
                }
                items.add(item);
            }
            ComboEdit permFieldEdit = (ComboEdit)this.getControl(DEFVAL);
            permFieldEdit.setComboItems((List)items);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)BASEDATAFIELD)) {
            QFilter qFilter = new QFilter("modeltype", "=", (Object)"BaseFormModel");
            qFilter.and(new QFilter("bizappid.bizcloud.number", "in", ParamWhiteListEditPlugin.getAllHRCloudIdInStr()));
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private static List<String> getAllHRCloudIdInStr() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_cloud");
        DynamicObject[] clouds = serviceHelper.queryOriginalArray("cloud.number", null);
        return Arrays.stream(clouds).map(it -> it.getString("cloud.number")).collect(Collectors.toList());
    }
}

