/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.config;

import java.util.EventObject;
import java.util.List;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.config.HRBdWhiteListServiceHelper;
import kd.hr.hbss.bussiness.config.HRParamConfigTreeServiceHelper;

public class ParamWhiteListPlugin
extends StandardTreeListPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener {
    private HRParamConfigTreeServiceHelper treeHelper;

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Object viewBlackListFlag = this.getView().getFormShowParameter().getCustomParam("view_whitelist");
        e.getParameter().setCustomParam("view_whitelist", viewBlackListFlag);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object viewBlackListFlag = this.getView().getFormShowParameter().getCustomParam("view_whitelist");
        if (viewBlackListFlag != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblnew"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbldel"});
        }
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl("treeview");
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
        TreeView treeView = this.getTreeView();
        this.treeHelper = new HRParamConfigTreeServiceHelper(treeView);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.treeHelper.reBuildWholeTree();
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        String leftTreeQFilterJson = this.getPageCache().get("lefttree_qfilter_json");
        if (HRStringUtils.isNotEmpty((String)leftTreeQFilterJson)) {
            evt.getQFilters().add(QFilter.fromSerializedString((String)leftTreeQFilterJson));
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        List appIdList;
        String nodeId = (String)treeNodeEvent.getNodeId();
        String parentNodeId = (String)treeNodeEvent.getParentNodeId();
        TreeView leftTree = (TreeView)treeNodeEvent.getSource();
        String id = String.valueOf(nodeId);
        if (HRStringUtils.equals((String)"1010", (String)id)) {
            this.getPageCache().remove("lefttree_qfilter_json");
            return;
        }
        boolean isSearchMode = HRStringUtils.equals((String)this.getPageCache().get("lefttree_search_mode"), (String)"true");
        String[] idArr = id.split("_split_");
        if (idArr.length < 2) {
            return;
        }
        String nodeIdPrefix = idArr[0];
        TreeNode rootNode = new TreeNode();
        rootNode.setId("1010");
        String trueId = idArr[1];
        if (HRStringUtils.equals((String)"1", (String)nodeIdPrefix)) {
            appIdList = HRBdWhiteListServiceHelper.getAllAppByCloudId((String)trueId);
            if (!isSearchMode) {
                leftTree.queryTreeNodeChildren(parentNodeId, nodeId);
            }
        } else {
            appIdList = HRBdWhiteListServiceHelper.getEntityNumByAppId((String)trueId);
            if (!isSearchMode) {
                leftTree.queryTreeNodeChildren(parentNodeId, nodeId);
            }
        }
        QFilter qFilter = new QFilter("app", "in", (Object)appIdList);
        this.getPageCache().put("lefttree_qfilter_json", qFilter.toSerializedString());
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        if (event.getNodeId() != null) {
            String nodeId = event.getNodeId().toString();
            this.treeHelper.handleExpandNodeClick(nodeId);
        }
    }
}

