/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.config.log;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class ViewLogDetailsListPlugin
extends HRDataBaseList {
    private static final String KEY_MODIFYBILLID = "modifybillid";
    public static final String HRMP_HBSS_FORMPLUGIN = "hrmp-hbss-formplugin";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        super.registerListener(e);
    }

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        String entityNumber;
        String appId;
        long userId;
        boolean hasSpecificPerm;
        FormShowParameter showParameter = (FormShowParameter)preOpenFormEventArgs.getSource();
        String caption = (String)showParameter.getCustomParam("caption");
        String tab = (String)showParameter.getCustomParam("tab");
        if (HRStringUtils.equals((String)tab, (String)"1")) {
            String tittle = String.format(ResManager.loadKDString((String)"%s\u65e5\u5fd7", (String)"ViewLogDetailsListPlugin_1", (String)HRMP_HBSS_FORMPLUGIN, (Object[])new Object[0]), caption);
            showParameter.setCaption(tittle);
        }
        if (!(hasSpecificPerm = PermissionServiceHelper.hasViewPermission((long)(userId = RequestContext.get().getCurrUserId()), (String)(appId = (String)showParameter.getCustomParam("appId")), (String)(entityNumber = (String)showParameter.getCustomParam("formId"))))) {
            preOpenFormEventArgs.setCancel(true);
            preOpenFormEventArgs.setCancelMessage(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u57fa\u7840\u8d44\u6599%s\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"ViewLogDetailsListPlugin_5", (String)HRMP_HBSS_FORMPLUGIN, (Object[])new Object[0]), caption));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result != null) {
            List pkId = result.getSuccessPkIds();
            switch (operateKey) {
                case "viewdetails": {
                    this.viewDetails(pkId);
                    break;
                }
                case "viewhistorylog": {
                    this.viewHistoryLog(pkId);
                    break;
                }
            }
        }
    }

    private void viewDetails(List<Object> pkId) {
        String formId = "hbss_logdetail";
        Object customParam = this.getView().getFormShowParameter().getCustomParam("customLogDetailFormId");
        if (Objects.nonNull(customParam)) {
            formId = (String)customParam;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("pkId", pkId.get(0));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String caption = (String)formShowParameter.getCustomParam("caption");
        String appId = (String)formShowParameter.getCustomParam("appId");
        String entityNumber = (String)formShowParameter.getCustomParam("formId");
        fsp.setCustomParam("caption", (Object)caption);
        fsp.setCustomParam("appId", (Object)appId);
        fsp.setCustomParam("formId", (Object)entityNumber);
        fsp.setHasRight(true);
        this.getView().showForm(fsp);
    }

    private void viewHistoryLog(List<Object> pkId) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkId.get(0), (String)"hbss_logview");
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId("bos_list");
        lsp.setBillFormId("hbss_history_logview");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        String modifybillid = object.get(KEY_MODIFYBILLID).toString();
        if (modifybillid.endsWith("+") || modifybillid.endsWith("-")) {
            modifybillid = modifybillid.substring(0, object.get(KEY_MODIFYBILLID).toString().length() - 1);
        }
        listFilterParameter.setFilter(new QFilter(KEY_MODIFYBILLID, "in", (Object)new String[]{modifybillid, modifybillid + "+", modifybillid + "-"}));
        lsp.setListFilterParameter(listFilterParameter);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String pageId = this.getView().getPageId() + "_" + modifybillid;
        lsp.setPageId(pageId);
        lsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc = (ColumnDesc)e.getSource();
        if (KEY_MODIFYBILLID.equals(columnDesc.getKey())) {
            String v = (String)e.getFormatValue();
            if (v.endsWith("+")) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u65b0\u589e", (String)"ViewLogDetailsListPlugin_2", (String)HRMP_HBSS_FORMPLUGIN, (Object[])new Object[0]));
            } else if (v.endsWith("-")) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u5220\u9664", (String)"ViewLogDetailsListPlugin_3", (String)HRMP_HBSS_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u4fee\u6539", (String)"ViewLogDetailsListPlugin_4", (String)HRMP_HBSS_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }
}

