/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.diff;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.ClassFile;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.service.diff.cache.DiffCache;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hbss.formplugin.web.diff.DiffHandlerPreSQLHelper;

public class DiffCustomConfigList
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(DiffCustomConfigList.class);
    private static final String AOP_REGISTER = "aopregister";
    private static final String HBSS_AOPCONFIG = "hbss_diffprojaopconfig";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && AOP_REGISTER.equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setFormId("hbss_diffcusaopconfig");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, AOP_REGISTER);
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            if ("exportjavaassistclass".equals(operateKey)) {
                this.exportJavaClassFile();
            } else if ("genapiaopdeployfile".equals(operateKey)) {
                String pkId = this.getApiAopScopeId();
                this.getView().showForm(this.apiAopScopeForm(pkId));
            } else if ("removediffcache".equals(operateKey)) {
                this.removedDiffCache();
            } else if ("exportcurrentjvmaopclassnames".equals(operateKey)) {
                this.exportCurrentJVMAOPClassNames();
            } else if ("generatediffsqlfile".equals(operateKey)) {
                this.generateDiffSQLFile();
            }
        }
    }

    private void removedDiffCache() {
        DiffCache.removeAllHandlerCache();
        DiffCache.removeAllApiAopCache();
        MainEntityType dynObjType = EntityMetadataCache.getDataEntityType((String)"hbss_diffhandler");
        BusinessDataServiceHelper.removeCache((DynamicObjectType)dynObjType);
        dynObjType = EntityMetadataCache.getDataEntityType((String)"hbss_diffimplement");
        BusinessDataServiceHelper.removeCache((DynamicObjectType)dynObjType);
    }

    private void exportJavaClassFile() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection col = billList.getSelectedRows();
        if (col == null || col.size() == 0) {
            return;
        }
        Set<String> classNameSet = this.getSelectedClassNameSet(col);
        ClassPool pool = ClassPool.getDefault();
        classNameSet.forEach(className -> this.generateClassFile(pool, (String)className));
    }

    private void generateDiffSQLFile() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection col = billList.getSelectedRows();
        if (col == null || col.size() == 0) {
            return;
        }
        List<Long> enableIdList = this.getEnableDiffHandlerIds();
        if (enableIdList.size() < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5217\u8868\u4e2d\u542f\u7528\u7684\u6ce8\u518c\u6570\u636e\u3002", (String)"DiffCustomConfigList_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
        DiffHandlerPreSQLHelper preSQLHelper = new DiffHandlerPreSQLHelper();
        preSQLHelper.generateDiffSQLFile((AbstractListPlugin)this, enableIdList);
    }

    private Set<String> getSelectedClassNameSet(ListSelectedRowCollection col) {
        DynamicObject[] objs = this.getDiffHandlerDataByColl(col);
        HashSet classNameSet = Sets.newHashSetWithExpectedSize((int)30);
        for (DynamicObject obj : objs) {
            classNameSet.add(obj.getString("sourceclassname"));
        }
        return classNameSet;
    }

    private DynamicObject[] getDiffHandlerDataByColl(ListSelectedRowCollection col) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ListSelectedRow listRow : col) {
            Long id = (Long)listRow.getPrimaryKeyValue();
            idList.add(id);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_diffcusaopconfig");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", idList), new QFilter("type", "=", (Object)"APIAOP")};
        return serviceHelper.query("id,sourceclassname", filters);
    }

    private void generateClassFile(ClassPool pool, String className) {
        CtClass ctClass = pool.getOrNull(className);
        try {
            ClassFile classFile = ctClass.getClassFile2();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try (DataOutputStream ds = new DataOutputStream(outStream);){
                classFile.write(ds);
                ds.flush();
            }
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            String exportUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ctClass.getSimpleName() + ".class", (InputStream)inStream, 10000);
            if (!HRStringUtils.isEmpty((String)exportUrl)) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)exportUrl);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Long id = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        String type = this.getType(id);
        if ("APIAOP".equalsIgnoreCase(type)) {
            args.setCancel(true);
            this.getView().showForm(this.apiAopEditForm(id));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (AOP_REGISTER.equals(closedCallBackEvent.getActionId())) {
            IListView iListView = (IListView)this.getView();
            iListView.refresh();
        }
    }

    private String getType(Long id) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_diffcusaopconfig");
        DynamicObject dynObj = helper.queryOne("diffhandler.type", (Object)id);
        return dynObj.getString("diffhandler.type");
    }

    private FormShowParameter apiAopEditForm(Long id) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setPkId((Object)id);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, AOP_REGISTER));
        formShowParameter.setFormId("hbss_diffcusaopconfig");
        return formShowParameter;
    }

    private FormShowParameter apiAopScopeForm(String pkId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setPkId((Object)pkId);
        formShowParameter.setFormId(HBSS_AOPCONFIG);
        return formShowParameter;
    }

    private String getApiAopScopeId() {
        Long userId = RequestContext.get().getCurrUserId();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(HBSS_AOPCONFIG);
        DynamicObject dynamicObject = helper.queryOne("id", new QFilter[]{new QFilter("creator", "=", (Object)userId)});
        return null != dynamicObject ? dynamicObject.getString("id") : null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String evnRunningClass = System.getProperty("AOPExportCurrentRunningClass");
        if (!"true".equals(evnRunningClass)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"exportjavaassistclass"});
        }
    }

    private List<Long> getEnableDiffHandlerIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ArrayList idList = new ArrayList(16);
        ListSelectedRowCollection col = billList.getSelectedRows();
        col.forEach(row -> idList.add((Long)row.getPrimaryKeyValue()));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_diffcusconfig");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", idList), new QFilter("enable", "=", (Object)true)};
        DynamicObject[] enableObjs = serviceHelper.query("id", qFilters);
        return Arrays.stream(enableObjs).map(item -> item.getLong("id")).collect(Collectors.toList());
    }

    private void exportCurrentJVMAOPClassNames() {
        String content = System.getProperty("AOPListenerFinishClasses");
        if (!HRStringUtils.isEmpty((String)content)) {
            String[] classInfos = content.split(";");
            String exportUrl = null;
            try {
                ArrayList exportDataList = Lists.newArrayListWithCapacity((int)30);
                for (String classInfo : classInfos) {
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    String[] info = classInfo.split("#");
                    dataMap.put("className", info[0]);
                    dataMap.put("methodName", info[1]);
                    exportDataList.add(dataMap);
                }
                ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
                HRExportHeadObject hrExportHeadObject = new HRExportHeadObject();
                hrExportHeadObject.setColumnId("className");
                hrExportHeadObject.setColumnAlias("class name");
                headDataList.add(hrExportHeadObject);
                hrExportHeadObject = new HRExportHeadObject();
                hrExportHeadObject.setColumnId("methodName");
                hrExportHeadObject.setColumnAlias("method name");
                headDataList.add(hrExportHeadObject);
                exportUrl = HRExportDataHelper.getExportExcelUrl((String)("currentJVMAOPClassesInfo_" + System.currentTimeMillis()), (List)exportDataList, headDataList);
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            if (!HRStringUtils.isEmpty(exportUrl)) {
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", exportUrl);
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f53\u524dJVM\u65e0AOP Class\u3002", (String)"DiffCustomConfigList_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
    }
}

