/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OperationType;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hbss.bussiness.service.hrbu.HRBUSyncStrategyService;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.formplugin.web.hrbu.HRBUcaSyncStrategyTask;
import org.apache.commons.lang3.StringUtils;

public class HRBUCAEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(HRBUCAEdit.class);
    private static final String PARENT = "parent";
    private static final String BTNUPDATE = "btnupdate";
    private static final String BTNSAVE = "btnsave";
    private static final String SYNCSTRATEGY = "syncstrategy";
    private static final String DESCRIPTION = "description";

    public void afterLoadData(EventObject eventObject) {
        super.afterLoadData(eventObject);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit hrbuCaFuncFieldEdit = (BasedataEdit)this.getView().getControl(PARENT);
        hrbuCaFuncFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"doupdate")) {
            Object parent = this.getModel().getValue(PARENT);
            String syncStrategy = (String)this.getView().getModel().getValue(SYNCSTRATEGY);
            if (HRStringUtils.equals((String)syncStrategy, (String)"0") && Objects.isNull(parent)) {
                String tip = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cHR\u4e1a\u52a1\u7ba1\u7406\u89c6\u56fe\u201d\u3002", (String)"HRBUCAEdit_19", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tip);
                return;
            }
            Long id = (Long)this.getModel().getValue("id");
            long newViewId = 0L;
            String newViewName = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"HRBUCAEdit_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            if (parent != null && !HRObjectUtils.isEmpty((Object)parent) && parent instanceof DynamicObject) {
                newViewId = ((DynamicObject)parent).getLong("id");
                newViewName = ((DynamicObject)parent).getString("name");
            }
            HRBaseServiceHelper hrBuCaServiceHelper = new HRBaseServiceHelper("hbss_hrbuca");
            DynamicObject oldHrBuCaDy = hrBuCaServiceHelper.queryOriginalOne("id,parent", (Object)id);
            long oldViewId = this.getFieldId(oldHrBuCaDy, PARENT);
            DynamicObject newDyn = this.getDyObjInModel(hrBuCaServiceHelper);
            if (oldViewId == newViewId | (oldViewId != 0L && newViewId == 0L)) {
                args.setCancel(true);
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("isshowmessage", "false");
                this.getView().invokeOperation("save", operateOption);
                return;
            }
            long start = System.currentTimeMillis();
            LOGGER.info("HRBUcaSyncStrategyTask : begin");
            Map result = HRBUSyncStrategyService.syncValidate((Long)id, (Long)newViewId);
            List orgParams = (List)result.get("all");
            List freezeOrgParams = (List)result.get("freeze");
            List freezeOrgParams2 = (List)result.get("freeze2");
            List freezeOrgParams3 = (List)result.get("freeze3");
            List unfreezeOrgParams = (List)result.get("unfreeze");
            String title = "";
            if (freezeOrgParams2.size() + freezeOrgParams3.size() > 0) {
                title = title + this.getFreezeName();
            }
            if (unfreezeOrgParams.size() > 0) {
                title = title.length() > 0 ? title + "/" : title;
                title = title + this.getUnfreezeName();
            }
            if (title.length() > 0) {
                title = String.format(ResManager.loadKDString((String)"\u82e5\u5f53\u524d\u89c6\u56fe\u7684\u7b56\u7565\u4fee\u6539\u4e3a\u4e0e\u201c%1$s\u201d\u4fdd\u6301\u4e00\u81f4\uff0c\u5c06%2$s\u5f53\u524d\u89c6\u56fe\u7684\u4ee5\u4e0b\u7ec4\u7ec7\uff0c\u786e\u5b9a\u4fee\u6539\u5417\uff1f", (String)"HRBUCAEdit_18", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), newViewName, title);
                String content = "";
                if (freezeOrgParams2.size() > 0 && freezeOrgParams3.size() > 0) {
                    freezeOrgParams2.addAll(freezeOrgParams3);
                    content = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u89c6\u56fe\u7684\u4ee5\u4e0b\u7ec4\u7ec7\u5728\u201c%1$s\u201d\u4e2d\u5df2\u88ab\u5c01\u5b58\uff0c\u6216\u4e0d\u5c5e\u4e8e\u201c%2$s\u201d\uff0c\u5c06\u88ab\u540c\u6b65\u5c01\u5b58\u7684\uff1a<br>%3$s\u3002", (String)"HRBUCAEdit_11", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), newViewName, newViewName, StringUtils.join((Iterable)freezeOrgParams2.stream().map(OrgParam::getName).collect(Collectors.toSet()), (String)"<br>"));
                    freezeOrgParams.addAll(freezeOrgParams2);
                } else if (freezeOrgParams3.size() > 0) {
                    content = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u89c6\u56fe\u7684\u4ee5\u4e0b\u7ec4\u7ec7\u5728\u201c%1$s\u201d\u4e2d\u5df2\u88ab\u5c01\u5b58\uff0c\u5c06\u88ab\u540c\u6b65\u5c01\u5b58\uff1a<br>%2$s\u3002", (String)"HRBUCAEdit_12", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), newViewName, StringUtils.join((Iterable)freezeOrgParams3.stream().map(OrgParam::getName).collect(Collectors.toSet()), (String)"<br>"));
                    freezeOrgParams.addAll(freezeOrgParams2);
                    freezeOrgParams.addAll(freezeOrgParams3);
                } else if (freezeOrgParams2.size() > 0) {
                    content = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u5c5e\u4e8e\u5f53\u524d\u89c6\u56fe\uff0c\u4f46\u4e0d\u5c5e\u4e8e\u201c%1$s\u201d\uff0c\u5c06\u88ab\u5c01\u5b58\uff1a<br>%2$s\u3002", (String)"HRBUCAEdit_13", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), newViewName, StringUtils.join((Iterable)freezeOrgParams2.stream().map(OrgParam::getName).collect(Collectors.toSet()), (String)"<br>"));
                    freezeOrgParams.addAll(freezeOrgParams2);
                    freezeOrgParams.addAll(freezeOrgParams3);
                }
                if (unfreezeOrgParams.size() > 0) {
                    content = content + "<br>" + String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u5728\u5f53\u524d\u89c6\u56fe\u5df2\u5c01\u5b58\uff0c\u4f46\u5728\u201c%1$s\u201d\u672a\u5c01\u5b58\uff0c\u5c06\u88ab\u89e3\u5c01\uff1a<br>%2$s\u3002", (String)"HRBUCAEdit_14", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), newViewName, StringUtils.join((Iterable)unfreezeOrgParams.stream().map(OrgParam::getName).collect(Collectors.toSet()), (String)"<br>"));
                }
                orgParams.addAll(freezeOrgParams);
                orgParams.addAll(unfreezeOrgParams);
                this.getPageCache().put("orgParams", JSON.toJSONString((Object)orgParams));
                this.getPageCache().put("newViewName", newViewName);
                this.showOpConfirmPop(title, content);
            } else {
                orgParams.addAll(freezeOrgParams);
                orgParams.addAll(unfreezeOrgParams);
                this.startJob(orgParams, this.getView(), newViewName, newDyn);
            }
            long end = System.currentTimeMillis();
            LOGGER.info("HRBUcaSyncStrategyTask : end time : {}", (Object)(end - start));
        }
    }

    private String getUnfreezeName() {
        return ResManager.loadKDString((String)"\u89e3\u5c01", (String)"HRBUCAEdit_15", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    private String getFreezeName() {
        return ResManager.loadKDString((String)"\u5c01\u5b58", (String)"HRBUCAEdit_16", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"save", (String)formOperate.getOperateKey())) {
            if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
                IListView parentView = (IListView)this.getView().getParentView();
                parentView.updateView();
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"HRBUCAEdit_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction((IFormView)parentView);
                this.getView().close();
            } else if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
                String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25%s", (String)"HRBUCAEdit_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), args.getOperationResult().getMessage());
                this.getView().getParentView().showErrorNotification(msg);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void closedCallBack(ClosedCallBackEvent event) {
        if (HRStringUtils.equals((String)event.getActionId(), (String)"HRBUcaSyncStrategyTask")) {
            Map result = (Map)event.getReturnData();
            String taskInfoStr = (String)result.get("taskinfo");
            OrgApiResult orgApiResult = (OrgApiResult)SerializationUtils.fromJsonString((String)JSON.parseObject((String)taskInfoStr).getJSONObject("data").getJSONObject("orgApiResult").toJSONString(), OrgApiResult.class);
            if (orgApiResult.isSuccess()) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("isshowmessage", "false");
                this.getView().invokeOperation("save", operateOption);
            } else {
                AtomicInteger freezeCount = new AtomicInteger();
                AtomicInteger unfreezeCount = new AtomicInteger();
                orgApiResult.getResultList().forEach(orgApiResult1 -> {
                    if (OperationType.freeze.name().equals(orgApiResult1.getNumber())) {
                        freezeCount.getAndIncrement();
                    } else if (OperationType.unfreeze.name().equals(orgApiResult1.getNumber())) {
                        unfreezeCount.getAndIncrement();
                    }
                });
                String title = "";
                if (freezeCount.get() > 0) {
                    title = title + this.getFreezeName();
                }
                if (unfreezeCount.get() > 0) {
                    title = title.length() > 0 ? title + "/" : title;
                    title = title + this.getUnfreezeName();
                }
                this.showValidateResult(orgApiResult, String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\u3002\u5f53\u524d\u89c6\u56fe\u7684\u4ee5\u4e0b\u7ec4\u7ec7%1$s\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u540c\u6b65\u7b56\u7565\u3002", (String)"HRBUCAEdit_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), title));
            }
        } else if (HRStringUtils.equals((String)event.getActionId(), (String)"doConfirm")) {
            if (!this.getView().getFormShowParameter().getCustomParams().containsKey("confirm")) {
                return;
            }
            String newViewName = this.getPageCache().get("newViewName");
            List orgParams = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("orgParams"), OrgParam.class);
            HRBaseServiceHelper hrBuCaServiceHelper = new HRBaseServiceHelper("hbss_hrbuca");
            DynamicObject dy = this.getDynObject(hrBuCaServiceHelper);
            this.startJob(orgParams, this.getView(), newViewName, dy);
            return;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void showValidateResult(OrgApiResult orgApiResult, String title) {
        if (orgApiResult.getResultList().size() == 1) {
            String errorMsg = orgApiResult.getErrorMsg() == null ? ((OrgApiResult)orgApiResult.getResultList().get(0)).getErrorMsg() : orgApiResult.getErrorMsg();
            String msg = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff0c%s\u3002", (String)"HRBUCAEdit_17", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), errorMsg);
            this.getView().showErrorNotification(msg);
            return;
        }
        OperationResult operationResult = new OperationResult();
        operationResult.setMessage(title);
        operationResult.setSuccess(false);
        ValidateResultCollection validateResultCollection = new ValidateResultCollection();
        ValidateResult validateResult = new ValidateResult();
        ArrayList errorInfoList = Lists.newArrayList();
        for (OrgApiResult apiResult : orgApiResult.getResultList()) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setMessage(apiResult.getName() + "\uff1a" + apiResult.getErrorMsg());
            operateErrorInfo.setTitle(apiResult.getNumber().equals(OperationType.freeze.name()) ? this.getFreezeName() : this.getUnfreezeName());
            operateErrorInfo.setErrorCode("errorcode_001");
            operateErrorInfo.setLevel(ErrorLevel.Error);
            errorInfoList.add(operateErrorInfo);
        }
        validateResult.setAllErrorInfo((List)errorInfoList);
        validateResult.setMessage(title);
        validateResultCollection.addValidateError("actionName", validateResult);
        validateResultCollection.setMessage(title);
        operationResult.setValidateResult(validateResultCollection);
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        IPageCache pageCache = this.getPageCache();
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        List errorOrValidateInfos = operationResult.getAllErrorOrValidateInfo();
        parameters.setCustomParam("hasMore", (Object)(errorOrValidateInfos.size() > 5 ? 1 : 0));
        ArrayList<String> list = new ArrayList<String>();
        int len = errorOrValidateInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            IOperateInfo errorInfo = (IOperateInfo)errorOrValidateInfos.get(i);
            list.add(errorInfo.getMessage());
        }
        parameters.setCustomParam("errorMsg", list);
        parameters.setCustomParam("title", (Object)title);
        this.getView().showForm(parameters);
    }

    private DynamicObject getDynObject(HRBaseServiceHelper hrBuCaServiceHelper) {
        DynamicObject dy = hrBuCaServiceHelper.queryOne("id,syncstrategy,description,parent", new QFilter("id", "=", this.getModel().getValue("id")));
        dy.set(PARENT, this.getModel().getValue(PARENT));
        dy.set(DESCRIPTION, this.getModel().getValue(DESCRIPTION));
        dy.set(SYNCSTRATEGY, this.getModel().getValue(SYNCSTRATEGY));
        return dy;
    }

    protected void startJob(List<OrgParam> orgParams, IFormView view, String newViewName, DynamicObject newDyn) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("hbss");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName("HRBUcaSyncStrategyTask");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setRunByLang(RequestContext.get().getLang());
        jobInfo.setTaskClassname(HRBUcaSyncStrategyTask.class.getName());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgParams", SerializationUtils.toJsonString(orgParams));
        params.put(SYNCSTRATEGY, newDyn.get(SYNCSTRATEGY));
        params.put(PARENT, newDyn.get(PARENT));
        params.put(DESCRIPTION, newDyn.get(DESCRIPTION));
        params.put("id", newDyn.get("id"));
        jobInfo.setParams(params);
        view.getFormShowParameter().getCustomParams().putAll(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "HRBUcaSyncStrategyTask");
        String caption = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u201c%1$s\u201d", (String)"HRBUSyncStrategyService_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), newViewName);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCanBackground(false);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCaption(caption);
        this.dispatch(jobFormInfo, view);
    }

    private void dispatch(JobFormInfo jobFormInfo, IFormView view) {
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hbss_syncprocess");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((CharSequence)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getName())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getName());
        }
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        showParameter.setShowClose(false);
        view.showForm(showParameter);
    }

    private DynamicObject getDyObjInModel(HRBaseServiceHelper hrBuCaServiceHelper) {
        Long id = (Long)this.getModel().getValue("id");
        Object parent = this.getModel().getValue(PARENT);
        Object name = this.getModel().getValue("name");
        Object number = this.getModel().getValue("number");
        Object description = this.getModel().getValue(DESCRIPTION);
        Object syncstrategy = this.getModel().getValue(SYNCSTRATEGY);
        DynamicObject dy = hrBuCaServiceHelper.generateEmptyDynamicObject();
        dy.set("id", (Object)id);
        dy.set(PARENT, parent);
        dy.set("name", name);
        dy.set("number", number);
        dy.set(DESCRIPTION, description);
        dy.set(SYNCSTRATEGY, syncstrategy);
        return dy;
    }

    private void showOpConfirmPop(String title, String content) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hbss_opconfirm");
        parameter.setCustomParam("title", (Object)title);
        parameter.setCustomParam("content", (Object)content);
        parameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"HRBUCAEdit_7", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "doConfirm"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(true);
        this.getView().showForm(parameter);
    }

    private long getFieldId(DynamicObject dy, String FiledName) {
        return dy.get(FiledName) instanceof DynamicObject ? ((Long)dy.getDynamicObject(FiledName).getPkValue()).longValue() : dy.getLong(FiledName);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)SYNCSTRATEGY)) {
            this.strategyChange();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        QFilter qFilter = null;
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)PARENT)) {
            qFilter = this.buildControlFunFilter();
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private QFilter buildControlFunFilter() {
        Long[] ids = new Long[]{11L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 35L, 36L, 37L, 38L, 39L};
        List functionIds = Arrays.stream(ids).collect(Collectors.toList());
        List allSyncControlFuncIds = HRBUExtServiceHelper.getSyncViewControlFuncIds();
        functionIds.removeAll(allSyncControlFuncIds);
        long selfHRViewNumber = (Long)this.getModel().getDataEntity().getPkValue();
        functionIds = functionIds.stream().filter(id -> id != selfHRViewNumber).collect(Collectors.toList());
        return new QFilter("id", "in", functionIds).and(HRBUValidationService.getVersionQFilter());
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        long hrBuCaId = this.getView().getModel().getDataEntity().getLong("id");
        String syncStrategy = (String)this.getView().getModel().getValue(SYNCSTRATEGY);
        if (hrBuCaId == 0L) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTNUPDATE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTNSAVE});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTNSAVE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTNUPDATE});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btncancel"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name"});
            this.getView().setVisible(Boolean.valueOf("0".equals(syncStrategy)), new String[]{PARENT});
        }
        LOGGER.info("HRBUCAEdit afterBindData syncStrategy:{}", (Object)syncStrategy);
        if ("0".equals(syncStrategy) || HRStringUtils.isEmpty((String)syncStrategy) || !HRStringUtils.equals((String)syncStrategy, (String)"1")) {
            BasedataEdit control = (BasedataEdit)this.getView().getControl(PARENT);
            control.setMustInput(true);
        }
        this.getView().getModel().setDataChanged(false);
    }

    private void strategyChange() {
        String syncStrategy = (String)this.getView().getModel().getValue(SYNCSTRATEGY);
        BasedataEdit control = (BasedataEdit)this.getView().getControl(PARENT);
        LOGGER.info("HRBUCAEdit strategyChange syncStrategy:{}", (Object)syncStrategy);
        if ("0".equals(syncStrategy) || !HRStringUtils.equals((String)syncStrategy, (String)"1")) {
            control.setMustInput(true);
            this.getModel().setValue(PARENT, (Object)"");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PARENT});
        } else if ("1".equals(syncStrategy)) {
            control.setMustInput(false);
            this.getModel().setValue(PARENT, null);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PARENT});
        }
    }
}

