/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;

public class HRBUViewExtEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String HRBUCA_ID = "HRBUCAId";
    private static final String ORG_ID = "org.id";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        OrgEdit bosOrg = (OrgEdit)this.getControl("name");
        bosOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit bosParentOrg = (OrgEdit)this.getControl("parentorg");
        bosParentOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        DynamicObject orgStructDy;
        Object orgViewId;
        super.beforeBindData(eventObject);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.compareTo((Enum)status) == 0) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        } else if (OperationStatus.EDIT.compareTo((Enum)status) == 0) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
        }
        this.getView().setStatus(status);
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        Object bosOrgStructId = this.getView().getFormShowParameter().getCustomParam("bosorgstructure");
        if (null != bosOrgStructId) {
            dataModel.setValue("bosorgstructure", (Object)new HRBaseServiceHelper("bos_org_structure").queryOne(bosOrgStructId));
        }
        if (null != (orgViewId = view.getFormShowParameter().getCustomParam(HRBUCA_ID))) {
            this.setOrgEditOrgFuncs(orgViewId);
        }
        if (null != (orgStructDy = (DynamicObject)this.getModel().getValue("bosorgstructure"))) {
            dataModel.setValue("name", (Object)orgStructDy.getLong(ORG_ID));
            dataModel.setValue("parentorg", (Object)orgStructDy.getLong("parent.id"));
        }
        dataModel.setDataChanged(false);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        IFormView formView = this.getView();
        String parentorg_identify = (String)formView.getFormShowParameter().getCustomParam("parentorg_identify");
        Control parentorg = formView.getControl("parentorg");
        LocaleString localeString = new LocaleString(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7%s", (String)"HRBUViewExtEdit_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), parentorg_identify));
        ((OrgEdit)parentorg).setCaption(localeString);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        formView.setVisible(Boolean.FALSE, new String[]{"btnclose"});
        if (OperationStatus.ADDNEW.compareTo((Enum)status) == 0) {
            formView.setVisible(Boolean.TRUE, new String[]{"editpanelap", "savebtn", "saveandnew", "btncanel"});
            formView.setVisible(Boolean.FALSE, new String[]{"viewpanelap", "btnclose", "btnupdate", "flexpanelbiz"});
        } else if (OperationStatus.EDIT.compareTo((Enum)status) == 0) {
            formView.setEnable(Boolean.FALSE, new String[]{"name"});
            long hrBuCaId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(HRBUCA_ID) + "");
            DynamicObject hrBuCaDy = HRBUExtServiceHelper.getHrBuCaDyById((long)hrBuCaId);
            String syncStrategy = hrBuCaDy.getString("syncstrategy");
            if ("0".equals(syncStrategy)) {
                formView.setVisible(Boolean.FALSE, new String[]{"btncanel", "btnupdate"});
                formView.setEnable(Boolean.FALSE, new String[]{"description"});
                formView.setVisible(Boolean.TRUE, new String[]{"btnclose"});
            } else {
                formView.setVisible(Boolean.TRUE, new String[]{"btncanel", "btnupdate"});
                formView.setEnable(Boolean.TRUE, new String[]{"description"});
            }
            formView.setVisible(Boolean.FALSE, new String[]{"viewpanelap", "savebtn", "saveandnew"});
            DynamicObject orgStructureDy = (DynamicObject)this.getModel().getValue("bosorgstructure");
            Object orgViewId = this.getView().getFormShowParameter().getCustomParam(HRBUCA_ID);
            TreeNode rootOrgByViewId = HRBUExtServiceHelper.getRootOrgByViewId((Long)Long.valueOf(String.valueOf(orgViewId)));
            if ("0".equals(syncStrategy) || orgStructureDy != null && Long.parseLong(rootOrgByViewId.getId()) == orgStructureDy.getLong(ORG_ID)) {
                formView.setEnable(Boolean.FALSE, new String[]{"parentorg", "name", "number", "simplename"});
            }
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"viewpanelap", "btnclose"});
            formView.setVisible(Boolean.FALSE, new String[]{"editpanelap", "savebtn", "saveandnew", "btncanel"});
            formView.setEnable(Boolean.FALSE, new String[]{"description"});
        }
    }

    private void setOrgEditOrgFuncs(Object orgViewId) {
        String viewNumber = HRBUExtServiceHelper.getViewNumberById((Object)orgViewId);
        if (HRStringUtils.isEmpty((String)viewNumber)) {
            return;
        }
        this.getModel().setValue("viewnumber", (Object)viewNumber);
        OrgProp bosOrgParentAp = (OrgProp)this.getModel().getProperty("parentorg");
        bosOrgParentAp.setOrgFunc(viewNumber);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        Object orgViewId = this.getView().getFormShowParameter().getCustomParam(HRBUCA_ID);
        showParameter.setCustomParam("orgFuncId", (Object)String.valueOf(orgViewId));
        if (null == orgViewId) {
            return;
        }
        DynamicObject[] bosOrgDys = HRBUExtServiceHelper.getAllBosOrgStructureByView((Object)orgViewId);
        List<Object> bosOrgIdList = this.setOrgIdListInView(bosOrgDys);
        switch (fieldKey) {
            case "name": {
                QFilter idFilter = new QFilter("id", "not in", bosOrgIdList);
                QFilter isHRFilter = new QFilter("fishr", "=", (Object)"1");
                idFilter.and(isHRFilter);
                showParameter.getListFilterParameter().setFilter(idFilter);
                break;
            }
            case "parentorg": {
                this.removeSelfFromList(bosOrgIdList);
                QFilter idFilter = new QFilter("id", "in", bosOrgIdList);
                QFilter isHRFilter = new QFilter("fishr", "=", (Object)"1");
                idFilter.and(isHRFilter);
                showParameter.getListFilterParameter().setFilter(idFilter);
                break;
            }
        }
    }

    private List<Object> setOrgIdListInView(DynamicObject[] bosOrgDys) {
        ArrayList<Object> idList = new ArrayList<Object>(bosOrgDys.length);
        if (bosOrgDys.length == 0) {
            return idList;
        }
        for (DynamicObject dy : bosOrgDys) {
            Long bosOrgId = dy.getDynamicObject("org") == null ? 0L : dy.getLong(ORG_ID);
            idList.add(bosOrgId);
        }
        return idList;
    }

    private void removeSelfFromList(List<Object> bosOrgIdList) {
        DynamicObject bosOrgStructDy = (DynamicObject)this.getModel().getValue("bosorgstructure");
        if (null != bosOrgStructDy) {
            Long bosOrgId = bosOrgStructDy.getLong(ORG_ID);
            bosOrgIdList.remove(bosOrgId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"doupdate", (String)formOperate.getOperateKey()) && !this.checkUserPermission("4715a0df000000ac", "hbss_hrbuca")) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201cHR\u4e1a\u52a1\u7ba1\u7406\u89c6\u56fe\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRBUViewQueryTreeList_14", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
        }
    }

    protected boolean checkUserPermission(String permItemId, String entityNum) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"XYRL3+A8Z+Z", (String)entityNum, (String)permItemId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ((HRStringUtils.equals((String)"save", (String)formOperate.getOperateKey()) || HRStringUtils.equals((String)"doupdate", (String)formOperate.getOperateKey()) || HRStringUtils.equals((String)"donew", (String)formOperate.getOperateKey())) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            IListView parentView = (IListView)this.getView().getParentView();
            this.updatePage(parentView);
            this.getView().sendFormAction((IFormView)parentView);
            this.getModel().setDataChanged(false);
        }
    }

    private void updatePage(IListView parentView) {
        parentView.getTreeListView();
        parentView.getTreeListView().focusRootNode();
        parentView.getTreeListView().refreshTreeView();
        parentView.getTreeListView().refresh();
    }
}

