/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OperationType;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgParam;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.servicehelper.BosOrgServiceHelper;
import kd.hr.hbss.common.model.OrgInfo;

public class HRBUcaSyncStrategyTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(HRBUcaSyncStrategyTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        OrgApiResult orgApiResult;
        String desc = ResManager.loadKDString((String)"\u6821\u9a8c\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u5019...", (String)"HRBUcaSyncStrategyTask_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
        String desc2 = ResManager.loadKDString((String)"\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u5019...", (String)"HRBUcaSyncStrategyTask_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
        this.feedbackProgress(10, desc, null);
        List orgParams = SerializationUtils.fromJsonStringToList((String)((String)map.get("orgParams")), OrgParam.class);
        HashMap orgIdToName = Maps.newHashMapWithExpectedSize((int)orgParams.size());
        HashMap orgIdToActionName = Maps.newHashMapWithExpectedSize((int)orgParams.size());
        orgParams.forEach(orgParam -> {
            orgIdToName.put(orgParam.getId(), orgParam.getName());
            orgIdToActionName.put(orgParam.getId(), orgParam.getOperationType().name());
        });
        List collect = orgParams.stream().filter(orgParam -> OperationType.freeze.equals((Object)orgParam.getOperationType())).collect(Collectors.toList());
        List orgInfoList = HRBUValidationService.transferToOrgInfo(collect);
        HRBUValidationService.checkOrgInfoOfFreeze((List)orgInfoList);
        List collectTemp = orgInfoList.stream().filter(OrgInfo::isBusinessStrayRef).collect(Collectors.toList());
        HashMap<String, OrgApiResult> resultMap = new HashMap<String, OrgApiResult>(16);
        if (collectTemp.size() > 0) {
            orgApiResult = new OrgApiResult();
            orgApiResult.setSuccess(false);
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)collectTemp.size());
            for (OrgInfo orgInfo : collectTemp) {
                OrgApiResult orgApiResultTemp = new OrgApiResult();
                orgApiResultTemp.setId(orgInfo.getOrgId().longValue());
                orgApiResultTemp.setNumber(OperationType.freeze.name());
                orgApiResultTemp.setErrorMsg(HRBUValidationService.getStrategyTip((String)String.join((CharSequence)",", orgInfo.getBusinessStrayRefList())));
                resultList.add(orgApiResultTemp);
            }
            orgApiResult.setResultList((List)resultList);
        } else {
            HRBUValidationService.feedbackProgress((int)30, (String)desc2, (String)this.taskId);
            long start = System.currentTimeMillis();
            orgApiResult = BosOrgServiceHelper.batchSyncHROrg((List)orgParams);
            LOGGER.info("HRBUcaSyncStrategyTask : BosOrgServiceHelper.batchSyncHROrg execute result : {}", (Object)orgApiResult.getErrorMsg());
            LOGGER.info("HRBUcaSyncStrategyTask : BosOrgServiceHelper.batchSyncHROrg execute time : {}", (Object)(System.currentTimeMillis() - start));
        }
        if (!orgApiResult.isSuccess()) {
            orgApiResult.getResultList().forEach(orgApiResult1 -> {
                orgApiResult1.setName(orgIdToName.getOrDefault(orgApiResult1.getId(), "undefined"));
                orgApiResult1.setNumber(orgIdToActionName.getOrDefault(orgApiResult1.getId(), "undefined"));
            });
        }
        resultMap.put("orgApiResult", orgApiResult);
        this.feedbackProgress(100, desc2, null);
        this.feedbackCustomdata(resultMap);
    }
}

