/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.schedule.api.TaskInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.common.model.OrgInfo;
import kd.hr.hbss.formplugin.web.hrbu.HROrgResult;

public class HROrgCheckResult
extends HROrgResult {
    private static final String FAILURE_ORG = "failure";
    private static final String VIEW_ORG = "view";
    private List<OrgInfo> nodes;
    private Map<Long, List<OrgInfo>> errorResult;
    private Integer count;
    private Integer successCounts;
    private String viewId;

    public void afterCreateNewData(EventObject e) {
        this.createResultLab();
    }

    public void onGetControl(OnGetControlArgs evt) {
        super.onGetControl(evt);
        String key = evt.getKey();
        if (key.contains(VIEW_ORG)) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            evt.setControl((Control)label);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.contains(VIEW_ORG)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("hbss_failurereason");
            fsp.setHasRight(true);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.initParams();
            fsp.setCustomParam("errorResult", this.errorResult);
            fsp.setCustomParam("allNodes", this.nodes);
            fsp.setCustomParam("orgId", (Object)key.substring(4));
            fsp.setCustomParam("viewId", (Object)this.viewId);
            this.getView().showForm(fsp);
        }
    }

    private void createResultLab() {
        FlexPanelAp funcFlexPanelAp = HROrgCheckResult.createRowFlexPanelAp("flex_result", 0);
        this.initParams();
        int successCount = this.successCounts;
        int failCount = this.count - successCount;
        funcFlexPanelAp.getItems().clear();
        FlexPanelAp resultCountFlexPanelAp = HROrgCheckResult.createRowFlexPanelAp("flex_result_count", 0);
        LabelAp removeFailFieldAp = this.createColorLabelField("result_count", String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u79fb\u9664\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761", (String)"HROrgCheckResult_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), this.count, successCount, failCount), "340px", 14, "#333333", "500");
        resultCountFlexPanelAp.getItems().add(removeFailFieldAp);
        funcFlexPanelAp.getItems().add(resultCountFlexPanelAp);
        FlexPanelAp brFlexPanelAp = HROrgCheckResult.createRowFlexPanelAp("flex_br", 0);
        brFlexPanelAp.setHeight(new LocaleString("40px"));
        funcFlexPanelAp.getItems().add(brFlexPanelAp);
        HashSet existOrg = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<Long, List<OrgInfo>> entry : this.errorResult.entrySet()) {
            int size = entry.getValue().size();
            for (int idx = 0; idx < size; ++idx) {
                OrgInfo org = entry.getValue().get(idx);
                if (!existOrg.add(org.getOrgId())) continue;
                FlexPanelAp orgFlexPanelAp = HROrgCheckResult.createRowFlexPanelAp("flex_result2" + idx, 0);
                LabelAp orgFieldAp = this.createColorLabelField(FAILURE_ORG + idx, org.getName(), "365px", 12, "#666666", "400");
                LabelAp failureFieldAp = this.createFailureLabelField(VIEW_ORG + org.getOrgId(), ResManager.loadKDString((String)"\u67e5\u770b\u5931\u8d25\u539f\u56e0", (String)"HROrgCheckResult_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), "right");
                orgFlexPanelAp.getItems().add(orgFieldAp);
                orgFlexPanelAp.getItems().add(failureFieldAp);
                funcFlexPanelAp.getItems().add(orgFlexPanelAp);
            }
        }
        this.getView().updateControlMetadata("flex_result", funcFlexPanelAp.createControl());
        this.getView().sendFormAction(this.getView());
    }

    private void initParams() {
        String taskInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("taskinfo");
        if (HRStringUtils.isEmpty((String)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (taskInfo.isTaskEnd()) {
            Map taskInfoMap = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            if (Objects.isNull(taskInfoMap)) {
                return;
            }
            List allNodes = (List)taskInfoMap.get("allNodes");
            this.nodes = this.initOrgData(allNodes);
            Map checkErrorResult = (Map)taskInfoMap.get("checkResult");
            this.errorResult = this.initData(checkErrorResult);
            this.count = (Integer)taskInfoMap.get("count");
            this.successCounts = (Integer)taskInfoMap.get("successcount");
            this.viewId = (String)taskInfoMap.get("viewId");
        }
    }
}

