/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.hrbu;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.common.model.OrgInfo;

@ExcludeFromJacocoGeneratedReport
public class HROrgValidateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(HRBUValidationService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        AtomicBoolean isTaskEnd = new AtomicBoolean(false);
        ThreadPools.executeOnce((String)"kd.hr.hbss.formplugin.web.hrbu.HROrgValidateTask.execute.queryTask", () -> {
            while (true) {
                if (this.isStop()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            isTaskEnd.set(true);
        });
        List orgIdList = (List)map.get("orgIdList");
        String viewId = String.valueOf(map.get("viewId"));
        String tip = (String)map.get("tip");
        LongAdder progress = new LongAdder();
        progress.add(10L);
        this.feedbackProgress(progress.intValue(), tip, null);
        List orgInfoList = HRBUExtServiceHelper.getOrgInfo((List)orgIdList, (Long)Long.parseLong(viewId));
        LOGGER.info("HROrgValidateTask validate sel org:{}", (Object)orgInfoList);
        ArrayList orgIdListTemp = Lists.newArrayListWithExpectedSize((int)orgIdList.size());
        orgIdListTemp.addAll(orgIdList);
        List<OrgInfo> freezeOrgList = orgInfoList.stream().filter(OrgInfo::isFreeze).collect(Collectors.toList());
        freezeOrgList.forEach(orgInfo -> orgIdListTemp.remove(orgInfo.getOrgId()));
        List allNodes = HRBUExtServiceHelper.getSubOrg((List)orgIdListTemp, (Long)Long.parseLong(viewId), (Boolean)Boolean.TRUE, null);
        ThreadPools.executeOnce((String)"kd.hr.hbss.formplugin.web.hrbu.HROrgValidateTask.execute", () -> {
            try {
                Thread.sleep(10000L);
                progress.add(10L);
                HRBUValidationService.feedbackProgress((int)progress.intValue(), (String)tip, (String)this.taskId);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        });
        HRBUValidationService.checkOrgInfo((List)allNodes, (String)this.taskId, (LongAdder)progress, (String)tip, (Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}, (AtomicBoolean)isTaskEnd);
        if (isTaskEnd.get()) {
            this.feedbackCustomdata(result);
            return;
        }
        ArrayListMultimap viewId2OrgIds = ArrayListMultimap.create();
        allNodes.forEach(orgInfo -> viewId2OrgIds.put((Object)orgInfo.getViewId(), (Object)orgInfo.getOrgId()));
        Map bizCheckers = HRBUValidationService.getBizCheckers((String)"deleteduty", (String)"OrBizDelChecker");
        LOGGER.info("HROrgValidateTask.execute_getBizCheckers:{}", (Object)bizCheckers);
        for (DynamicObject checkerObj : bizCheckers.values()) {
            Map checkResult;
            long childViewId = checkerObj.getLong("view.id");
            if (!viewId2OrgIds.containsKey((Object)childViewId) || !Objects.nonNull(checkResult = HRBUValidationService.invokerBizChecker((ArrayListMultimap)viewId2OrgIds, (DynamicObject)checkerObj, (long)childViewId)) || checkResult.size() <= 0) continue;
            checkResult.forEach((key, value) -> allNodes.forEach(node -> {
                if (node.getOrgId().equals(key) && value.containsKey(node.getViewId())) {
                    node.setBizMsg(StringUtils.join((Object[])((Set)value.get(node.getViewId())).toArray(), (String)","));
                }
            }));
        }
        List<OrgInfo> rmOrgIds = this.getCheckSussesOrg(orgInfoList, allNodes);
        if (rmOrgIds.isEmpty()) {
            LOGGER.info("HROrgValidateTask validate susses org size is empty");
        } else {
            LOGGER.info("HROrgValidateTask validate need del org :{}", rmOrgIds);
            List orgParams = HRBUValidationService.delOrgArrays(rmOrgIds);
            HashBasedTable errTable = HashBasedTable.create();
            orgParams.stream().filter(orgParam -> !orgParam.isSuccess()).forEach(orgParam2 -> {
                String cfr_ignored_0 = (String)errTable.put((Object)orgParam2.getId(), (Object)Long.valueOf(orgParam2.getDuty()), (Object)orgParam2.getMsg());
            });
            if (errTable.size() > 0) {
                LOGGER.info("HROrgValidateTask delOrgArrays error :{}", (Object)errTable);
                allNodes.forEach(orgInfo -> {
                    String errMsg = (String)errTable.get((Object)orgInfo.getOrgId(), (Object)orgInfo.getViewId());
                    if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                        orgInfo.setBizMsg(errMsg);
                    }
                });
            }
        }
        Map<Long, List<OrgInfo>> checkErrorResult = allNodes.stream().filter(orgInfo -> orgInfo.isBusinessStrayRef() || orgInfo.isBusinessDataRef() || orgInfo.isFreeze() || StringUtils.isNotBlank((CharSequence)orgInfo.getBizMsg())).collect(Collectors.groupingBy(OrgInfo::getViewId));
        if (freezeOrgList.size() > 0) {
            freezeOrgList.forEach(freezeOrgTemp -> {
                List orDefault = checkErrorResult.getOrDefault(freezeOrgTemp.getViewId(), Lists.newArrayList());
                orDefault.add(freezeOrgTemp);
                checkErrorResult.put(freezeOrgTemp.getViewId(), orDefault);
                allNodes.add(freezeOrgTemp);
            });
        }
        result.put("success", "true");
        result.put("allSuccess", CollectionUtils.isEmpty(checkErrorResult));
        result.put("checkResult", checkErrorResult);
        result.put("allNodes", allNodes);
        result.put("count", orgIdList.size());
        result.put("viewId", viewId);
        result.put("selOrg", orgIdList);
        result.put("successcount", this.getSuccessCount(orgInfoList, rmOrgIds));
        this.feedbackCustomdata(result);
    }

    private int getSuccessCount(List<OrgInfo> orgIdList, List<OrgInfo> rmOrgIds) {
        int count = 0;
        Set collect = rmOrgIds.stream().map(OrgInfo::getOrgId).collect(Collectors.toSet());
        for (OrgInfo id : orgIdList) {
            if (!collect.contains(id.getOrgId())) continue;
            ++count;
        }
        return count;
    }

    private List<OrgInfo> getCheckSussesOrg(List<OrgInfo> orgInfoList, List<OrgInfo> allNodes) {
        HashSet successList = Sets.newHashSetWithExpectedSize((int)16);
        HashBasedTable table = HashBasedTable.create();
        HashSet viewIds = Sets.newHashSetWithExpectedSize((int)allNodes.size());
        allNodes.forEach(arg_0 -> HROrgValidateTask.lambda$getCheckSussesOrg$11(viewIds, (Table)table, arg_0));
        block0: for (OrgInfo org : orgInfoList) {
            for (Long viewId : viewIds) {
                String curLongNumber = (String)table.get((Object)org.getOrgId(), (Object)viewId);
                if (StringUtils.isBlank((CharSequence)curLongNumber)) continue;
                if (allNodes.stream().anyMatch(orgInfo -> !(!orgInfo.getLongNumber().startsWith(curLongNumber) && !orgInfo.getOrgId().equals(org.getOrgId()) || !orgInfo.isBusinessDataRef() && !orgInfo.isBusinessStrayRef() && !orgInfo.isFreeze() && !StringUtils.isNotBlank((CharSequence)orgInfo.getBizMsg())))) continue block0;
                successList.addAll(allNodes.stream().filter(orgInfo -> orgInfo.getLongNumber().startsWith(curLongNumber)).collect(Collectors.toList()));
            }
        }
        return new ArrayList<OrgInfo>(successList);
    }

    private static /* synthetic */ void lambda$getCheckSussesOrg$11(Set viewIds, Table table, OrgInfo node) {
        viewIds.add(node.getViewId());
        table.put((Object)node.getOrgId(), (Object)node.getViewId(), (Object)node.getLongNumber());
    }
}

