/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.lawentity;

import java.util.Collection;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class LawEntityListPlugin
extends HRDataBaseList {
    private static final String BAR_CHGMODIFY = "bar_chgmodify";
    private static final String ENTITYTYPE = "entitytype";
    private static final String SHOWCHGFLAG = "showChgFlag";
    private static final String SHOWCHGFLAG_YES = "yes";
    private static final String PROPCTL = "propctl";
    private static final String OPRSTS = "oprsts";
    private static final String OPRSTS_1 = "1";
    private static final String OPRSTS_2 = "2";
    private static final String ADMINORG = "adminorg";
    private static final String ADDRESS = "address";
    private static final String CHGSAVEFLAG = "chgSaveFlag";
    private static final String SAVESUCCESS = "savesuccess";
    private static final String CHGINFFLAG = "chgInfFlag";
    private static final String CLOSECHGINFFLAG = "closeChgInfFlag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BAR_CHGMODIFY});
    }

    public void itemClick(ItemClickEvent evt) {
        super.click((EventObject)evt);
        if (HRStringUtils.equals((String)evt.getItemKey(), (String)BAR_CHGMODIFY)) {
            IListView view = (IListView)this.getView();
            ListSelectedRowCollection selectRows = view.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectRows)) {
                return;
            }
            boolean isAllowChg = this.chkIsAllowChg(selectRows);
            if (!isAllowChg) {
                return;
            }
            this.openChgView(selectRows);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"number", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            this.getView().getPageCache().put(CHGINFFLAG, CLOSECHGINFFLAG);
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        String chgInfFlag = this.getPageCache().get(CHGINFFLAG);
        if (null != chgInfFlag && StringUtils.equals((CharSequence)chgInfFlag, (CharSequence)CLOSECHGINFFLAG)) {
            this.getView().getPageCache().remove(CHGINFFLAG);
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals("reflashPararentData")) {
            String chgSaveFlag = this.getPageCache().get(CHGSAVEFLAG);
            if (StringUtils.equals((CharSequence)chgSaveFlag, (CharSequence)SAVESUCCESS)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"LawEntityListPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                this.getView().getPageCache().remove(CHGSAVEFLAG);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void openChgView(ListSelectedRowCollection selectRows) {
        HRBaseServiceHelper lawHelper = new HRBaseServiceHelper("hbss_lawentity");
        DynamicObject lawEntity = lawHelper.queryOne("name,entitytype,propctl,oprsts,description,adminorg,address", selectRows.get(0).getPrimaryKeyValue());
        BaseShowParameter showParam = new BaseShowParameter();
        showParam.setFormId("hbss_lawentitychg");
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.setPkId(lawEntity.getPkValue());
        showParam.setStatus(OperationStatus.EDIT);
        showParam.setCustomParam(SHOWCHGFLAG, (Object)SHOWCHGFLAG_YES);
        showParam.setCustomParam("name", lawEntity.get("name"));
        showParam.setCustomParam(ENTITYTYPE, lawEntity.get(ENTITYTYPE));
        showParam.setCustomParam(PROPCTL, lawEntity.get(PROPCTL));
        showParam.setCustomParam(OPRSTS, lawEntity.get(OPRSTS));
        showParam.setCustomParam("description", (Object)lawEntity.getString("description"));
        DynamicObject adminOrg = (DynamicObject)lawEntity.get(ADMINORG);
        if (null != adminOrg) {
            showParam.setCustomParam(ADMINORG, adminOrg.getPkValue());
            showParam.setCustomParam(ADDRESS, lawEntity.get(ADDRESS));
            showParam.setCustomParam("faddress", (Object)adminOrg.getString("faddress"));
        }
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reflashPararentData"));
        this.getView().showForm((FormShowParameter)showParam);
    }

    private boolean chkIsAllowChg(ListSelectedRowCollection selectRows) {
        boolean isAudit;
        HRBaseServiceHelper configHelper;
        DynamicObject paramConfig;
        int rowSize = selectRows.size();
        if (rowSize != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u64cd\u4f5c\u53ea\u5141\u8bb8\u53d8\u66f4\u4e00\u6761\u6570\u636e\u3002", (String)"LawEntityListPlugin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        String dataSts = selectRows.get(0).getBillStatus();
        if (("B".equals(dataSts) || "C".equals(dataSts)) && null != (paramConfig = (configHelper = new HRBaseServiceHelper("hbss_parameterconfig")).queryOne("auditcheck", new QFilter[]{new QFilter("basedatafield", "=", (Object)"hbss_lawentity")})) && (isAudit = ((Boolean)paramConfig.get("auditcheck")).booleanValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b9e\u4f53\u7684\u53c2\u6570\u914d\u7f6e\u5df2\u5f00\u542f\u5ba1\u6838\u6a21\u5f0f\uff0c\u53ea\u5141\u8bb8\u53d8\u66f4\u6570\u636e\u72b6\u6001\u4e3a\u6682\u5b58\u7684\u6570\u636e\u3002", (String)"LawEntityListPlugin_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        HRBaseServiceHelper lawHelper = new HRBaseServiceHelper("hbss_lawentity");
        DynamicObject lawEntity = lawHelper.queryOne(OPRSTS, selectRows.get(0).getPrimaryKeyValue());
        String oprSts = lawEntity.getString(OPRSTS);
        if (StringUtils.equals((CharSequence)oprSts, (CharSequence)OPRSTS_2)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ecf\u8425\u72b6\u6001\u4e3a\u5df2\u6ce8\u9500\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"LawEntityListPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void chkOprSts(Object pkId) {
        HRBaseServiceHelper lawHelper = new HRBaseServiceHelper("hbss_lawentity");
        DynamicObject lawEntity = lawHelper.queryOne(OPRSTS, pkId);
        String oprSts = lawEntity.getString(OPRSTS);
        if (StringUtils.equals((CharSequence)oprSts, (CharSequence)OPRSTS_2)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ecf\u8425\u72b6\u6001\u4e3a\u5df2\u6ce8\u9500\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"LawEntityListPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
    }
}

