/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.login.pc;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Image;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.common.util.DynamicObjectJsonSerializer;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hbss.bussiness.domain.repository.login.HrLoginCommonRepository;
import kd.hr.hbss.common.constants.login.EnumLoginType;
import kd.hr.hbss.common.constants.login.LoginCommonConstants;
import kd.hr.hbss.common.constants.login.LoginFormConstants;
import kd.hr.hbss.formplugin.web.login.AbstractCommonLogin;

public class PcCommonLoginPlugin
extends HRDynamicFormBasePlugin
implements AbstractCommonLogin,
LoginCommonConstants,
LoginFormConstants {
    private static final Log LOGGER = LogFactory.getLog(PcCommonLoginPlugin.class);
    private static final String CACHE_KEY_TEMP_BIZ_USER_ID = "tempBizUserId";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"telephonelogintype", "emaillogintype", "usernamelogintype"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.init();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey;
        switch (fieldKey = args.getProperty().getName()) {
            case "lang": {
                this.languagePropertyChanged((IFormPlugin)this, this.getView(), "lang", "langCallBackId", it -> this.showCurrentLang());
                break;
            }
            case "selectstatus": {
                this.getView().setEnable((Boolean)this.getModel().getValue("selectstatus"), new String[]{"btn_login"});
                break;
            }
            case "telephone": 
            case "email": {
                this.setLabelValue(this.getView(), "labelap_err", "");
                break;
            }
            case "telephonecode": 
            case "emailcode": {
                if (HRStringUtils.equals((String)"telephonecode", (String)fieldKey) && !this.isValidPhone(this.getView(), (String)this.getModel().getValue("telephone"))) {
                    return;
                }
                if (!HRStringUtils.equals((String)"emailcode", (String)fieldKey) || this.isValidEmail(this.getView(), (String)this.getModel().getValue("email"))) break;
                return;
            }
            case "passwordcode": {
                String userName = (String)this.getModel().getValue("username");
                String code = (String)this.getModel().getValue(fieldKey);
                if (HRStringUtils.isEmpty((String)code)) {
                    this.setLabelValue(this.getView(), "labelap_err", ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_19", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setLabelValue(this.getView(), "labelap_err", "");
                if (!HRStringUtils.isNotEmpty((String)userName) || !HRStringUtils.isNotEmpty((String)code)) break;
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_login"});
                break;
            }
            case "username": {
                String userName = (String)this.getModel().getValue(fieldKey);
                String userCode = (String)this.getModel().getValue("passwordcode");
                if (HRStringUtils.isEmpty((String)userName)) {
                    this.setLabelValue(this.getView(), "labelap_err", ResManager.loadKDString((String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_13", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.setLabelValue(this.getView(), "labelap_err", "");
                if (!HRStringUtils.isNotEmpty((String)userName) || !HRStringUtils.isNotEmpty((String)userCode)) break;
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_login"});
                break;
            }
            case "currentlogintype": {
                String loginType = (String)this.getModel().getValue("currentlogintype");
                if (HRStringUtils.equals((String)loginType, (String)EnumLoginType.ANONYMOUS.getType())) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btn_login"});
                    break;
                }
                this.getView().setEnable((Boolean)this.getModel().getValue("selectstatus"), new String[]{"btn_login"});
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)"langCallBackId", (String)callBackId)) {
            if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
                this.switchLanguage(this.getView(), "1", (String)this.getModel().getValue("lang"), "hbss_commonloginpc");
            } else {
                this.showCurrentLang();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String privacyEnable = this.getPageCache().get("privacyDisable");
        if (HRStringUtils.isNotEmpty((String)privacyEnable)) {
            this.setLabelValue(this.getView(), "labelap_err", ResManager.loadKDString((String)"\u9690\u79c1\u670d\u52a1\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AbstractCommonLogin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (args.getSource() instanceof FormOperate) {
            String operateKey = ((FormOperate)args.getSource()).getOperateKey();
            DynamicObject loginConfigItem = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)this.getPageCache().get("loginConfigItem"), (String)"hbss_loginconfig");
            String originalBizUserId = (String)this.getView().getFormShowParameter().getCustomParam("bizUserId");
            Map params = this.getSafeUriParamsFromCache(null, this.getPageCache());
            String loginType = (String)this.getModel().getValue("currentlogintype");
            String bizUserId = originalBizUserId;
            LOGGER.info("Got params: {} and loginType: {} from page cache.", (Object)params, (Object)loginType);
            String email = (String)this.getModel().getValue("email");
            String phone = (String)this.getModel().getValue("telephone");
            Boolean privacySelectStatus = (Boolean)this.getModel().getValue("selectstatus");
            long privacyId = HRLongValueParseService.getInstance().parseLong((Object)this.getPageCache().get("maxPrivacyStatementId"));
            block6 : switch (operateKey) {
                case "sendsms": {
                    if (!this.isValidPrivacySelectStatus(this.getView(), privacySelectStatus) || !this.isValidPhone(this.getView(), phone)) {
                        args.setCancel(true);
                        break;
                    }
                    bizUserId = this.getBizUserId("1", loginConfigItem, originalBizUserId, params, loginType, phone);
                    if (this.checkUserIdAndValue(this.getView(), bizUserId, loginType, phone, null)) break;
                    args.setCancel(true);
                    break;
                }
                case "sendemail": {
                    if (!this.isValidPrivacySelectStatus(this.getView(), privacySelectStatus) || !this.isValidEmail(this.getView(), email)) {
                        args.setCancel(true);
                        break;
                    }
                    bizUserId = this.getBizUserId("1", loginConfigItem, originalBizUserId, params, loginType, email);
                    if (this.checkUserIdAndValue(this.getView(), bizUserId, loginType, email, null)) break;
                    args.setCancel(true);
                    break;
                }
                case "viewprivacy": {
                    if (privacyId != 0L) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9690\u79c1\u58f0\u660e\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_24", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                case "confirmlogin": {
                    String terminalType = "1";
                    switch (loginType) {
                        case "1": {
                            bizUserId = this.getBizUserId(terminalType, loginConfigItem, originalBizUserId, params, loginType, phone);
                            this.validatePhoneBeforeDoOperation(this.getView(), this.getPageCache(), this.getModel(), args, phone, bizUserId, loginType, privacyId, "1");
                            break block6;
                        }
                        case "2": {
                            bizUserId = this.getBizUserId(terminalType, loginConfigItem, originalBizUserId, params, loginType, email);
                            this.validateEmailBeforeDoOperation(this.getView(), this.getPageCache(), this.getModel(), args, email, bizUserId, loginType, privacyId, "1");
                            break block6;
                        }
                        case "3": {
                            String userName = (String)this.getModel().getValue("username");
                            String password = (String)this.getModel().getValue("passwordcode");
                            bizUserId = this.getBizUserId(terminalType, loginConfigItem, originalBizUserId, params, loginType, userName);
                            this.validatePasswordBeforeDoOperation(this.getView(), this.getPageCache(), args, userName, password, bizUserId, loginType, "1");
                            break block6;
                        }
                    }
                    break;
                }
                default: {
                    LOGGER.info("Ignore operate key: {}.", (Object)operateKey);
                }
            }
            this.getPageCache().put(CACHE_KEY_TEMP_BIZ_USER_ID, bizUserId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        String bizUserId = this.getPageCache().get(CACHE_KEY_TEMP_BIZ_USER_ID);
        String loginType = (String)this.getModel().getValue("currentlogintype");
        switch (operateKey = args.getOperateKey()) {
            case "sendsms": {
                String telephone = (String)this.getModel().getValue("telephone");
                this.sendMessage(this.getView(), bizUserId, loginType, telephone);
                break;
            }
            case "sendemail": {
                String email = (String)this.getModel().getValue("email");
                this.sendMessage(this.getView(), bizUserId, loginType, email);
                break;
            }
            case "confirmlogin": {
                String value1 = "";
                String value2 = "";
                if (HRStringUtils.equals((String)"1", (String)loginType)) {
                    value1 = (String)this.getModel().getValue("telephone");
                    value2 = (String)this.getModel().getValue("telephonecode");
                } else if (HRStringUtils.equals((String)"2", (String)loginType)) {
                    value1 = (String)this.getModel().getValue("email");
                    value2 = (String)this.getModel().getValue("emailcode");
                } else if (HRStringUtils.equals((String)"3", (String)loginType)) {
                    value1 = (String)this.getModel().getValue("username");
                    value2 = (String)this.getModel().getValue("passwordcode");
                }
                String formId = (String)this.getView().getFormShowParameter().getCustomParam("bizFormId");
                String loginConfigNumber = (String)this.getView().getFormShowParameter().getCustomParam("loginConfigNumber");
                String originalBizUserId = (String)this.getView().getFormShowParameter().getCustomParam("bizUserId");
                String bizCustomParam = (String)this.getView().getFormShowParameter().getCustomParam("bizCustomParam");
                this.updateMessageStatus(loginType, value1, value2);
                this.hrUserLogin(this.getView(), formId, loginConfigNumber, originalBizUserId, bizUserId, bizCustomParam, loginType, value1, value2);
                break;
            }
            case "viewprivacy": {
                long privacyId = HRLongValueParseService.getInstance().parseLong((Object)this.getPageCache().get("maxPrivacyStatementId"));
                String backFormId = "hbss_commonloginpc";
                String privacyFormId = "hbss_pcprivacy";
                this.viewPrivacy(this.getView(), privacyId, ShowType.NewWindow, backFormId, privacyFormId);
                break;
            }
            default: {
                LOGGER.info("Ignore operate key: {}.", (Object)operateKey);
            }
        }
    }

    public void customEvent(CustomEventArgs eventArgs) {
        String eventKey = eventArgs.getKey();
        if (HRStringUtils.equals((String)"privacy", (String)eventKey)) {
            long privacyId = HRLongValueParseService.getInstance().parseLong((Object)this.getPageCache().get("maxPrivacyStatementId"));
            if (privacyId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9690\u79c1\u58f0\u660e\u4e3a\u7a7a\u3002", (String)"AbstractCommonLogin_24", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return;
            }
            String backFormId = "hbss_commonloginpc";
            String privacyFormId = "hbss_pcprivacy";
            this.viewPrivacy(this.getView(), privacyId, ShowType.NewWindow, backFormId, privacyFormId);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object eventSource = evt.getSource();
        if (eventSource instanceof Container) {
            String containerKey = ((Container)eventSource).getKey();
            LOGGER.info("Click with containerKey: {}.", (Object)containerKey);
            switch (containerKey) {
                case "telephonelogintype": {
                    this.getModel().setValue("currentlogintype", (Object)EnumLoginType.PHONE.getType());
                    break;
                }
                case "emaillogintype": {
                    this.getModel().setValue("currentlogintype", (Object)EnumLoginType.EMAIL.getType());
                    break;
                }
                case "usernamelogintype": {
                    this.getModel().setValue("currentlogintype", (Object)EnumLoginType.ANONYMOUS.getType());
                    break;
                }
                default: {
                    LOGGER.info("Ignore with key: {}.", (Object)containerKey);
                }
            }
            this.setLabelValue(this.getView(), "labelap_err", "");
        } else {
            LOGGER.info("Ignore with eventSource: {}.", eventSource);
        }
    }

    private void init() {
        String loginConfigNumber = (String)this.getView().getFormShowParameter().getCustomParam("loginConfigNumber");
        String bizUserId = (String)this.getView().getFormShowParameter().getCustomParam("bizUserId");
        String bizCustomParam = (String)this.getView().getFormShowParameter().getCustomParam("bizCustomParam");
        String originalUrlParams = HrGuestUrlUtil.getMobileHtmlUrl((String)RequestContext.get().getAccountId(), (String)loginConfigNumber, (String)bizUserId, (String)bizCustomParam).replace(UrlService.getDomainContextUrl() + "/", "");
        LOGGER.info("Got init params loginConfigNumber: {}, bizUserId: {}, bizCustomParam: {}, originalUrlParams: {}.", new Object[]{loginConfigNumber, bizUserId, bizCustomParam, originalUrlParams});
        DynamicObject loginConfigItem = HrLoginCommonRepository.loadLoginConfigByNumber((String)loginConfigNumber);
        if (null != loginConfigItem) {
            Map params = this.getSafeUriParamsFromCache(originalUrlParams, this.getPageCache());
            LOGGER.info("Got safe uri[{}] params: {}.", (Object)originalUrlParams, (Object)params);
            this.initPic(loginConfigItem);
            List<String> loginTypeList = this.initLoginType(loginConfigItem, params);
            this.initPrivacy(loginConfigItem, bizUserId, params, this.getPageCache(), this.getView(), this.getModel());
            this.initLanguage(loginTypeList);
            this.getPageCache().put("bizAppId", loginConfigItem.getString("redirectappformid.bizappid.id"));
            this.getPageCache().put("loginConfigItem", DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)loginConfigItem));
        } else {
            LOGGER.info("Can not get login config data with number: {}.", (Object)loginConfigNumber);
        }
        this.refreshLoginButtonEnable(this.getModel(), this.getView());
    }

    private void initPic(DynamicObject loginConfigItem) {
        String bannerPic;
        String imageServerUrl = UrlService.getDomainContextUrl() + "/" + "attachment" + "/" + "downloadImage";
        String bannerGroup = loginConfigItem.getString("bannergroupapp");
        String appBannerPic = loginConfigItem.getString("appbannerpic");
        if (HRStringUtils.equals((String)"99", (String)bannerGroup)) {
            bannerPic = !appBannerPic.startsWith("/images") && !appBannerPic.startsWith("/kingdee") ? (appBannerPic.startsWith("/") ? imageServerUrl + appBannerPic : imageServerUrl + "/" + appBannerPic) : appBannerPic;
        } else {
            bannerPic = loginConfigItem.getString("sysappbannerpic");
            String nonZHImage = loginConfigItem.getString("sysappbannerpicl");
            if (HRStringUtils.isNotEmpty((String)nonZHImage) && !RequestContext.get().getLang().getLangTag().startsWith("zh-")) {
                bannerPic = nonZHImage;
            }
        }
        ((Image)this.getControl("bannerpic")).setUrl(bannerPic);
        String backgroundGroup = loginConfigItem.getString("backgroundgroupapp");
        String appBackgroundPic = loginConfigItem.getString("appbackgroundpic");
        String backgroundPic = HRStringUtils.equals((String)"99", (String)backgroundGroup) ? (!appBackgroundPic.startsWith("/images") && !appBackgroundPic.startsWith("/kingdee") ? (appBackgroundPic.startsWith("/") ? imageServerUrl + appBackgroundPic : imageServerUrl + "/" + appBackgroundPic) : appBackgroundPic) : loginConfigItem.getString("sysappbackgroundpic");
        Container flexPanel = (Container)this.getView().getControl("flexpanelap1");
        flexPanel.setBackgroundImg(backgroundPic);
    }

    private void initLanguage(List<String> loginTypeList) {
        String loginType = (String)this.getModel().getValue("currentlogintype");
        String formId = this.getPageCache().get("businessFormId");
        List comboItemList = this.buildDefaultLangComboList(loginTypeList, formId);
        ComboEdit sysLangEdit = (ComboEdit)this.getControl("lang");
        sysLangEdit.setComboItems(comboItemList);
        Set sysLangNumberSet = comboItemList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
        String currentLangNumber = RequestContext.get().getLang().name();
        LOGGER.info("Init language with currentLangNumber: {}, sysLangNumberSet: {}, loginType: {}.", new Object[]{currentLangNumber, sysLangNumberSet, loginType});
        this.showCurrentLang();
    }

    private List<String> initLoginType(DynamicObject loginConfigItem, Map<String, Object> params) {
        List comboItems = this.buildLoginTypeComboItems(loginConfigItem, params);
        ComboEdit loginTypeEdit = (ComboEdit)this.getControl("currentlogintype");
        loginTypeEdit.setComboItems(comboItems);
        this.getModel().setValue("currentlogintype", (Object)((ComboItem)comboItems.get(0)).getValue());
        Set loginTypes = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toSet());
        if (!loginTypes.contains("1")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"telephonelogintype"});
        }
        if (!loginTypes.contains("2")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"emaillogintype"});
        }
        if (!loginTypes.contains("3")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"usernamelogintype"});
        }
        if (1 == comboItems.size()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"otherlogintype"});
        }
        return this.transComboItemListToSet(comboItems);
    }

    private void showCurrentLang() {
        this.getModel().beginInit();
        this.getModel().setValue("lang", (Object)RequestContext.get().getLang().name());
        this.getView().updateView("lang");
        this.getModel().endInit();
    }
}

