/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.md;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class JobGradeScmList
extends HRDataBaseList {
    private Map<Long, String> concatenatedDetailMap = null;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynamicObjectCollection = super.getData(start, limit);
                if (dynamicObjectCollection.isEmpty()) {
                    return dynamicObjectCollection;
                }
                ArrayList<Long> rowIds = new ArrayList<Long>();
                for (DynamicObject row : dynamicObjectCollection) {
                    rowIds.add(row.getLong("id"));
                }
                if (!rowIds.isEmpty()) {
                    JobGradeScmList.this.concatenatedDetailMap = JobGradeScmList.this.getConcatenatedDetail(rowIds);
                }
                return dynamicObjectCollection;
            }
        });
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvent.getSource();
        switch (columnDesc.getFieldKey()) {
            case "jobgradedetail": {
                Long rowId = packageDataEvent.getRowData().getLong("id");
                if (null == this.concatenatedDetailMap || null == rowId) break;
                this.setFormatValueByRowId(packageDataEvent, rowId);
                break;
            }
        }
    }

    private void setFormatValueByRowId(PackageDataEvent event, Long rowId) {
        if (null != this.concatenatedDetailMap.get(rowId)) {
            event.setFormatValue((Object)this.concatenatedDetailMap.get(rowId));
        }
    }

    private Map<Long, String> getConcatenatedDetail(List<Long> rowIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hjms_jobgradescm");
        QFilter jobGradeFilter = new QFilter("id", "in", rowIds);
        Object[] jobGradeObjArrays = hrBaseServiceHelper.query("id, entryentity.jobgrade_name", new QFilter[]{jobGradeFilter});
        if (null != jobGradeObjArrays && !HRArrayUtils.isEmpty((Object[])jobGradeObjArrays)) {
            HashMap<Long, String> concatenatedNameMap = new HashMap<Long, String>();
            for (Object jobGradeObj : jobGradeObjArrays) {
                Long id = jobGradeObj.getLong("id");
                DynamicObjectCollection jobGradeDetailCol = jobGradeObj.getDynamicObjectCollection("entryentity");
                if (null == jobGradeDetailCol || jobGradeDetailCol.isEmpty()) continue;
                StringBuilder concatenatedName = new StringBuilder();
                this.apendName(jobGradeDetailCol, concatenatedName);
                concatenatedNameMap.put(id, concatenatedName.toString());
            }
            return concatenatedNameMap;
        }
        return null;
    }

    private void apendName(DynamicObjectCollection jobGradeDetailCol, StringBuilder concatenatedName) {
        int size = jobGradeDetailCol.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                concatenatedName.append(((DynamicObject)jobGradeDetailCol.get(i)).get("jobgrade_name"));
                continue;
            }
            if (i < 4) {
                concatenatedName.append(", ");
                concatenatedName.append(((DynamicObject)jobGradeDetailCol.get(i)).get("jobgrade_name"));
                continue;
            }
            concatenatedName.append("...");
            break;
        }
    }
}

