/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.md;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class JobLevelScmList
extends HRDataBaseList {
    private Map<Long, String> concatenatedDetailMap = null;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                ArrayList<Long> rowIds = new ArrayList<Long>();
                for (DynamicObject row : rows) {
                    rowIds.add(row.getLong("id"));
                }
                if (!rowIds.isEmpty()) {
                    JobLevelScmList.this.concatenatedDetailMap = JobLevelScmList.this.getConcatenatedDetail(rowIds);
                }
                return rows;
            }
        });
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        switch (columnDesc.getFieldKey()) {
            case "jobleveldetail": {
                Long rowId = event.getRowData().getLong("id");
                if (null == this.concatenatedDetailMap) break;
                this.setFormValueByRowId(event, rowId);
                break;
            }
        }
    }

    private void setFormValueByRowId(PackageDataEvent event, Long rowId) {
        if (null != rowId && null != this.concatenatedDetailMap.get(rowId)) {
            event.setFormatValue((Object)this.concatenatedDetailMap.get(rowId));
        }
    }

    private Map<Long, String> getConcatenatedDetail(List<Long> rowIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hjms_joblevelscm");
        QFilter jobLevelFilter = new QFilter("id", "in", rowIds);
        Object[] jobLevelObjArrays = hrBaseServiceHelper.query("id, entryentity.joblevel_name", new QFilter[]{jobLevelFilter});
        if (null != jobLevelObjArrays && !HRArrayUtils.isEmpty((Object[])jobLevelObjArrays)) {
            HashMap<Long, String> concatenatedNameMap = new HashMap<Long, String>();
            for (Object jobLevelObj : jobLevelObjArrays) {
                Long id = jobLevelObj.getLong("id");
                DynamicObjectCollection jobLevelDetailCol = jobLevelObj.getDynamicObjectCollection("entryentity");
                if (null == jobLevelDetailCol || jobLevelDetailCol.isEmpty()) continue;
                StringBuilder concatenatedName = new StringBuilder();
                this.appendName(jobLevelDetailCol, concatenatedName);
                concatenatedNameMap.put(id, concatenatedName.toString());
            }
            return concatenatedNameMap;
        }
        return null;
    }

    private void appendName(DynamicObjectCollection jobLevelDetailCol, StringBuilder concatenatedName) {
        int size = jobLevelDetailCol.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                concatenatedName.append(((DynamicObject)jobLevelDetailCol.get(i)).get("joblevel_name"));
                continue;
            }
            if (i < 4) {
                concatenatedName.append(", ");
                concatenatedName.append(((DynamicObject)jobLevelDetailCol.get(i)).get("joblevel_name"));
                continue;
            }
            concatenatedName.append("...");
            break;
        }
    }
}

