/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.perflevel;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.application.service.TipsApplicationService;
import kd.hr.hbss.bussiness.domain.preflevel.enums.LevelScoreMapEnum;
import kd.hr.hbss.bussiness.domain.preflevel.enums.OperationTypeEnum;
import kd.hr.hbss.bussiness.domain.preflevel.enums.PerfLevelChangeTypeEnum;

public class LevelScoreMapPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private static final String SCORE_SYSTEM_CONFIROM_KEY = "scoresystemconfironkey";
    private static final String SCORE_SYSTEM_CHANGE = "scoresystemchange";
    private static final String SCORESYSTEM_ID = "scoresystem.id";
    TipsApplicationService TIPS_APPLICATION_SERVICE = TipsApplicationService.getInstance();

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String index = (String)showParameter.getCustomParam("index");
        String pageId = (String)showParameter.getCustomParam("parentId");
        if (HRStringUtils.isNotEmpty((String)index)) {
            this.showParentEntry(index, pageId);
        } else {
            this.levelScoreMapReload(pageId);
        }
        IFormView iFormView = this.getView().getView((String)showParameter.getCustomParam("parentId"));
        HashSet<String> pageIdSet = HRStringUtils.isNotEmpty((String)iFormView.getPageCache().get("scoremapentitypage")) ? (Set)SerializationUtils.fromJsonString((String)iFormView.getPageCache().get("scoremapentitypage"), Set.class) : new HashSet<String>();
        pageIdSet.add(this.getView().getPageId());
        iFormView.getPageCache().put("scoremapentitypage", SerializationUtils.toJsonString(pageIdSet));
        this.changeRelationShip();
    }

    private void showParentEntry(String index, String pageId) {
        DynamicObjectCollection entryEntities = this.getView().getView(pageId).getModel().getEntryEntity("scoremapentryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntities.get(Integer.parseInt(index));
        DynamicObject dyc = this.getModel().getDataEntity();
        dyc.set("scoresystem", dynamicObject.get("scoresystem"));
        dyc.set("levelscoremap", dynamicObject.get("levelscoremap"));
        dyc.set("isscorelowerlimit", dynamicObject.get("isscorelowerlimit"));
        dyc.set("isscoreupperlimit", dynamicObject.get("isscoreupperlimit"));
        dyc.set("entryboidscore", dynamicObject.get("entryboidscore"));
        this.setEntryEntry(dynamicObject);
    }

    private void setEntryEntry(DynamicObject dynamicObject) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection subEntryEntities = dynamicObject.getDynamicObjectCollection("scoresubentryentity");
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("maxscore", new Object[0]);
        setter.addField("scoremaxoperation", new Object[0]);
        setter.addField("scoreminoperation", new Object[0]);
        setter.addField("scorelevel", new Object[0]);
        setter.addField("minscore", new Object[0]);
        setter.addField("defaultscore", new Object[0]);
        setter.addField("scoredescription", new Object[0]);
        setter.addField("entryboidscoresub", new Object[0]);
        for (DynamicObject entry : subEntryEntities) {
            setter.addRow(new Object[]{entry.get("maxscore"), entry.get("scoremaxoperation"), entry.get("scoreminoperation"), entry.get("scorelevel"), entry.get("minscore"), entry.get("defaultscore"), entry.get("scoredescription"), entry.get("entryboidscoresub")});
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void levelScoreMapReload(String pageId) {
        IFormView iFormView = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)iFormView.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        DynamicObjectCollection entryEntities = this.getView().getView(pageId).getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        int size = entryEntities.size();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("scorelevel", new Object[0]);
        for (DynamicObject entry : entryEntities) {
            setter.addRow(new Object[]{entry.get("levelname")});
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        if (size > 0) {
            for (int index = 0; index < size; ++index) {
                model.setValue("scoremaxoperation", (Object)OperationTypeEnum.LESS_OR_EQUAL.getEq(), index);
                model.setValue("scoreminoperation", (Object)OperationTypeEnum.LESS_THAN.getEq(), index);
            }
            model.setValue("maxscore", null, 0);
            model.setValue("scoremaxoperation", null, 0);
        }
        model.endInit();
        iFormView.updateView("entryentity");
        this.isScoreLowerLimit();
        this.isScoreUpperLimit();
    }

    private void levelScoreMapUpdate(String pageId) {
        IFormView iFormView = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)iFormView.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntities = this.getView().getView(pageId).getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        for (int index = 0; index < entryEntities.size(); ++index) {
            model.setValue("scorelevel", (Object)((DynamicObject)entryEntities.get(index)).getString("levelname"), index);
        }
        model.endInit();
        iFormView.updateView("entryentity");
        this.isScoreLowerLimit();
        this.isScoreUpperLimit();
    }

    private void setEntryEntity(int index, String key, Object value) {
        IFormView iFormView = this.getView();
        IDataModel model = iFormView.getModel();
        model.beginInit();
        model.setValue(key, value, index);
        model.endInit();
        iFormView.updateView("entryentity");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        IFormView iFormView = this.getView().getView((String)showParameter.getCustomParam("parentId"));
        HashSet<String> pageIdSet = HRStringUtils.isNotEmpty((String)iFormView.getPageCache().get("scoremapentitypage")) ? (Set)SerializationUtils.fromJsonString((String)iFormView.getPageCache().get("scoremapentitypage"), Set.class) : new HashSet<String>();
        pageIdSet.add(this.getView().getPageId());
        iFormView.getPageCache().put("scoremapentitypage", SerializationUtils.toJsonString(pageIdSet));
        this.changeRelationShip();
        this.initTips("levelscoremap");
        this.initTips("isscoreupperlimit");
        this.initTips("isscorelowerlimit");
    }

    private void initTips(String key) {
        List tips = this.TIPS_APPLICATION_SERVICE.getTips("hbss_perflevel", key);
        if (!ObjectUtils.isEmpty((Object)tips) && tips.size() > 0) {
            HashMap<String, Tips> textProps = new HashMap<String, Tips>(16);
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString((String)tips.get(0)));
            textProps.put("tips", textTips);
            this.getView().updateControlMetadata(key, textProps);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && opResult.isSuccess()) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            switch (afterDoOperationEventArgs.getOperateKey()) {
                case "reload": {
                    this.levelScoreMapReload((String)showParameter.getCustomParam("parentId"));
                    break;
                }
                case "update": {
                    this.levelScoreMapUpdate((String)showParameter.getCustomParam("parentId"));
                    break;
                }
                case "delete": {
                    IFormView iFormView = this.getView().getView((String)showParameter.getCustomParam("parentId"));
                    Set pageIdSet = (Set)SerializationUtils.fromJsonString((String)iFormView.getPageCache().get("scoremapentitypage"), Set.class);
                    String numStr = iFormView.getPageCache().get("scopeLevelNumber");
                    int num = Integer.parseInt(numStr) - 1;
                    if (num < 1 || !HRObjectUtils.isEmpty((Object)pageIdSet) && pageIdSet.size() <= 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u95ed\u201c\u542f\u7528\u201d\u5f00\u5173\uff0c\u5373\u53ef\u53d6\u6d88\u8bc4\u5206\u5206\u5236\u4e0e\u7ee9\u6548\u7b49\u7ea7\u7684\u6620\u5c04\u914d\u7f6e\u3002", (String)"LevelScoreMapPlugin_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    iFormView.getPageCache().put("scopeLevelNumber", String.valueOf(num));
                    pageIdSet.remove(this.getView().getPageId());
                    iFormView.getPageCache().put("scoremapentitypage", SerializationUtils.toJsonString((Object)pageIdSet));
                    this.getView().close();
                    break;
                }
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String fieldKey = ((Control)afterF7SelectEvent.getSource()).getKey();
        if (HRStringUtils.equals((String)"scoresystem", (String)fieldKey)) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            this.levelScoreMapReload((String)showParameter.getCustomParam("parentId"));
            this.isScoreUpperLimit();
            this.isScoreLowerLimit();
        }
    }

    private void setMinScore() {
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = model.getDataEntity().getDynamicObject("scoresystem");
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        model.beginInit();
        DynamicObjectCollection entryEntities = model.getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        int size = entryEntities.size();
        model.setValue("minscore", (Object)dynamicObject.getBigDecimal("minscore"), size - 1);
        this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"minscore"});
        model.setValue("scoreminoperation", (Object)OperationTypeEnum.LESS_THAN.getEq(), size - 1);
        this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"scoreminoperation"});
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().getPageCache().remove(SCORE_SYSTEM_CONFIROM_KEY);
    }

    private void setMaxScore() {
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = model.getDataEntity().getDynamicObject("scoresystem");
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        model.beginInit();
        model.setValue("maxscore", (Object)dynamicObject.getBigDecimal("maxscore"), 0);
        model.setValue("scoremaxoperation", (Object)OperationTypeEnum.LESS_THAN.getEq(), 0);
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().getPageCache().remove(SCORE_SYSTEM_CONFIROM_KEY);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String fieldKey;
        switch (fieldKey = propertyChangedArgs.getProperty().getName()) {
            case "levelscoremap": {
                this.changeRelationShip();
                break;
            }
            case "isscoreupperlimit": 
            case "isscorelowerlimit": {
                this.isScoreUpperLimit();
                this.isScoreLowerLimit();
                break;
            }
            case "minscore": {
                this.minScoreChange(propertyChangedArgs);
                break;
            }
            case "defaultscore": {
                this.defaultScoreChange(propertyChangedArgs);
                break;
            }
            case "scoreminoperation": {
                this.updateMaxOperation(propertyChangedArgs);
                break;
            }
            case "scoresystem": {
                this.setScoreSystemChange(propertyChangedArgs);
                break;
            }
        }
        this.setChangeType();
    }

    private void setScoreSystemChange(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        if (!HRObjectUtils.isEmpty((Object)changeData.getOldValue())) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            this.levelScoreMapReload((String)showParameter.getCustomParam("parentId"));
        }
        this.isScoreUpperLimit();
        this.isScoreLowerLimit();
    }

    private void setChangeType() {
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("parentId");
        IFormView iFormView = this.getView().getView(pageId);
        String hisAction = (String)iFormView.getFormShowParameter().getCustomParam("his_action");
        if (HRStringUtils.equals((String)"open_insert_data_page", (String)hisAction)) {
            String[] values;
            HashSet<String> changeType = new HashSet<String>(16);
            String oldType = iFormView.getModel().getDataEntity().getString("changetype");
            for (String value : values = oldType.split(",")) {
                if (!HRStringUtils.isNotEmpty((String)value)) continue;
                changeType.add(value);
            }
            changeType.add(PerfLevelChangeTypeEnum.LEVEL_SCORE_CHANGE.getChangeType());
            if (!HRObjectUtils.isEmpty(changeType) && changeType.size() > 0) {
                TreeSet set = new TreeSet(changeType);
                iFormView.getModel().setValue("changetype", (Object)("," + Joiner.on((String)",").join(set) + ","));
            }
            iFormView.updateView("changetype");
            this.getView().sendFormAction(iFormView);
        }
    }

    private void updateMaxOperation(PropertyChangedArgs args) {
        ChangeData changeData = args.getChangeSet()[0];
        String inputOperation = (String)changeData.getNewValue();
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        int size = entryEntities.size();
        if (size != changeData.getRowIndex() + 1) {
            if (HRStringUtils.equals((String)inputOperation, (String)OperationTypeEnum.LESS_OR_EQUAL.getEq())) {
                this.setEntryEntity(changeData.getRowIndex() + 1, "scoremaxoperation", OperationTypeEnum.LESS_THAN.getEq());
            }
            if (HRStringUtils.equals((String)inputOperation, (String)OperationTypeEnum.LESS_THAN.getEq())) {
                this.setEntryEntity(changeData.getRowIndex() + 1, "scoremaxoperation", OperationTypeEnum.LESS_OR_EQUAL.getEq());
            }
        }
        this.isScoreLowerLimit();
        this.isScoreUpperLimit();
    }

    private void defaultScoreChange(PropertyChangedArgs args) {
        String levelScoreMap = (String)this.getModel().getValue("levelscoremap");
        if (levelScoreMap != null && levelScoreMap.equals(LevelScoreMapEnum.SECTION.getRelation())) {
            return;
        }
        ChangeData changeData = args.getChangeSet()[0];
        BigDecimal inputScore = (BigDecimal)changeData.getNewValue();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject dynamicObject = dataEntity.getDynamicObject("scoresystem");
        if (HRObjectUtils.isEmpty((Object)inputScore)) {
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)dynamicObject) && inputScore.compareTo(dynamicObject.getBigDecimal("maxscore")) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u5206\u201d\u53ca\u201c\u6700\u4f4e\u5206\u201d\u503c\u8303\u56f4\u5e94\u9ad8\u4e8e\u5206\u5236\u201c\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"LevelScoreMapPlugin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("defaultscore", null, changeData.getRowIndex());
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)dynamicObject) && inputScore.compareTo(dynamicObject.getBigDecimal("minscore")) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u5206\u201d\u53ca\u201c\u6700\u4f4e\u5206\u201d\u503c\u8303\u56f4\u5e94\u9ad8\u4e8e\u5206\u5236\u201c\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"LevelScoreMapPlugin_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("defaultscore", null, changeData.getRowIndex());
            return;
        }
        if (changeData.getRowIndex() > 0) {
            for (int index = changeData.getRowIndex() - 1; index >= 0; --index) {
                BigDecimal defaultScore = (BigDecimal)this.getModel().getValue("defaultscore", index);
                if (HRObjectUtils.isEmpty((Object)inputScore) || HRObjectUtils.isEmpty((Object)defaultScore) || inputScore.compareTo(defaultScore) < 0) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u5206\u201d\u53ca\u201c\u9ed8\u8ba4\u5206\u201d\u4ece\u9ad8\u5230\u4f4e\u6392\u5e8f\uff0c\u4ee5\u6570\u503c\u8868\u793a\u3002", (String)"LevelScoreMapPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                break;
            }
        }
    }

    private void minScoreChange(PropertyChangedArgs args) {
        String levelScoreMap = (String)this.getModel().getValue("levelscoremap");
        if (levelScoreMap != null && levelScoreMap.equals(LevelScoreMapEnum.SCORE.getRelation())) {
            return;
        }
        ChangeData changeData = args.getChangeSet()[0];
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        int size = entryEntities.size();
        BigDecimal inputScore = (BigDecimal)changeData.getNewValue();
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("scoresystem");
        if (HRObjectUtils.isEmpty((Object)inputScore)) {
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)dynamicObject) && inputScore.compareTo(dynamicObject.getBigDecimal("maxscore")) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u5206\u201d\u53ca\u201c\u6700\u4f4e\u5206\u201d\u503c\u8303\u56f4\u5e94\u9ad8\u4e8e\u5206\u5236\u201c\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"LevelScoreMapPlugin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("minscore", null, changeData.getRowIndex());
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)dynamicObject) && inputScore.compareTo(dynamicObject.getBigDecimal("minscore")) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u5206\u201d\u53ca\u201c\u6700\u4f4e\u5206\u201d\u503c\u8303\u56f4\u5e94\u9ad8\u4e8e\u5206\u5236\u201c\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"LevelScoreMapPlugin_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("minscore", null, changeData.getRowIndex());
            return;
        }
        if (size != changeData.getRowIndex() + 1) {
            this.setEntryEntity(changeData.getRowIndex() + 1, "maxscore", changeData.getNewValue());
        }
        if (changeData.getRowIndex() > 0) {
            for (int index = changeData.getRowIndex() - 1; index >= 0; --index) {
                BigDecimal minScore = (BigDecimal)this.getModel().getValue("minscore", index);
                if (HRObjectUtils.isEmpty((Object)inputScore) || HRObjectUtils.isEmpty((Object)minScore) || inputScore.compareTo(minScore) < 0) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u5206\u201d\u53ca\u201c\u9ed8\u8ba4\u5206\u201d\u4ece\u9ad8\u5230\u4f4e\u6392\u5e8f\uff0c\u4ee5\u6570\u503c\u8868\u793a\u3002", (String)"LevelScoreMapPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
                break;
            }
        }
        this.isScoreUpperLimit();
        this.isScoreLowerLimit();
    }

    private void isScoreUpperLimit() {
        boolean isUpper = this.getModel().getDataEntity().getBoolean("isscoreupperlimit");
        if (isUpper) {
            this.setEntryEntity(0, "maxscore", null);
            this.setEntryEntity(0, "scoremaxoperation", null);
        } else {
            this.setMaxScore();
        }
    }

    private void isScoreLowerLimit() {
        boolean isLower = this.getModel().getDataEntity().getBoolean("isscorelowerlimit");
        if (isLower) {
            DynamicObjectCollection entryEntities = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
            int size = entryEntities.size();
            this.setEntryEntity(size - 1, "minscore", null);
            this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"minscore"});
            this.setEntryEntity(size - 1, "scoreminoperation", null);
            this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"scoreminoperation"});
        } else {
            this.setMinScore();
        }
    }

    private void changeRelationShip() {
        String type = this.getView().getModel().getDataEntity().getString("levelscoremap");
        switch (LevelScoreMapEnum.getLevelScore((String)type)) {
            case BOTH: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"maxscore", "scoremaxoperation", "scorelevel", "scoreminoperation", "minscore", "defaultscore", "textscore"});
                break;
            }
            case SECTION: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"maxscore", "scoremaxoperation", "scorelevel", "scoreminoperation", "minscore", "textscore"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"defaultscore"});
                break;
            }
            case SCORE: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"scorelevel", "minscore", "defaultscore"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"maxscore", "textscore", "scoremaxoperation", "scoreminoperation", "minscore"});
                break;
            }
        }
        this.isScoreLowerLimit();
        this.isScoreUpperLimit();
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("scoresystem");
        edit.addAfterF7SelectListener((AfterF7SelectListener)this);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        IPageCache iPageCache = this.getPageCache();
        if (HRStringUtils.equals((String)actionId, (String)SCORE_SYSTEM_CHANGE)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                DynamicObject dynamicObject = this.getModel().getDataEntity();
                IFormView parentView = this.getView().getParentView();
                BasedataEdit scoreSys = (BasedataEdit)parentView.getControl("scoresystemf7");
                ArrayList<Long> ids = new ArrayList<Long>(this.getFilterIds());
                ids.add(dynamicObject.getLong(SCORESYSTEM_ID));
                scoreSys.setQFilter(new QFilter("id", "not in", ids));
                scoreSys.click();
                parentView.getPageCache().put("scoresystemcurrentpage", this.getView().getPageId());
                this.getView().sendFormAction(parentView);
            }
            iPageCache.remove(SCORE_SYSTEM_CONFIROM_KEY);
        }
    }

    private List<Long> getFilterIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        IFormView iFormView = this.getView().getParentView();
        IPageCache pageCache = iFormView.getPageCache();
        Set pageIdSet = (Set)SerializationUtils.fromJsonString((String)pageCache.get("scoremapentitypage"), Set.class);
        if (pageIdSet.size() > 0) {
            for (String pageId : pageIdSet) {
                IFormView childView = this.getView().getView(pageId);
                if (HRObjectUtils.isEmpty((Object)childView)) continue;
                IDataModel childModel = childView.getModel();
                ids.add(childModel.getDataEntity().getLong(SCORESYSTEM_ID));
            }
        }
        return ids;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = ((Control)beforeF7SelectEvent.getSource()).getKey();
        IPageCache iPageCache = this.getPageCache();
        beforeF7SelectEvent.setCancel(true);
        if (HRStringUtils.isEmpty((String)iPageCache.get(SCORE_SYSTEM_CONFIROM_KEY)) && HRStringUtils.equals((String)"scoresystem", (String)fieldKey) && !HRObjectUtils.isEmpty((Object)this.getModel().getValue("scoresystem"))) {
            iPageCache.put(SCORE_SYSTEM_CONFIROM_KEY, Boolean.TRUE.toString());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5982\u91cd\u65b0\u9009\u62e9\u8bc4\u5206\u5206\u5236\uff0c\u539f\u914d\u7f6e\u4fe1\u606f\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"LevelScoreMapPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(SCORE_SYSTEM_CHANGE, (IFormPlugin)this));
        } else if (HRStringUtils.equals((String)"scoresystem", (String)fieldKey) && HRObjectUtils.isEmpty((Object)this.getModel().getValue("scoresystem"))) {
            iPageCache.put(SCORE_SYSTEM_CONFIROM_KEY, Boolean.TRUE.toString());
            ArrayList<Long> ids = new ArrayList<Long>(this.getFilterIds());
            BasedataEdit scoreSys = (BasedataEdit)this.getView().getParentView().getControl("scoresystemf7");
            scoreSys.setQFilter(new QFilter("id", "not in", ids));
            scoreSys.click();
            this.getView().getParentView().getPageCache().put("scoresystemcurrentpage", this.getView().getPageId());
            this.getView().sendFormAction(this.getView().getParentView());
            iPageCache.remove(SCORE_SYSTEM_CONFIROM_KEY);
        }
    }
}

