/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.perflevel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PerfLevelList
extends AbstractListPlugin {
    private static final String LISTNODENAME = "listnodename";
    private static final String SCORESYSTEMNAME = "scoresystemname";
    private static final String ENTRYENTITY = "entryentity";
    private static final String HBSS_RULERGRADE = "hbss_perflevel";
    private static final String PASSESSNODE = "levelname";
    private static final int LIMIT_LEN = 60;
    private static final String VERSION_CHANGE_COMPARE_BTN = "versionchangecomparebtn";
    private static final String INSERT_DATA_BTN = "insertdatabtn";
    private static final String OP_SHOW_HIS_VERSION = "showhisversion";
    private static final String DATA_VERSION_STATUS = "datastatus";
    private static final String OP_MODIFY = "his_modify";
    private static final String OP_COPY = "his_copy";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(PerfLevelList.HBSS_RULERGRADE);
                List idList = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", idList);
                DynamicObject[] dynamicObjects = hrBaseServiceHelper.query("id,entryentity.levelname,scoremapentryentity.scoresystem", new QFilter[]{qFilter});
                HashMap<Long, String> nodeNameMap = new HashMap<Long, String>(16);
                HashMap<Long, String> scoreSystemMap = new HashMap<Long, String>(16);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObjectCollection scoreMapEntryEntry;
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(PerfLevelList.ENTRYENTITY);
                    if (!HRObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
                        String name = dynamicObjectCollection.stream().map(dyc -> dyc.getString(PerfLevelList.PASSESSNODE)).distinct().collect(Collectors.joining(";"));
                        if (name.length() >= 60) {
                            name = name.substring(0, 60) + "...";
                        }
                        nodeNameMap.put(dynamicObject.getLong("id"), name);
                    }
                    if (HRObjectUtils.isEmpty((Object)(scoreMapEntryEntry = dynamicObject.getDynamicObjectCollection("scoremapentryentity")))) continue;
                    String name = scoreMapEntryEntry.stream().map(dyc -> dyc.getString("scoresystem.name")).distinct().collect(Collectors.joining("/"));
                    if (name.length() >= 60) {
                        name = name.substring(0, 60) + "...";
                    }
                    scoreSystemMap.put(dynamicObject.getLong("id"), name);
                }
                for (DynamicObject row2 : rows) {
                    PerfLevelList.this.addPropertyIfNotFound(row2.getDataEntityType(), PerfLevelList.LISTNODENAME, null);
                    row2.set(PerfLevelList.LISTNODENAME, nodeNameMap.get(row2.getLong("id")));
                    PerfLevelList.this.addPropertyIfNotFound(row2.getDataEntityType(), PerfLevelList.SCORESYSTEMNAME, null);
                    row2.set(PerfLevelList.SCORESYSTEMNAME, scoreSystemMap.get(row2.getLong("id")));
                }
                return rows;
            }
        });
    }

    private void addPropertyIfNotFound(IDataEntityType dataEntityType, String propertyName, Object defaultValue) {
        if (!dataEntityType.getProperties().containsKey((Object)propertyName)) {
            DynamicProperty property = new DynamicProperty();
            property.setName(propertyName);
            if (Objects.nonNull(defaultValue)) {
                property.setDefaultValue(defaultValue);
            }
            dataEntityType.getProperties().add((Object)property);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{VERSION_CHANGE_COMPARE_BTN, INSERT_DATA_BTN});
    }

    public void packageData(PackageDataEvent event) {
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        if (!HRStringUtils.equals((String)option, (String)OP_SHOW_HIS_VERSION)) {
            super.packageData(event);
            return;
        }
        if (event.getSource() instanceof ListOperationColumnDesc && event.getRowData().containsProperty(DATA_VERSION_STATUS)) {
            List operationColItems = (List)event.getFormatValue();
            operationColItems.stream().filter(opItem -> OP_MODIFY.equals(opItem.getOperationKey()) || OP_COPY.equals(opItem.getOperationKey())).forEach(opItem -> opItem.setVisible(false));
            super.packageData(event);
        }
    }
}

