/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.rulergrade;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.common.util.ListUtils;

public class RulerGradeList
extends AbstractListPlugin {
    private static final String LISTNODENAME = "listnodename";
    private static final String ENTRYENTITY = "gradeconfigentry";
    private static final String HBSS_RULERGRADE = "hbss_rulegrade";
    private static final String PASSESSNODE = "rulegrade";
    private static final int LIMIT_LEN = 60;

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"versionchangecomparebtn", "insertdatabtn"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(RulerGradeList.HBSS_RULERGRADE);
                List idList = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", idList);
                DynamicObject[] dynamicObjects = hrBaseServiceHelper.query("id,gradeconfigentry.rulegrade", new QFilter[]{qFilter});
                HashMap<Long, String> nodeNameMap = new HashMap<Long, String>(16);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(RulerGradeList.ENTRYENTITY);
                    if (HRObjectUtils.isEmpty((Object)dynamicObjectCollection)) continue;
                    String name = dynamicObjectCollection.stream().map(dyc -> dyc.getString(RulerGradeList.PASSESSNODE)).distinct().collect(Collectors.joining(";"));
                    if (name.length() >= 60) {
                        name = name.substring(0, 60);
                    }
                    nodeNameMap.put(dynamicObject.getLong("id"), name);
                }
                for (DynamicObject row2 : rows) {
                    RulerGradeList.this.addPropertyIfNotFound(row2.getDataEntityType(), RulerGradeList.LISTNODENAME, null);
                    row2.set(RulerGradeList.LISTNODENAME, nodeNameMap.get(row2.getLong("id")));
                }
                return rows;
            }
        });
    }

    private void addPropertyIfNotFound(IDataEntityType dataEntityType, String propertyName, Object defaultValue) {
        if (!dataEntityType.getProperties().containsKey((Object)propertyName)) {
            DynamicProperty property = new DynamicProperty();
            property.setName(propertyName);
            if (Objects.nonNull(defaultValue)) {
                property.setDefaultValue(defaultValue);
            }
            dataEntityType.getProperties().add((Object)property);
        }
    }

    public void packageData(PackageDataEvent event) {
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        if (!HRStringUtils.equals((String)option, (String)"showhisversion")) {
            super.packageData(event);
            return;
        }
        if (event.getSource() instanceof ListOperationColumnDesc && event.getRowData().containsProperty("datastatus")) {
            List operationColItems = ListUtils.castList((Object)event.getFormatValue(), OperationColItem.class);
            operationColItems.stream().filter(opItem -> "revise".equals(opItem.getOperationKey()) || "his_copy".equals(opItem.getOperationKey())).forEach(opItem -> opItem.setVisible(false));
            super.packageData(event);
        }
    }
}

