/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.scoresystem;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbss.bussiness.application.service.ScoreSystemApplicationService;
import kd.hr.hbss.bussiness.application.service.TipsApplicationService;
import kd.hr.hbss.bussiness.domain.scoresystem.enums.ChangeTypeEnum;
import kd.hr.hbss.formplugin.web.util.HistoryVersionShowUtil;

public class ScoreSystemEdit
extends HRDataBaseEdit
implements HyperLinkClickListener {
    private static final String TAG_ENTRY_ENTITY = "tagentryentity";
    private static final String HIS_ENTRY_ENTITY = "hisentryentity";
    private static final String IS_VERSION_VIEW = "isVersionView";
    private static final String RECORD_AP = "recordap";
    private static final String BAR_DISABLE = "bar_disable";
    private static final String BAR_REVISE = "bar_revise";
    private static final String CONFIRM_CHANGE_NO_AUDIT = "confirmchangenoaudit";
    private static final String RECORD_HIS = "recordhis";
    private static final String RECH_IS_VERSION = "rechisversion";
    private static final String ADVCONAP = "advconap";
    private static final Integer MAX_ENTRY_VALUE = 19;
    TipsApplicationService TIPS_APPLICATION_SERVICE = TipsApplicationService.getInstance();
    private static final Set<String> CHANGE_DATE_OPERATION = new HashSet<String>(){
        private static final long serialVersionUID = -5980211647045281452L;
        {
            this.add("save");
            this.add("confirmchange");
            this.add("saveandnew");
            this.add("submit");
            this.add(ScoreSystemEdit.CONFIRM_CHANGE_NO_AUDIT);
        }
    };

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String propertyName = changedArgs.getProperty().getName();
        if (HRStringUtils.equals((String)"isdefault", (String)propertyName)) {
            ChangeData changeData = changedArgs.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            DynamicObjectCollection dynamicObjects = this.getView().getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(TAG_ENTRY_ENTITY);
            this.setDefault(changeData, rowIndex, dynamicObjects);
        }
        if (HRStringUtils.equals((String)"tag", (String)propertyName) && !this.duplicateTagCheck(changedArgs)) {
            return;
        }
        if (HRStringUtils.equals((String)"score", (String)propertyName) && !this.duplicateScoreCheck(changedArgs)) {
            return;
        }
        if (HRStringUtils.equals((String)"maxscore", (String)propertyName) || HRStringUtils.equals((String)"minscore", (String)propertyName)) {
            this.compareScore(changedArgs);
        }
        this.setChangeType(propertyName);
    }

    private boolean duplicateScoreCheck(PropertyChangedArgs changedArgs) {
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(TAG_ENTRY_ENTITY);
        ChangeData changeData = changedArgs.getChangeSet()[0];
        for (int index = 0; index < entryEntities.size(); ++index) {
            if (index == changeData.getRowIndex() || HRObjectUtils.isEmpty((Object)changeData.getDataEntity().getBigDecimal("score")) || HRObjectUtils.isEmpty((Object)((DynamicObject)entryEntities.get(index)).getBigDecimal("score")) || changeData.getDataEntity().getBigDecimal("score").compareTo(((DynamicObject)entryEntities.get(index)).getBigDecimal("score")) != 0) continue;
            IFormView iFormView = this.getView();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.setValue("score", null, changeData.getRowIndex());
            changeData.getDataEntity().set("score", null);
            model.endInit();
            iFormView.updateView(TAG_ENTRY_ENTITY);
            iFormView.showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5fc5\u987b\u552f\u4e00\uff0c\u4e0d\u53ef\u91cd\u590d\u3002", (String)"ScoreSystemEdit_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean duplicateTagCheck(PropertyChangedArgs changedArgs) {
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(TAG_ENTRY_ENTITY);
        ChangeData changeData = changedArgs.getChangeSet()[0];
        for (int index = 0; index < entryEntities.size(); ++index) {
            if (index == changeData.getRowIndex() || HRObjectUtils.isEmpty((Object)changeData.getDataEntity().getString("tag")) || !HRStringUtils.equals((String)changeData.getDataEntity().getString("tag"), (String)((DynamicObject)entryEntities.get(index)).getString("tag"))) continue;
            IFormView iFormView = this.getView();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.setValue("tag", null, changeData.getRowIndex());
            changeData.getDataEntity().set("tag", null);
            model.endInit();
            iFormView.updateView(TAG_ENTRY_ENTITY);
            iFormView.showErrorNotification(ResManager.loadKDString((String)"\u6807\u7b7e\u9700\u8981\u552f\u4e00\uff0c\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ScoreSystemEdit_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setDefault(ChangeData changeData, int rowIndex, DynamicObjectCollection dynamicObjects) {
        if (dynamicObjects.size() > 1 && ((Boolean)changeData.getNewValue()).booleanValue()) {
            for (int index = 0; index < dynamicObjects.size(); ++index) {
                if (rowIndex == index) continue;
                this.getModel().setValue("isdefault", (Object)Boolean.FALSE, index);
            }
        }
    }

    private void compareScore(PropertyChangedArgs changedArgs) {
        String propertyName = changedArgs.getProperty().getName();
        ChangeData changeData = changedArgs.getChangeSet()[0];
        if (HRObjectUtils.isEmpty((Object)changeData.getNewValue())) {
            return;
        }
        if (this.checkChangeScore()) {
            this.getModel().setValue(propertyName, null);
        }
    }

    private boolean checkChangeScore() {
        BigDecimal maxScore = this.getModel().getDataEntity().getBigDecimal("maxscore");
        BigDecimal minScore = this.getModel().getDataEntity().getBigDecimal("minscore");
        if (!ObjectUtils.isEmpty((Object)maxScore) && !ObjectUtils.isEmpty((Object)minScore) && minScore.compareTo(maxScore) >= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u57fa\u51c6\u6700\u9ad8\u5206\u201d\u5e94\u5927\u4e8e\u201c\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"ScoreSystemEdit_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkScore() {
        BigDecimal maxScore = this.getModel().getDataEntity().getBigDecimal("maxscore");
        BigDecimal minScore = this.getModel().getDataEntity().getBigDecimal("minscore");
        if (maxScore == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u57fa\u51c6\u6700\u9ad8\u5206\u201d\u3002", (String)"ScoreSystemEdit_6", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (minScore == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"ScoreSystemEdit_7", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (minScore.compareTo(maxScore) >= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u57fa\u51c6\u6700\u9ad8\u5206\u201d\u5e94\u5927\u4e8e\u201c\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"ScoreSystemEdit_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setChangeType(String propertyName) {
        String pageStatus = this.getView().getPageCache().get("pageStatus");
        if (HRStringUtils.isNotEmpty((String)pageStatus) && HRStringUtils.equalsIgnoreCase((String)OperationStatus.EDIT.toString(), (String)pageStatus)) {
            String[] values;
            HashSet<String> changeType = new HashSet<String>(16);
            String oldType = this.getModel().getDataEntity().getString("changetype");
            for (String value : values = oldType.split(",")) {
                if (!HRStringUtils.isNotEmpty((String)value)) continue;
                changeType.add(value);
            }
            this.getChangeType(propertyName, changeType);
            if (!HRObjectUtils.isEmpty(changeType) && changeType.size() > 0) {
                TreeSet<String> set = new TreeSet<String>(changeType);
                this.getModel().setValue("changetype", (Object)("," + Joiner.on((String)",").join(set) + ","));
            }
        }
    }

    private void getChangeType(String propertyName, Set<String> changeType) {
        switch (propertyName) {
            case "name": {
                changeType.add(ChangeTypeEnum.NAME_CHANGE.getChangeType());
                break;
            }
            case "maxscore": 
            case "minscore": {
                changeType.add(ChangeTypeEnum.BASE_SCORE_CHANGE.getChangeType());
                break;
            }
            case "isdefault": 
            case "tag": 
            case "score": 
            case "comment": {
                changeType.add(ChangeTypeEnum.SCORE_TAG_CHANGE.getChangeType());
                break;
            }
            case "description": {
                changeType.add(ChangeTypeEnum.DESCRIPTION_CHANGE.getChangeType());
                break;
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        List tips;
        super.afterBindData(eventObject);
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        if (!HRStringUtils.equals((String)option, (String)"showhisversion")) {
            this.getModel().setValue("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IFormView iFormView = this.getView();
        String pageStatus = this.getView().getPageCache().get("pageStatus");
        if (HRStringUtils.equalsIgnoreCase((String)OperationStatus.VIEW.toString(), (String)pageStatus)) {
            DynamicObject[] dynamicObjects = ScoreSystemApplicationService.getInstance().getHisScoreSystem(Long.valueOf(this.getModel().getDataEntity().getLong("boid")));
            HistoryVersionShowUtil.initInsEntry(dynamicObjects, (AbstractFormDataModel)this.getModel(), this.getView());
        }
        if (HRStringUtils.equalsIgnoreCase((String)OperationStatus.EDIT.toString(), (String)pageStatus)) {
            TextEdit textEdit = (TextEdit)this.getControl("changedescription");
            textEdit.setMustInput(Boolean.TRUE.booleanValue());
            this.getView().updateView("changedescription");
            iFormView.getModel().setValue("changetype", (Object)",,");
        }
        if (!HRObjectUtils.isEmpty((Object)formShowParameter.getCustomParam(IS_VERSION_VIEW))) {
            iFormView.setVisible(Boolean.FALSE, new String[]{RECORD_AP, BAR_DISABLE, BAR_REVISE});
            iFormView.setVisible(Boolean.TRUE, new String[]{"hisversion"});
        }
        if (!ObjectUtils.isEmpty((Object)(tips = this.TIPS_APPLICATION_SERVICE.getTips("hbss_scoresystem", ADVCONAP))) && tips.size() > 0) {
            HashMap<String, Tips> textProps = new HashMap<String, Tips>(16);
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString((String)tips.get(0)));
            textProps.put("tips", textTips);
            this.getView().updateControlMetadata(ADVCONAP, textProps);
        }
        iFormView.setVisible(Boolean.FALSE, new String[]{BAR_REVISE});
        iFormView.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (HRStringUtils.equals((String)RECH_IS_VERSION, (String)hyperLinkClickEvent.getFieldName())) {
            this.showVrInfViewData();
        }
    }

    private void showVrInfViewData() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hbss_scoresystem");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObjectCollection entryEntities = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(HIS_ENTRY_ENTITY);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(HIS_ENTRY_ENTITY);
        DynamicObject currEntryEntity = (DynamicObject)entryEntities.get(entryCurrentRowIndex);
        showParameter.setPkId((Object)currEntryEntity.getDynamicObject(RECORD_HIS).getLong("id"));
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam(IS_VERSION_VIEW, (Object)Boolean.TRUE);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bc4\u5206\u5206\u5236\u7248\u672c\u67e5\u770b", (String)"ScoreSystemEdit_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(HIS_ENTRY_ENTITY);
        if (!ObjectUtils.isEmpty((Object)entryGrid)) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (CHANGE_DATE_OPERATION.contains(evt.getOperationKey()) && this.checkScore()) {
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryentity;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)"newentry", (String)operKey) && (entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(TAG_ENTRY_ENTITY)).size() > MAX_ENTRY_VALUE) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u6807\u7b7e\u4e0d\u80fd\u8d85\u8fc720\u4e2a", (String)"ScoreSystemEdit_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)"save", (String)operKey) && this.checkEntryEntry()) {
            args.setCancel(true);
        }
    }

    private boolean checkEntryEntry() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(TAG_ENTRY_ENTITY);
        if (!ObjectUtils.isEmpty((Object)dynamicObjectCollection) && dynamicObjectCollection.size() > 0) {
            for (DynamicObject dyc : dynamicObjectCollection) {
                if (!HRStringUtils.isEmpty((String)dyc.getString("tag"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6807\u7b7e\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ScoreSystemEdit_8", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        if (!HRObjectUtils.isEmpty((Object)afterDoOperationEventArgs.getOperationResult()) && afterDoOperationEventArgs.getOperationResult().isSuccess() && (HRStringUtils.equals((String)operate.getOperateKey(), (String)CONFIRM_CHANGE_NO_AUDIT) || HRStringUtils.equals((String)operate.getOperateKey(), (String)"save"))) {
            this.getModel().deleteEntryData(HIS_ENTRY_ENTITY);
            DynamicObject[] dynamicObjects = ScoreSystemApplicationService.getInstance().getHisScoreSystem(Long.valueOf(this.getModel().getDataEntity().getLong("boid")));
            HistoryVersionShowUtil.initInsEntry(dynamicObjects, (AbstractFormDataModel)this.getModel(), this.getView());
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        }
    }
}

