/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.taxunit;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class TaxUnitBatchImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxUnitBatchImportPlugin.class);
    private static final int BATCH_IMPORT_SIZE = 500;
    private static final String IMPORT_TYPE_NEW = "new";
    private static final String IMPORT_TYPE_OVERRIDE = "override";
    private static final String IMPORT_TYPE_OVERRIDE_NEW = "overridenew";
    private static final String KEY_FIELDS = "KeyFields";
    private static final String IMPORT_TYPE = "importtype";
    private long totalSpendTime = 0L;
    private long totalImportCount = 0L;
    private final String statusMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u72b6\u6001\u548c\u5ba1\u6838\u72b6\u6001\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"TaxUnitBatchImportPlugin_1", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    private String errMsg = ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff0c\u7cfb\u7edf\u627e\u4e0d\u5230\u201c%s\u201d\u7684\u6570\u636e\u884c\u3002", (String)"TaxUnitBatchImportPlugin_2", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    private final String noDataMsg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"TaxUnitBatchImportPlugin_3", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    private final String moreDataMsg = ResManager.loadKDString((String)"\u5b58\u5728\u591a\u6761\u6ee1\u8db3\u8986\u76d6\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"TaxUnitBatchImportPlugin_4", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    private final String adminDivNullMsg = ResManager.loadKDString((String)"\u7eb3\u7a0e\u5730\u4e0d\u5b58\u5728\u3002", (String)"TaxUnitBatchImportPlugin_5", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);
    private final String notChinaMsg = ResManager.loadKDString((String)"\u53ea\u80fd\u586b\u5199\u4e2d\u56fd\u7684\u7eb3\u7a0e\u5730\u3002", (String)"TaxUnitBatchImportPlugin_6", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]);

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 500;
    }

    public String getDefaultKeyFields() {
        return super.getDefaultKeyFields();
    }

    protected void beforeSave(List<ImportBillData> billDataList, ImportLogger logger) {
        super.beforeSave(billDataList, logger);
        try {
            String importType = (String)this.ctx.getOption().get(IMPORT_TYPE);
            String keyFields = (String)this.ctx.getOption().get(KEY_FIELDS);
            List<Object> addList = new ArrayList(16);
            List<Object> updateList = new ArrayList(16);
            Map<String, List<ImportBillData>> splitData = this.splitData(billDataList, keyFields, importType);
            if (!splitData.isEmpty()) {
                if (!CollectionUtils.isEmpty((Collection)splitData.get("addList"))) {
                    addList = splitData.get("addList");
                }
                if (!CollectionUtils.isEmpty((Collection)splitData.get("updateList"))) {
                    updateList = splitData.get("updateList");
                }
            }
            Iterator<ImportBillData> it = billDataList.iterator();
            while (it.hasNext()) {
                ImportBillData bill = it.next();
                if (!bill.isEmpty() && (CollectionUtils.isEmpty(addList) || !addList.contains(bill) || !this.validateImportNew(it, logger, bill)) && !CollectionUtils.isEmpty(updateList) && updateList.contains(bill) && !this.validateImportOverride(it, logger, keyFields, bill)) continue;
            }
        }
        catch (Exception throwable) {
            LOGGER.error((Throwable)throwable);
            if (SystemParamServiceHelper.isShowStackTrace()) {
                logger.log(Integer.valueOf(billDataList.get(0).getStartIndex()), (Throwable)throwable);
            } else {
                logger.log(Integer.valueOf(billDataList.get(0).getStartIndex()), ResManager.loadKDString((String)"\u6570\u636e\u5305\u6821\u9a8c\u51fa\u73b0\u5f02\u5e38,\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"TaxUnitBatchImportPlugin_0", (String)"hrmp-hbss-formplugin", (Object[])new Object[0]));
            }
            billDataList.clear();
        }
    }

    private Map<String, List<ImportBillData>> splitData(List<ImportBillData> billdatas, String keyFields, String importType) {
        HashMap<String, List<ImportBillData>> map = new HashMap<String, List<ImportBillData>>(16);
        ArrayList<ImportBillData> addList = new ArrayList<ImportBillData>(16);
        ArrayList<ImportBillData> updateList = new ArrayList<ImportBillData>(16);
        if (HRStringUtils.equals((String)IMPORT_TYPE_OVERRIDE_NEW, (String)importType)) {
            for (ImportBillData bill : billdatas) {
                if (bill.isEmpty()) continue;
                String message = this.checkExistKeyFields(keyFields, bill);
                String dataMessage = this.checkExistData(keyFields, bill);
                if (null == message && null == dataMessage) {
                    updateList.add(bill);
                    continue;
                }
                addList.add(bill);
            }
        } else if (HRStringUtils.equals((String)IMPORT_TYPE_NEW, (String)importType)) {
            addList.addAll(billdatas);
        } else if (HRStringUtils.equals((String)IMPORT_TYPE_OVERRIDE, (String)importType)) {
            updateList.addAll(billdatas);
        }
        if (!addList.isEmpty()) {
            map.put("addList", addList);
        }
        if (!updateList.isEmpty()) {
            map.put("updateList", updateList);
        }
        return map;
    }

    private boolean validateImportNew(Iterator<ImportBillData> it, ImportLogger logger, ImportBillData bill) {
        return this.checkCountry(it, logger, bill);
    }

    public boolean validateImportOverride(Iterator<ImportBillData> it, ImportLogger logger, String keyFields, ImportBillData bill) {
        String message = this.checkExistKeyFields(keyFields, bill);
        if (null != message) {
            it.remove();
            this.errMsg = String.format(Locale.ROOT, this.errMsg, message);
            this.log(bill.getStartIndex(), this.errMsg, logger);
            return false;
        }
        String dataMessage = this.checkExistData(keyFields, bill);
        if (null != dataMessage) {
            it.remove();
            this.log(bill.getStartIndex(), dataMessage, logger);
            return false;
        }
        String status = this.checkStatus(keyFields.split(","), bill);
        if (HRStringUtils.equals((String)"C", (String)status) || HRStringUtils.equals((String)"B", (String)status)) {
            it.remove();
            this.log(bill.getStartIndex(), this.statusMsg, logger);
            return false;
        }
        return this.checkCountry(it, logger, bill);
    }

    private boolean checkCountry(Iterator<ImportBillData> it, ImportLogger logger, ImportBillData bill) {
        JSONObject adminDivision = bill.getData().getJSONObject("admindivision");
        String adminDivNumber = adminDivision.getString("number");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bd_admindivision");
        QFilter filter = new QFilter("number", "=", (Object)adminDivNumber);
        DynamicObject dynamicObject = helper.queryOne("country.id, number", new QFilter[]{filter});
        if (dynamicObject == null) {
            it.remove();
            this.log(bill.getStartIndex(), this.adminDivNullMsg, logger);
            return false;
        }
        if (dynamicObject.getLong("country.id") != 1000001L) {
            it.remove();
            this.log(bill.getStartIndex(), this.notChinaMsg, logger);
            return false;
        }
        return true;
    }

    public String checkStatus(String[] split, ImportBillData bill) {
        DynamicObject[] dynamicObjects = this.getTaxUnitData(split, bill);
        String status = null;
        if (dynamicObjects != null && dynamicObjects.length == 1) {
            status = dynamicObjects[0].getString("status");
        }
        return status;
    }

    private String checkExistKeyFields(String keyFields, ImportBillData bill) {
        String[] split = keyFields.split(",");
        if (split.length > 1) {
            for (int i = 1; i < split.length; ++i) {
                if (bill.getData().containsKey((Object)split[i])) continue;
                return split[i];
            }
        }
        return null;
    }

    private String checkExistData(String keyFields, ImportBillData bill) {
        DynamicObject[] dynamicObjects;
        String[] split = keyFields.split(",");
        if (split.length > 1 && null != (dynamicObjects = this.getTaxUnitData(split, bill))) {
            if (dynamicObjects.length > 1) {
                return this.moreDataMsg;
            }
            if (dynamicObjects.length == 0) {
                return this.noDataMsg;
            }
        }
        return null;
    }

    private String checkDataType(String field, ImportBillData bill) {
        Object obj = bill.getData().get((Object)field);
        StringBuffer sb = new StringBuffer();
        sb.append(field);
        if (obj instanceof JSONObject) {
            field = String.valueOf(sb.append(".number"));
        }
        return field;
    }

    private String getDataValue(String field, ImportBillData bill) {
        JSONObject data = bill.getData();
        Object obj = data.get((Object)field);
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            field = data.getJSONObject(field).getString("number");
        } else if (obj instanceof Map) {
            if (null != ((Map)obj).get("zh_CN")) {
                field = (String)((Map)obj).get("zh_CN");
            } else if (null != ((Map)obj).get("zh_TW")) {
                field = (String)((Map)obj).get("zh_TW");
            } else if (null != ((Map)obj).get("en_US")) {
                field = (String)((Map)obj).get("en_US");
            }
        } else if (obj instanceof String) {
            field = data.getString(field);
        }
        return field;
    }

    private DynamicObject[] getTaxUnitData(String[] split, ImportBillData bill) {
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        if (!ArrayUtils.isEmpty((Object[])split) && split.length > 1) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(split.length);
            for (int i = 1; i < split.length; ++i) {
                String filed = split[i];
                String dataValue = this.getDataValue(filed, bill);
                if (dataValue == null) {
                    return dynamicObjects;
                }
                filters.add(new QFilter(this.checkDataType(filed, bill), "=", (Object)dataValue));
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_taxunit");
            dynamicObjects = serviceHelper.query("status,number,admindivision", filters.toArray(new QFilter[filters.size()]));
        }
        return dynamicObjects;
    }

    public void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg).fail();
        }
    }
}

