/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.tools;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil;
import kd.hr.hbss.formplugin.web.tools.WordReplaceInfo;

@ExcludeFromJacocoGeneratedReport
public class HRTermWordReplaceExportPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(HRTermWordReplaceExportPlugin.class);
    private static final String BIZ_CLOUD = "bizcloud";
    private static final long LANG_TYPE = 328738425610159104L;
    private static final String BOS_FORM_META = "bos_formmeta";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit bizApp = (BasedataEdit)this.getView().getControl("bizapp");
        bizApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject bizCloudDynObj;
        String cloudId;
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if ("bizapp".equals(propertyName) && !HRStringUtils.isEmpty((String)(cloudId = (bizCloudDynObj = (DynamicObject)this.getModel().getValue(BIZ_CLOUD)).getString("id")))) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter cloudFilter = new QFilter("bizcloud.id", "=", (Object)cloudId);
            QFilter isvFilter = new QFilter("isv", "=", (Object)"kingdee");
            QFilter kingdeeAppFilter = new QFilter("inheritpath", "=", (Object)" ");
            cloudFilter.and(isvFilter).and(kingdeeAppFilter);
            showParameter.getListFilterParameter().setFilter(cloudFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            DynamicObject bizCloudDynObj = (DynamicObject)this.getModel().getValue(BIZ_CLOUD);
            String cloudId = bizCloudDynObj.getString("id");
            MulBasedataDynamicObjectCollection bizAppDynObjColl = (MulBasedataDynamicObjectCollection)this.getModel().getValue("bizapp");
            List<String> appIdList = bizAppDynObjColl.stream().map(dynamicObject -> dynamicObject.getString("fbasedataid_id")).collect(Collectors.toList());
            String originalReplaceObjectIds = (String)this.getModel().getValue("replaceobjectids");
            String[] replaceObjectIds = originalReplaceObjectIds.split("\\n");
            List<String> subjectIdList = Arrays.stream(replaceObjectIds).filter(subjectId -> !HRStringUtils.isEmpty((String)subjectId)).collect(Collectors.toList());
            String srcWord = (String)this.getModel().getValue("srcword");
            String targetWord = (String)this.getModel().getValue("targetword");
            WordReplaceInfo wordReplaceInfo = new WordReplaceInfo(srcWord, targetWord);
            this.outputReplaceSQL(cloudId, appIdList, subjectIdList, wordReplaceInfo);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        EntityOperate entityOperate = (EntityOperate)args.getSource();
        if ("replacepreword".equals(entityOperate.getOperateKey())) {
            HRTermWordReplaceMergeUtil mergeHelper = new HRTermWordReplaceMergeUtil();
            mergeHelper.mergeTermWordData();
        }
    }

    private void outputReplaceSQL(String cloudId, List<String> appIdList, List<String> subjectIdList, WordReplaceInfo wordReplaceInfo) {
        ArrayList<Map<String, StringWriter>> xmlFileList = new ArrayList<Map<String, StringWriter>>(16);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("/****** pre termWordComp data sql ******/").append(System.lineSeparator());
        List<Map<String, Object>> listSqlMap = this.generateReplacePreDataSQL(appIdList, subjectIdList, wordReplaceInfo);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(System.lineSeparator());
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        String sqlFileName = String.format("%s_%s.sql", "hrInt_ReplaceWordPreTermWordCompDataSql_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        this.outPutSqlToFile(xmlFileList, sqlBuilder, sqlFileName);
        sqlBuilder = this.generateReplaceMetaTermDataPreSQL(appIdList, subjectIdList, wordReplaceInfo);
        sqlFileName = String.format("%s_%s.sql", "hrInt_ReplaceWordTermPreMetaDataSql_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        this.outPutSqlToFile(xmlFileList, sqlBuilder, sqlFileName);
        sqlBuilder = new StringBuilder();
        sqlBuilder.append("/****** pre word term prompt sql ******/").append(System.lineSeparator());
        listSqlMap = this.generateReplacePromptDataPreSQL(appIdList, subjectIdList, wordReplaceInfo);
        for (Map<String, Object> map : listSqlMap) {
            sqlBuilder.append(map.get("sql")).append(System.lineSeparator());
            if (map.get("xml") == null) continue;
            xmlFileList.add((Map)map.get("xml"));
        }
        sqlFileName = String.format("%s_%s.sql", "hrInt_ReplaceWordTermPrePromptDataSql_", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        this.outPutSqlToFile(xmlFileList, sqlBuilder, sqlFileName);
    }

    private List<Map<String, Object>> generateReplacePromptDataPreSQL(List<String> appIdList, List<String> subjectIdList, WordReplaceInfo wordReplaceInfo) {
        DynamicObject[] wordCompDynObjs;
        String whereCondition;
        String srcWord = wordReplaceInfo.getSrcWord();
        String targetWord = wordReplaceInfo.getTargetWord();
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        List<Long> wordIdList = this.getWordIdList(appIdList, srcWord, targetWord);
        if (wordIdList.size() == 0) {
            return listMap;
        }
        String exportFields = this.getTableFields(DBRoute.of((String)"basedata"), "T_CTS_TERMWORDCOMP");
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        QFilter qFilter = new QFilter("fwordid", "IN", wordIdList);
        QFilter promptQFilter = new QFilter("fcategory", "=", (Object)"PROMPT");
        QFilter wordStatusFilter = new QFilter("fwordstatus", "=", (Object)"3");
        if (subjectIdList.size() > 0) {
            QFilter subjectIdFilter = new QFilter("fsubjectid", "in", subjectIdList);
            whereCondition = qFilter.and(wordStatusFilter).and(promptQFilter).and(subjectIdFilter).toString();
        } else {
            whereCondition = qFilter.and(wordStatusFilter).and(promptQFilter).toString();
        }
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"basedata"), "T_CTS_TERMWORDCOMP", exportFields, whereCondition, null, null);
        listMap.add(map);
        HRBaseServiceHelper termWordCompServiceHelper = new HRBaseServiceHelper("cts_termwordcomp");
        qFilter = new QFilter("wordid", "in", wordIdList);
        promptQFilter = new QFilter("category", "=", (Object)"PROMPT");
        wordStatusFilter = new QFilter("wordstatus", "=", (Object)"3");
        if (subjectIdList.size() > 0) {
            QFilter subjectIdFilter = new QFilter("subjectid", "in", subjectIdList);
            wordCompDynObjs = termWordCompServiceHelper.queryOriginalArray("subjectid,key", new QFilter[]{qFilter, promptQFilter, wordStatusFilter, subjectIdFilter}, null);
        } else {
            wordCompDynObjs = termWordCompServiceHelper.queryOriginalArray("subjectid,key", new QFilter[]{qFilter, promptQFilter, wordStatusFilter}, null);
        }
        StringBuilder condStrBuilder = new StringBuilder();
        for (int i = 0; i < wordCompDynObjs.length; ++i) {
            DynamicObject dynObj = wordCompDynObjs[i];
            if (i == 0) {
                condStrBuilder.append("(fprojectnumber='").append(dynObj.getString("subjectid")).append("' and fresid='").append(dynObj.getString("key")).append("')");
                continue;
            }
            condStrBuilder.append("or (fprojectnumber='").append(dynObj.getString("subjectid")).append("' and fresid='").append(dynObj.getString("key")).append("')");
        }
        if (wordCompDynObjs.length > 0) {
            exportFields = "FPKID ,FPROJECTNUMBER ,FRESID ,FLOCALEID ,FTRANSLATION";
            builder = new PreInsDataScriptBuilder();
            whereCondition = condStrBuilder.toString();
            map = builder.genInsertSQLScript(DBRoute.of((String)"basedata"), "T_INT_PROMPTWORDTRAN_TERM", exportFields, whereCondition, null, null);
            listMap.add(map);
        }
        return listMap;
    }

    private List<Map<String, Object>> generateReplacePreDataSQL(List<String> appIdList, List<String> subjectIdList, WordReplaceInfo wordReplaceInfo) {
        List<Long> wordIdList = this.getWordIdList(appIdList, wordReplaceInfo.getSrcWord(), wordReplaceInfo.getTargetWord());
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>(16);
        if (wordIdList.size() == 0) {
            return listMap;
        }
        String exportFields = this.getTableFields(DBRoute.of((String)"basedata"), "T_CTS_TERMWORD");
        QFilter qFilter = new QFilter("FAPPID", "IN", appIdList);
        QFilter srcWordFilter = new QFilter("ftermword", "=", (Object)wordReplaceInfo.getSrcWord());
        QFilter targetWordFilter = new QFilter("ftermwordcust", "=", (Object)wordReplaceInfo.getTargetWord());
        QFilter langFilter = new QFilter("flanid", "=", (Object)328738425610159104L);
        qFilter.and(srcWordFilter).and(targetWordFilter).and(langFilter);
        String whereCondition = qFilter.toString();
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)"basedata"), "T_CTS_TERMWORD", exportFields, whereCondition, null, null);
        listMap.add(map);
        exportFields = this.getTableFields(DBRoute.of((String)"basedata"), "T_CTS_TERMWORDCOMP");
        builder = new PreInsDataScriptBuilder();
        qFilter = new QFilter("fwordid", "IN", wordIdList);
        ArrayList<String> categoryList = new ArrayList<String>(16);
        categoryList.add("FORM");
        categoryList.add("ENTITY");
        QFilter promptQFilter = new QFilter("fcategory", "in", categoryList);
        QFilter wordStatusFilter = new QFilter("fwordstatus", "=", (Object)"3");
        if (subjectIdList.size() > 0) {
            List<String> metadataIdList = this.getMetadataIdByNumber(subjectIdList, BOS_FORM_META);
            QFilter subjectIdFilter = metadataIdList.size() > 0 ? new QFilter("fsubjectid", "in", metadataIdList) : new QFilter("fsubjectid", "in", subjectIdList);
            whereCondition = qFilter.and(wordStatusFilter).and(promptQFilter).and(subjectIdFilter).toString();
        } else {
            whereCondition = qFilter.and(wordStatusFilter).and(promptQFilter).toString();
        }
        map = builder.genInsertSQLScript(DBRoute.of((String)"basedata"), "T_CTS_TERMWORDCOMP", exportFields, whereCondition, null, null);
        listMap.add(map);
        return listMap;
    }

    private StringBuilder generateReplaceMetaTermDataPreSQL(List<String> appIdList, List<String> subjectIdList, WordReplaceInfo wordReplaceInfo) {
        StringBuilder preSqlBuilder = new StringBuilder();
        preSqlBuilder.append("/****** pre word term metadata sql ******/").append(System.lineSeparator());
        List<Long> wordIdList = this.getWordIdList(appIdList, wordReplaceInfo.getSrcWord(), wordReplaceInfo.getTargetWord());
        if (wordIdList.size() == 0) {
            return preSqlBuilder;
        }
        HRBaseServiceHelper termWordCompServiceHelper = new HRBaseServiceHelper("cts_termwordcomp");
        DynamicObject[] wordCompDynObjs = termWordCompServiceHelper.queryOriginalArray("subjectid", new QFilter[]{new QFilter("wordid", "in", wordIdList)}, null);
        List<String> targetSubjectIdList = Arrays.stream(wordCompDynObjs).map(dynamicObject -> dynamicObject.getString("subjectid")).collect(Collectors.toList());
        QFilter qFilter = this.getMetaScopeQFilter(subjectIdList, targetSubjectIdList, "bos_entitymeta");
        this.getPreMetaDataSqlByType(preSqlBuilder, qFilter.toString(), "T_META_ENTITYDESIGN_TERM", "entity");
        qFilter = this.getMetaScopeQFilter(subjectIdList, targetSubjectIdList, BOS_FORM_META);
        this.getPreMetaDataSqlByType(preSqlBuilder, qFilter.toString(), "T_META_FORMDESIGN_TERM", "form");
        return preSqlBuilder;
    }

    private QFilter getMetaScopeQFilter(List<String> subjectIdList, List<String> subjectidIdList, String entityNumber) {
        List<String> metadataIdList;
        QFilter qFilter = subjectIdList.size() > 0 ? ((metadataIdList = this.getMetadataIdByNumber(subjectIdList, entityNumber)).size() > 0 ? new QFilter("fid", "IN", metadataIdList) : new QFilter("fid", "IN", subjectIdList)) : new QFilter("fid", "in", subjectidIdList);
        return qFilter;
    }

    private List<String> getMetadataIdByNumber(List<String> subjectIdList, String entityNumber) {
        HRBaseServiceHelper metadataServiceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "in", subjectIdList)};
        DynamicObject[] metadataDynObjs = metadataServiceHelper.queryOriginalArray("id", qFilters, null);
        if (metadataDynObjs.length > 0) {
            return Arrays.stream(metadataDynObjs).map(dynamicObject -> dynamicObject.getString("id")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private void getPreMetaDataSqlByType(StringBuilder preSeqlBuiler, String whereCondition, String metaTblName, String type) {
        String selectSql = "select fpkid,fid,flocaleid,fdata from " + metaTblName + " where " + whereCondition;
        DataSet formDataSet = HRDBUtil.queryDataSet((String)"WordReplaceExportPlugin.getPreMetaDataSqlByType", (DBRoute)DBRoute.meta, (String)selectSql, null);
        while (formDataSet.hasNext()) {
            Row row = formDataSet.next();
            String pkId = row.getString("fpkid");
            preSeqlBuiler.append("DELETE FROM T_HBSS_METADESIGN_TERM WHERE FPKID='").append(pkId).append("';").append(System.lineSeparator());
            String id = row.getString("fid");
            String localeId = row.getString("flocaleid");
            String data = row.getString("fdata");
            preSeqlBuiler.append("INSERT INTO T_HBSS_METADESIGN_TERM(FID,FPKID,FLOCALEID,FDATA,FTYPE) VALUES (").append("'").append(id).append("','").append(pkId).append("','").append(localeId).append("','").append(data).append("','").append(type).append("');").append(System.lineSeparator());
        }
        formDataSet.close();
    }

    private List<Long> getWordIdList(List<String> appIdList, String srcWord, String targetWord) {
        HRBaseServiceHelper termWordServiceHelper = new HRBaseServiceHelper("cts_termword");
        QFilter qFilter = new QFilter("appid", "IN", appIdList);
        QFilter srcWordFilter = new QFilter("termword", "=", (Object)srcWord);
        QFilter targetWordFilter = new QFilter("termwordcust", "=", (Object)targetWord);
        QFilter langFilter = new QFilter("lanid", "=", (Object)328738425610159104L);
        qFilter.and(srcWordFilter).and(targetWordFilter).and(langFilter);
        DynamicObject[] wordDynObjs = termWordServiceHelper.queryOriginalArray("id", new QFilter[]{qFilter}, null);
        return Arrays.stream(wordDynObjs).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    private void outPutSqlToFile(List<Map<String, StringWriter>> xmlFileList, StringBuilder sqlBuilder, String sqlFileName) {
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlBuilder.toString().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(this, ins, sqlFileName);
            this.exportXmlFile(this, xmlFileList);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
        }
    }

    private void exportXmlFile(AbstractFormPlugin dynPlugIn, List<Map<String, StringWriter>> xmlFileList) {
        for (Map<String, StringWriter> longTextDataFile : xmlFileList) {
            for (Map.Entry<String, StringWriter> entry : longTextDataFile.entrySet()) {
                StringWriter sw = entry.getValue();
                byte[] xmlByteArray = sw.toString().getBytes(StandardCharsets.UTF_8);
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlByteArray);
                    Throwable throwable = null;
                    try {
                        this.exportFile(dynPlugIn, inputStream, entry.getKey());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)inputStream).close();
                    }
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                }
            }
        }
    }

    private void exportFile(AbstractFormPlugin dynPlugIn, InputStream ins, String sqlFileName) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(sqlFileName, ins, 5000);
        dynPlugIn.getView().openUrl(url);
    }

    private String getTableFields(DBRoute route, String tableName) {
        String querySql = "/*dialect*/select * from " + tableName + " where fid=1000";
        String columns = "";
        final ArrayList columnNameList = new ArrayList(16);
        DB.query((DBRoute)route, (String)querySql, null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet resultSet) throws Exception {
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    int columnType = resultSet.getMetaData().getColumnType(i);
                    String columnName = resultSet.getMetaData().getColumnName(i);
                    columnNameList.add(columnName);
                }
                return null;
            }
        });
        columns = String.join((CharSequence)",", columnNameList);
        return columns;
    }
}

