/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.md.AdminOrgBusinesServiceHelper;
import kd.hr.hbss.bussiness.md.AdminOrgQueryParamInfo;

public class DuplicateCodeUtil {
    private static final String CUSTOMCONTROLAP = "customcontrolap";
    private static final String NULLDATA = "nulldata";
    private static final String BRLED_EQUALS = "brledEquals";
    private static final String ALL_ENABLE = "allEnable";
    private static final String ALL_HAVE_BRLED = "allHaveBrled";
    private static final String PAGE_COSTCENTERORGEL = "hbss_costcenterorgel";
    private static final String BRLED = "brled";
    private static final String EMPPOSORGRELID = "empposorgrelid";
    private static final String ENTRELID = "entrelId";
    private static final String PERSONNUMBER = "personNumber";
    private static final String PERSONNAME = "personName";

    public static QFilter setFilter(BuildTreeListFilterEvent event, ITreeModel treeModel, String entityName) {
        String focusNodeId = event.getNodeId().toString();
        QFilter nodeClicFilter = null;
        if (!treeModel.getRoot().getId().equals(focusNodeId)) {
            QFilter focusNodeFilter = new QFilter("adminorg.id", "=", (Object)focusNodeId);
            DynamicObject focusNodeDy = HRBaseDaoFactory.getInstance((String)entityName).queryOne("longnumber", focusNodeFilter);
            String focusNodeLongNumber = (String)focusNodeDy.get("longnumber");
            QFilter filter = new QFilter("longnumber", "like", (Object)(focusNodeLongNumber + "!%"));
            filter.or(focusNodeFilter);
            QFilter[] filters = new QFilter[]{filter};
            DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)entityName).queryColl("adminorg.id adminorg", filters, null);
            ArrayList<Long> ids = new ArrayList<Long>(dyColl.size());
            int size = dyColl.size();
            for (int i = 0; i < size; ++i) {
                ids.add(((DynamicObject)dyColl.get(i)).getLong("adminorg"));
            }
            nodeClicFilter = new QFilter("adminorg.id", "in", ids);
        }
        return nodeClicFilter;
    }

    public static DynamicObjectCollection getTreeViewCollection(String entityName, String parentId, IFormView view) {
        String selectFields = "adminorg.id id, adminorg.name name,parent,longnumber,isleaf";
        QFilter filter = new QFilter("parent", "=", (Object)Long.valueOf(parentId));
        Boolean isShowDepartmentParam = (Boolean)view.getFormShowParameter().getCustomParam("IsShowDepartment");
        boolean isShowDepartment = isShowDepartmentParam != null ? isShowDepartmentParam : true;
        Boolean isShowDisableParam = (Boolean)view.getFormShowParameter().getCustomParam("IsShowDisable");
        boolean isShowDisable = isShowDisableParam != null ? isShowDisableParam : false;
        QFilter[] filters = null;
        if (!isShowDepartment) {
            HashSet<Long> idSet = new HashSet<Long>();
            idSet.add(Long.valueOf("1020"));
            idSet.add(Long.valueOf("1010"));
            QFilter companyTypeFilter = new QFilter("adminorg.adminorgtype.adminorgtypest", "in", idSet);
            filters = new QFilter[]{filter, companyTypeFilter};
        } else {
            filters = new QFilter[]{filter};
        }
        DynamicObjectCollection dynObjColl = HRBaseDaoFactory.getInstance((String)entityName).queryColl(selectFields, filters, "longnumber");
        List<String> orgIdList = DuplicateCodeUtil.getOrgIdList(dynObjColl);
        AdminOrgQueryParamInfo queryParamInfo = new AdminOrgQueryParamInfo(isShowDepartment, isShowDisable);
        DuplicateCodeUtil.resetIsLeafFieldOfDynamicObject(dynObjColl, orgIdList, queryParamInfo);
        return dynObjColl;
    }

    public static void customEvent(CustomEventArgs args, IFormView view) {
        CustomControl cusCtl = (CustomControl)view.getControl(CUSTOMCONTROLAP);
        BillList f7List = (BillList)view.getControl("billlistap");
        if (cusCtl == null) {
            return;
        }
        String eventName = args.getEventName();
        String pk = args.getEventArgs();
        pk = pk.replace("[\"", "");
        pk = pk.replace("\"]", "");
        if (eventName == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", CUSTOMCONTROLAP);
        map.put("methodname", eventName);
        ArrayList<String> list = new ArrayList<String>();
        if ("removeItem".equals(eventName)) {
            list.add(pk);
        }
        map.put("args", list);
        cusCtl.setData(map);
        ListView obj = (ListView)args.getSource();
        ListSelectedRowCollection listRows = obj.getSelectedRows();
        obj.clearSelection();
        if (listRows == null || "".equals(pk) || "[]".equals(pk) || listRows.size() < 1) {
            return;
        }
        int[] keys = new int[listRows.size() - 1];
        int index = 0;
        for (ListSelectedRow row : listRows) {
            int rowkey = row.getRowKey();
            String rowPk = row.getPrimaryKeyValue().toString();
            if (pk.equals(rowPk)) continue;
            keys[index] = rowkey;
            ++index;
        }
        f7List.selectRows(keys);
    }

    public static Map<String, Boolean> checkDisable(BeforeDoOperationEventArgs args) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        ListSelectedRowCollection selectedData = args.getListSelectedData();
        if (null == selectedData || selectedData.size() < 1) {
            resultMap.put(NULLDATA, true);
            resultMap.put(BRLED_EQUALS, false);
            resultMap.put(ALL_ENABLE, false);
            resultMap.put(ALL_HAVE_BRLED, false);
            return resultMap;
        }
        Object[] pkArray = selectedData.getPrimaryKeyValues();
        if (pkArray != null) {
            DynamicObject[] results = DuplicateCodeUtil.queryOrgEl("brled,enable", pkArray);
            boolean brledEquals = DuplicateCodeUtil.checkBrledEquals(results);
            boolean allEnable = DuplicateCodeUtil.checkAllEnable(results);
            boolean allHaveBrled = DuplicateCodeUtil.checkAllHaveBrled(results);
            resultMap.put(NULLDATA, false);
            resultMap.put(BRLED_EQUALS, brledEquals);
            resultMap.put(ALL_ENABLE, allEnable);
            resultMap.put(ALL_HAVE_BRLED, allHaveBrled);
        } else {
            resultMap.put(NULLDATA, true);
            resultMap.put(BRLED_EQUALS, false);
            resultMap.put(ALL_ENABLE, false);
            resultMap.put(ALL_HAVE_BRLED, false);
        }
        return resultMap;
    }

    private static boolean checkAllHaveBrled(DynamicObject[] results) {
        for (DynamicObject result : results) {
            Date brled = result.getDate(BRLED);
            if (null != brled) continue;
            return false;
        }
        return true;
    }

    private static boolean checkAllEnable(DynamicObject[] results) {
        for (DynamicObject result : results) {
            String enable = result.getString("enable");
            if (HRStringUtils.equals((String)enable, (String)"1")) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBrledEquals(DynamicObject[] results) {
        Object brled;
        DynamicObject result;
        Object brledFirst = null;
        int index = 0;
        int length = results.length;
        for (int idx = 0; idx < length; ++idx) {
            result = results[idx];
            brled = result.get(BRLED);
            if (null == brled) continue;
            brledFirst = brled;
            index = idx;
            break;
        }
        if (brledFirst == null) {
            return true;
        }
        for (int i = index + 1; i < length; ++i) {
            result = results[i];
            brled = result.get(BRLED);
            if (null == brled || brledFirst.equals(brled)) continue;
            return false;
        }
        return true;
    }

    public static DynamicObject[] queryOrgEl(String properties, Object[] pkArray) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(PAGE_COSTCENTERORGEL);
        QFilter filter = new QFilter("id", "in", (Object)pkArray);
        QFilter[] filters = new QFilter[]{filter};
        return helper.queryOriginalArray(properties, filters);
    }

    public static void beforeClick(BeforeClickEvent evt, IFormView view) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        List<Map<String, Object>> selectList = null;
        if ("btnok".equals(key) && (selectList = DuplicateCodeUtil.getCurrentSelector(view)) == null) {
            selectList = new ArrayList<Map<String, Object>>();
        }
        view.returnDataToParent(selectList);
        view.close();
    }

    public static void sendLinkData(HyperLinkClickArgs args, IFormView view) {
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRowCollection listRowColl = new ListSelectedRowCollection();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(billList.getFocusRowPkId());
        listRowColl.add((Object)row);
        List<Map<String, Object>> selectList = DuplicateCodeUtil.setSelectorInfo(listRowColl);
        view.returnDataToParent(selectList);
        view.close();
    }

    private static List<Map<String, Object>> getCurrentSelector(IFormView view) {
        List<Map<String, Object>> selectList = null;
        ListSelectedRowCollection listRowColl = ((ListView)view).getSelectedRows();
        if (listRowColl != null && listRowColl.size() > 0) {
            selectList = DuplicateCodeUtil.setSelectorInfo(listRowColl);
        }
        return selectList;
    }

    public static List<Map<String, Object>> setSelectorInfo(ListSelectedRowCollection listRowColl) {
        ArrayList<Map<String, Object>> selectList = null;
        if (listRowColl == null || listRowColl.size() < 1) {
            return selectList;
        }
        selectList = new ArrayList();
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select rel.FID,rel.FPERSONID,rel.FDEPEMPID,per.FNUMBER,perl.FNAME,dep.FCMPEMPID,dep.FEMPLOYEEID,entrel.fid entrelId from T_HERS_EMPPOSORGREL rel ").append("left join T_HERS_PERSON per on per.fid = rel.FPERSONID ").append("left join T_HERS_DEPEMP dep on dep.fid = rel.FDEPEMPID ").append(" left join T_HERS_EMPENTREL entrel on dep.FEMPLOYEEID = entrel.FEMPLOYEEID ").append("left join T_HERS_PERSON_L perl on per.fid = perl.fid where perl.FLOCALEID = 'zh_CN' AND rel.FID in (");
        StringBuilder idStr = new StringBuilder();
        for (ListSelectedRow row : listRowColl) {
            idStr.append("?,");
            paramList.add(row.getPrimaryKeyValue());
        }
        sql.append(idStr.substring(0, idStr.length() - 1)).append(')');
        Object[] params = paramList.stream().toArray(Object[]::new);
        selectList = (List)HRDBUtil.query((DBRoute)new DBRoute("hr"), (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, Object>> listData = new ArrayList<Map<String, Object>>(16);
                while (rs.next()) {
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    dataMap.put(DuplicateCodeUtil.EMPPOSORGRELID, rs.getString("FID"));
                    dataMap.put(DuplicateCodeUtil.ENTRELID, rs.getString(DuplicateCodeUtil.ENTRELID));
                    dataMap.put(DuplicateCodeUtil.PERSONNUMBER, rs.getString("FNUMBER"));
                    dataMap.put(DuplicateCodeUtil.PERSONNAME, rs.getString("FNAME"));
                    dataMap.put("person", rs.getString("FPERSONID"));
                    dataMap.put("cmpemp", rs.getString("FCMPEMPID"));
                    dataMap.put("depemp", rs.getString("FDEPEMPID"));
                    dataMap.put("employee", rs.getString("FEMPLOYEEID"));
                    listData.add(dataMap);
                }
                return listData;
            }
        });
        return selectList;
    }

    private static List<String> getOrgIdList(DynamicObjectCollection dynColl) {
        ArrayList<String> orgIdList = new ArrayList<String>(dynColl.size());
        int size = dynColl.size();
        for (int i = 0; i < size; ++i) {
            orgIdList.add(String.valueOf(((DynamicObject)dynColl.get(i)).get("id")));
        }
        return orgIdList;
    }

    private static void resetIsLeafFieldOfDynamicObject(DynamicObjectCollection dynColl, List<String> orgIdList, AdminOrgQueryParamInfo adminOrgQueryParamInfo) {
        if (orgIdList.size() > 0) {
            Map subOrgCountMap = AdminOrgBusinesServiceHelper.getSubAdminOrgCountMap((AdminOrgQueryParamInfo)adminOrgQueryParamInfo, orgIdList);
            DynamicObject dynObj = null;
            int size = dynColl.size();
            for (int i = 0; i < size; ++i) {
                dynObj = (DynamicObject)dynColl.get(i);
                long id = dynObj.getLong("id");
                if (subOrgCountMap.get(String.valueOf(id)) != null && (Integer)subOrgCountMap.get(String.valueOf(id)) > 0) {
                    dynObj.set("isleaf", (Object)Boolean.FALSE);
                    continue;
                }
                dynObj.set("isleaf", (Object)Boolean.TRUE);
            }
        }
    }
}

