/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.validator;

import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import org.apache.commons.lang3.StringUtils;

public class BasedataConfigOpValidator
extends AbstractValidator {
    private static final String AUDITCHECK = "auditcheck";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity data : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = data.getDataEntity();
            String number = dynamicObject.getString("basedatafield.number");
            boolean auditcheck = dynamicObject.getBoolean(AUDITCHECK);
            String isopen = dynamicObject.getString("isopen");
            if (!this.existTableByNumber(number)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u7269\u7406\u8868\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"BasedataConfigOpValidator_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.equals((CharSequence)isopen, (CharSequence)"1")) {
                if (!auditcheck && this.existHisAuditDataByNumber(number)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u5b58\u5728\u201c\u6682\u5b58\u201d\u72b6\u6001\u7684\u5386\u53f2\u7248\u672c\uff0c\u65e0\u6cd5\u4fee\u6539\u6b64\u53c2\u6570\uff0c\u8bf7\u5148\u786e\u8ba4\u53d8\u66f4\u6240\u6709\u201c\u6682\u5b58\u201d\u72b6\u6001\u7248\u672c\u3002", (String)"BasedataConfigOpValidator_2", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
                }
                if (auditcheck || !this.existAuditDataByNumber(number)) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u90e8\u5206\u6570\u636e\u4e3a\u201c\u6682\u5b58\u201d\u6216\u201c\u5df2\u63d0\u4ea4\u201d\u72b6\u6001\uff0c\u8bf7\u5168\u90e8\u63d0\u4ea4\u5ba1\u6838\u540e\u518d\u4fee\u6539\u6b64\u53c2\u6570\u3002", (String)"BasedataConfigOpValidator_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!this.getAudit() && this.existHisAuditDataByNumber(number)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u5b58\u5728\u201c\u6682\u5b58\u201d\u72b6\u6001\u7684\u5386\u53f2\u7248\u672c\uff0c\u65e0\u6cd5\u4fee\u6539\u6b64\u53c2\u6570\uff0c\u8bf7\u5148\u786e\u8ba4\u53d8\u66f4\u6240\u6709\u201c\u6682\u5b58\u201d\u72b6\u6001\u7248\u672c\u3002", (String)"BasedataConfigOpValidator_2", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
            }
            if (this.getAudit() || !this.existAuditDataByNumber(number)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u90e8\u5206\u6570\u636e\u4e3a\u201c\u6682\u5b58\u201d\u6216\u201c\u5df2\u63d0\u4ea4\u201d\u72b6\u6001\uff0c\u8bf7\u5168\u90e8\u63d0\u4ea4\u5ba1\u6838\u540e\u518d\u4fee\u6539\u6b64\u53c2\u6570\u3002", (String)"BasedataConfigOpValidator_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean existHisAuditDataByNumber(String number) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(number);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        IDataEntityProperty property = dataEntityType.findProperty("status");
        IDataEntityProperty isCurrentVersion = dataEntityType.findProperty("iscurrentversion");
        if (property == null || isCurrentVersion == null) {
            return false;
        }
        QFilter idFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id", new QFilter[]{idFilter});
        return dynamicObjects.length != 0;
    }

    private boolean getAudit() {
        Map<String, Object> systemParam = this.getConfigParams();
        boolean auditcheck = false;
        if (!Objects.isNull(systemParam.get(AUDITCHECK))) {
            auditcheck = (Boolean)systemParam.get(AUDITCHECK);
        }
        return auditcheck;
    }

    private Map<String, Object> getConfigParams() {
        long orgId = RequestContext.get().getOrgId() == 0L ? OrgServiceUtil.getHRRootOrgId() : RequestContext.get().getOrgId();
        AppParam appParam = new AppParam("XYRL3+A8Z+Z", Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    private boolean existAuditDataByNumber(String number) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(number);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        IDataEntityProperty property = dataEntityType.findProperty("status");
        if (property == null) {
            return false;
        }
        QFilter idFilter = new QFilter("status", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B"}));
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id", new QFilter[]{idFilter});
        return dynamicObjects.length != 0;
    }

    private boolean existTableByNumber(String number) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        return !dataEntityType.getAlias().isEmpty();
    }
}

