/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class UserPermFilesSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.canSave(datas);
        }
    }

    private void canSave(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject permFile = dataEntity.getDataEntity();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_userpermfile");
            Long personId = permFile.getLong("user.id");
            Long orgId = permFile.getLong("org.id");
            QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)personId), new QFilter("org", "=", (Object)orgId)};
            DynamicObject permFileDyc = serviceHelper.queryOne("id,permfileenable", filters);
            this.checkUnique(dataEntity, permFile, permFileDyc);
        }
    }

    private void checkUnique(ExtendedDataEntity dataEntity, DynamicObject permFile, DynamicObject permFileDyc) {
        Long permId;
        Long dycId;
        if (permFileDyc != null && !(dycId = (Long)permFileDyc.getPkValue()).equals(permId = (Long)permFile.getPkValue())) {
            String name = permFile.getString("user.name");
            String org = permFile.getString("org.name");
            String msg = null;
            msg = HRStringUtils.equals((String)permFileDyc.getString("permfileenable"), (String)"1") ? String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s\u5df2\u5b58\u5728\u6743\u9650\u6863\u6848\uff0c\u5f53\u524d\u72b6\u6001\u4e3a\u751f\u6548\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u521b\u5efa\u3002", (String)"UserPermFilesSaveValidator_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]), name, org) : String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s\u5df2\u5b58\u5728\u6743\u9650\u6863\u6848\uff0c\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u5931\u6548\uff0c\u76f4\u63a5\u5728\u5217\u8868\u627e\u5230\u6743\u9650\u6863\u6848\uff0c\u5e76\u70b9\u51fb\u3010\u751f\u6548\u3011\u6309\u94ae\u5373\u53ef\u3002", (String)"UserPermFilesSaveValidator_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]), name, org);
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

