/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.validator.taxunit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class TaxUnitUnAuditValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"unaudit")) {
            for (ExtendedDataEntity data : datas) {
                if (!this.checkDataReference(Collections.singletonList(data.getDataEntity().getLong("id"))).booleanValue()) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u88ab\u6863\u6848\u5f15\u7528\u7684\u6570\u636e\u4e0d\u80fd\u88ab\u53cd\u5ba1\u6838\u3002", (String)"TaxUnitUnAuditValidator_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]), new Object[0]));
                break;
            }
        }
    }

    private Boolean checkDataReference(List<Long> pkId) {
        boolean flag = false;
        ArrayList<Long> taxUnitIds = new ArrayList<Long>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_taxunit");
        DynamicObject dynamicObject = serviceHelper.loadSingle((Object)pkId.get(0));
        BasedataEntityType basedataEntityType = (BasedataEntityType)dynamicObject.getDataEntityType();
        Map<Object, BaseDataCheckRefrenceResult> checkResult = TaxUnitUnAuditValidator.baseDataCheckReference(basedataEntityType, pkId.toArray());
        for (Object taxUnitId : checkResult.keySet()) {
            taxUnitIds.add((Long)taxUnitId);
        }
        if (!taxUnitIds.isEmpty()) {
            flag = true;
        }
        return flag;
    }

    private static Map<Object, BaseDataCheckRefrenceResult> baseDataCheckReference(BasedataEntityType baseEntityType, Object[] objIds) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(false);
        return checker.checkRef(baseEntityType, objIds);
    }
}

