/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hbss.bussiness.servicehelper.LawEntityServiceHelper;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class EnterpriseRelLawEntityOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(EnterpriseRelLawEntityOp.class);
    private static final String LAWENTITY = "lawentity";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(LAWENTITY);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String currEntityName = this.billEntityType.getName();
        String opKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        if (!this.isInvokeService(currEntityName, opKey, dataEntities)) {
            return;
        }
        try {
            LawEntityServiceHelper.relLawEntity((String)currEntityName, (String)opKey, (DynamicObject[])dataEntities);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("EnterpriseRelLawEntityOp exception:" + ExceptionUtils.getStackTrace((Throwable)e));
            }
            this.dealWithErrorMsg(opKey, args, "EnterpriseRelLawEntityOp exception:" + e.getMessage());
        }
    }

    private boolean isInvokeService(String currEntityName, String opKey, DynamicObject[] dataEntities) {
        if ("audit".equals(opKey) || "unaudit".equals(opKey)) {
            boolean allLawIdIsNull = true;
            for (int i = 0; i < dataEntities.length; ++i) {
                Long newLawId = EnterpriseRelLawEntityOp.buildNewLawId(dataEntities[i]);
                if (Objects.isNull(newLawId) || newLawId == 0L) continue;
                allLawIdIsNull = false;
                break;
            }
            if (!allLawIdIsNull) {
                return true;
            }
        } else if ("save".equals(opKey)) {
            if (dataEntities[0].get("status").equals("C")) {
                boolean allLawIdIsEqual = true;
                for (int i = 0; i < dataEntities.length; ++i) {
                    Long oldLawId;
                    Long newLawId = EnterpriseRelLawEntityOp.buildNewLawId(dataEntities[i]);
                    if (newLawId.equals(oldLawId = EnterpriseRelLawEntityOp.buildOldLawId(currEntityName, (Long)dataEntities[i].getPkValue()))) continue;
                    allLawIdIsEqual = false;
                    break;
                }
                if (!allLawIdIsEqual) {
                    return true;
                }
            }
        } else if ("delete".equals(opKey) && dataEntities[0].get("status").equals("C")) {
            boolean allLawIsNull = true;
            for (int i = 0; i < dataEntities.length; ++i) {
                if (Objects.isNull(dataEntities[i].get(LAWENTITY))) continue;
                allLawIsNull = false;
                break;
            }
            if (!allLawIsNull) {
                return true;
            }
        }
        return false;
    }

    private void dealWithErrorMsg(String opKey, BeginOperationTransactionArgs args, String msg) {
        if ("save".equals(opKey)) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7528\u4eba\u5355\u4f4d\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\uff01\u3010%s\u3011", (String)"EnterpriseRelLawEntityOp_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]), msg);
            this.operationResult.setMessage(errorMsg);
        } else if ("delete".equals(opKey)) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7528\u4eba\u5355\u4f4d\u5220\u9664\u64cd\u4f5c\u5931\u8d25\uff01\u3010%s\u3011", (String)"EnterpriseRelLawEntityOp_2", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]), msg);
            this.operationResult.setMessage(errorMsg);
        }
        this.operationResult.setShowMessage(true);
        this.operationResult.setSuccess(false);
        args.setCancelOperation(true);
    }

    private static Long buildNewLawId(DynamicObject dataEntity) {
        DynamicObject newLawEntity = (DynamicObject)dataEntity.get(LAWENTITY);
        if (!Objects.isNull(newLawEntity)) {
            return (Long)newLawEntity.getPkValue();
        }
        return 0L;
    }

    private static Long buildOldLawId(String currEntityName, Long currOpItemId) {
        DynamicObject oldLawEntity;
        DynamicObject currEntity;
        HRBaseServiceHelper currEntityHelper = new HRBaseServiceHelper(currEntityName);
        if (!(Objects.isNull(currOpItemId) || currOpItemId == 0L || Objects.isNull(currEntity = currEntityHelper.queryOne(LAWENTITY, (Object)currOpItemId)) || Objects.isNull(oldLawEntity = (DynamicObject)currEntity.get(LAWENTITY)))) {
            return (Long)oldLawEntity.getPkValue();
        }
        return 0L;
    }
}

