/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web;

import com.google.common.collect.Lists;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

@ExcludeFromJacocoGeneratedReport
public class HrParamsConfigOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("basedatafield");
        args.getFieldKeys().add("auditcheck");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity data : dataEntities = this.getDataEntities()) {
                    DynamicObject dynamicObject = data.getDataEntity();
                    String number = dynamicObject.getString("basedatafield.number");
                    boolean auditcheck = dynamicObject.getBoolean("auditcheck");
                    if (!auditcheck || !HrParamsConfigOp.this.existAudiDatatByNumber(number)) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u57fa\u7840\u8d44\u6599\u90e8\u5206\u6570\u636e\u975e\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664", (String)"HrParamsConfigOp_0", (String)"hrmp-hbp-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private boolean existAudiDatatByNumber(String number) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(number);
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
            IDataEntityProperty property = dataEntityType.findProperty("status");
            if (property == null) {
                return false;
            }
            QFilter idFilter = new QFilter("status", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B"}));
            DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id", new QFilter[]{idFilter});
            return dynamicObjects.length != 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

