/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web.diff;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.DiffServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import org.json.JSONArray;
import org.json.JSONObject;

public class DiffApiAopScopeSaveOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(DiffApiAopScopeSaveOp.class);
    private final String CONFIG_FILENAME = "apiaopconfig";

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        for (DynamicObject dynamicObject : args.getDataEntities()) {
            for (DynamicObject config : dynamicObject.getDynamicObjectCollection("config")) {
                this.generateDeployFile(config.getString("app.id"), config.getString("path"));
            }
        }
    }

    private void generateDeployFile(String appId, String path) {
        block16: {
            StringBuilder stringBuilder = new StringBuilder();
            String resourcePath = stringBuilder.append(new File(path).getAbsolutePath()).append(File.separator).append("src").append(File.separator).append("main").append(File.separator).append("java").append(File.separator).append("resources").toString();
            File dir = new File(resourcePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String filename = "";
            if (dir.exists()) {
                filename = resourcePath + File.separator + "apiaopconfig" + ".json";
                try {
                    Map map = DiffServiceHelper.listApiAopWithByAppId((String)appId);
                    JSONArray jsonArray = this.toJsonArray(map);
                    String content = jsonArray.toString();
                    try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));){
                        stream.writeBytes(content);
                        stream.flush();
                        break block16;
                    }
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u90e8\u7f72\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6307\u5b9a\u7684\u6587\u4ef6\u8def\u5f84\u662f\u5426\u6b63\u786e\u3002", (String)"DiffApiAopScopeSaveOp_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
                }
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u90e8\u7f72\u6587\u4ef6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6307\u5b9a\u7684\u6587\u4ef6\u8def\u5f84\u662f\u5426\u6b63\u786e\u3002", (String)"DiffApiAopScopeSaveOp_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
        }
    }

    private JSONArray toJsonArray(Map<String, Map<String, String>> map) {
        JSONArray jsonArray = new JSONArray();
        for (String key : map.keySet()) {
            JSONObject item = new JSONObject();
            String[] aopConfigs = key.split("#");
            item.put("className", (Object)aopConfigs[0]);
            item.put("methodName", (Object)aopConfigs[1]);
            item.put("aopType", (Object)aopConfigs[2]);
            jsonArray.put((Object)item);
        }
        return jsonArray;
    }
}

