/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web.hrbu;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgParam;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hbss.bussiness.servicehelper.BosOrgServiceHelper;
import kd.hr.hbss.opplugin.web.hrbu.validator.HRBUQueryListOpValidator;

public class HRBUQueryListOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(HRBUQueryListOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new HRBUQueryListOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey;
        super.beginOperationTransaction(args);
        DynamicObject[] dys = args.getDataEntities();
        switch (operationKey = args.getOperationKey().toLowerCase(Locale.ROOT)) {
            case "save": {
                return;
            }
            case "dobatchsave": {
                ArrayList paramSuccessList = Lists.newArrayListWithExpectedSize((int)dys.length);
                List<Object> successOrgIdList = this.batchSaveBosOrg(dys, paramSuccessList, "dobatchsave");
                if (successOrgIdList.size() != 0) break;
                this.getOperationResult().setSuccess(false);
                break;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void setBosSignErrResult(OrgParam orgParam, OperateErrorInfo errorInfo) {
        String errorMsg = ResManager.loadKDString((String)"\u5f15\u5165HR\u7ba1\u7406\u7ec4\u7ec7\u62a5\u9519\u3002", (String)"HRBUQueryListOp_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]);
        if (orgParam != null) {
            logger.error("HRBUQueryListOp.setBosSignErrResult orgParam : {}", (Object)orgParam.toString());
        }
        if (orgParam != null && !HRStringUtils.isEmpty((String)orgParam.getMsg())) {
            errorMsg = orgParam.getMsg();
            logger.error("HRBUQueryListOp.setBosSignErrResult error : {}", (Object)errorMsg);
        }
        errorInfo.setErrorCode("errorcode_001");
        errorInfo.setMessage(errorMsg);
        this.operationResult.setMessage(errorMsg);
        this.operationResult.setShowMessage(true);
        this.operationResult.setSuccess(false);
    }

    @ExcludeFromJacocoGeneratedReport
    private void setBosBatchErrResult(List<OrgParam> resultList, String operationKey) {
        List setErrorList = this.getOperationResult().getAllErrorInfo();
        for (OrgParam orgParam : resultList) {
            if (orgParam.isSuccess()) continue;
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            this.setBosSignErrResult(orgParam, operateErrorInfo);
            operateErrorInfo.setLevel(ErrorLevel.FatalError);
            operateErrorInfo.setPkValue((Object)orgParam.getId());
            operateErrorInfo.setTitle(this.getTitleName(operationKey));
            setErrorList.add(operateErrorInfo);
        }
        this.getOperationResult().setAllErrorInfo(setErrorList);
    }

    public void onReturnOperation(ReturnOperationArgs returnOperationArgs) {
        super.onReturnOperation(returnOperationArgs);
        IOperationResult result = returnOperationArgs.getOperationResult();
        List resultAllErrorInfo = result.getAllErrorInfo();
        ArrayList errorIdList = Lists.newArrayListWithExpectedSize((int)resultAllErrorInfo.size());
        for (OperateErrorInfo errorInfo : resultAllErrorInfo) {
            errorIdList.add(errorInfo.getPkValue());
        }
        List successList = result.getSuccessPkIds();
        successList.removeAll(errorIdList);
        ArrayList zeroList = Lists.newArrayListWithExpectedSize((int)1);
        zeroList.add(0L);
        successList.removeAll(zeroList);
        result.setSuccessPkIds(successList);
    }

    @ExcludeFromJacocoGeneratedReport
    private List<Object> batchSaveBosOrg(DynamicObject[] dys, List<OrgParam> paramSuccessList, String operationKey) {
        List paramList = BosOrgServiceHelper.assembleOrgParamByHrBuViewExtDy((DynamicObject[])dys);
        BosOrgServiceHelper.addNewHRUnit((List)paramList);
        return this.getSuccessList(paramList, paramSuccessList, operationKey);
    }

    @ExcludeFromJacocoGeneratedReport
    private List<Object> getSuccessList(List<OrgParam> paramList, List<OrgParam> paramSuccessList, String operationKey) {
        if (null == paramList || paramList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList successOrgIdList = Lists.newArrayListWithExpectedSize((int)paramList.size());
        ArrayList errOrgIdList = Lists.newArrayListWithExpectedSize((int)paramList.size());
        for (OrgParam orgParam : paramList) {
            if (orgParam.isSuccess()) {
                successOrgIdList.add(orgParam.getId());
                paramSuccessList.add(orgParam);
                continue;
            }
            errOrgIdList.add(orgParam);
        }
        if (errOrgIdList.size() != 0) {
            this.setBosBatchErrResult(errOrgIdList, operationKey);
        }
        return successOrgIdList;
    }

    @ExcludeFromJacocoGeneratedReport
    private String getTitleName(String operationKey) {
        String name = "";
        if (HRStringUtils.equals((String)operationKey, (String)"dodelete")) {
            name = ResManager.loadKDString((String)"\u79fb\u9664", (String)"HRBUQueryListOp_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]);
        } else if (HRStringUtils.equals((String)operationKey, (String)"dobatchsave")) {
            name = ResManager.loadKDString((String)"\u5f15\u5165\u57fa\u7840\u4e1a\u52a1\u5355\u5143", (String)"HRBUQueryListOp_2", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]);
        }
        return name;
    }
}

