/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web.lawentity;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hbss.opplugin.validator.LawEntityChgOpValidator;
import kd.hr.hbss.opplugin.web.lawentity.LawEntityOpHelper;

public class LawEntityChgOp
extends HRDataBaseOp {
    private static final String CHG = "chg";
    private static final String BAR_CHGMODIFY = "bar_chgmodify";
    private static String BAR_CHGSAVE = "bar_chgsave";
    private static final String ENTITYTYPE = "entitytype";
    private static final String FS_BASEINFO = "fs_baseinfo";
    private static final String PROPCTL = "propctl";
    private static final String OPRSTS = "oprsts";
    private static final String ENTERPRISE = "enterprise";
    private static final String SIGNCOMPANY = "signcompany";
    private static final String TAXUNIT = "taxunit";
    private static final String WELFAREPAYER = "welfarepayer";
    private static final String PAYSUBJECT = "paysubject";
    private static final String OPRSTS_1 = "1";
    private static final String OPRSTS_2 = "2";
    private static final String ADMINORG = "adminorg";
    private static final String UNIFORMSOCIALCREDITCODE = "uniformsocialcreditcode";
    static final String UNIFORMSOCIALCREDITCOD = "uniformsocialcreditcod";
    private static final String FIRMNAME = "firmname";
    private static final String REPRESENTATIVE = "representative";
    private static final String ESTABLISHMENTDATE = "establishmentdate";
    private static final String BUSINESSTERM = "businessterm";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String PHONE = "phone";
    private static final String ADDRESS = "address";
    private static final String VER_NUM = "vernum";
    private static final String DESC = "desc";
    private static final String EFFECT_DATE = "effectdate";
    private static final String CREATEORG = "createorg";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String TYPE = "type";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        LawEntityOpHelper.preparePropertys(args);
    }

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        eventArgs.addValidator((AbstractValidator)new LawEntityChgOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject chgLawEntity;
        DynamicObject[] dataEntities = args.getDataEntities();
        this.buildAdminOrgInfo(dataEntities);
        if (StringUtils.equals((CharSequence)"editsave", (CharSequence)args.getOperationKey()) && null != (chgLawEntity = dataEntities[0]) && StringUtils.isNotEmpty((CharSequence)chgLawEntity.getString(DESC))) {
            String chgName = chgLawEntity.getString("name");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_lawentity");
            DynamicObject dbLawEntity = serviceHelper.loadSingle(chgLawEntity.getPkValue());
            String dbName = dbLawEntity.getString("name");
            this.chkChgName(serviceHelper, chgName, dbName, args);
            DynamicObjectCollection entryDys = chgLawEntity.getDynamicObjectCollection("entryentity");
            entryDys.add((Object)this.buildNewEntry(dbLawEntity, entryDys, chgLawEntity));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        if (StringUtils.equals((CharSequence)"editsave", (CharSequence)args.getOperationKey())) {
            DynamicObject chgLawEntity;
            DynamicObject[] dataEntities = args.getDataEntities();
            if (null != dataEntities && dataEntities.length > 0 && null != (chgLawEntity = dataEntities[0]) && StringUtils.isNotEmpty((CharSequence)chgLawEntity.getString(DESC))) {
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("msgNumber", String.valueOf(ORM.create().genLongId("hrcs_msgcenter")));
                param.put("msgPubNo", "MP20220530000757");
                String chgMsg = ResManager.loadKDString((String)"\u6cd5\u5f8b\u5b9e\u4f53\u53d8\u66f4", (String)"LawEntityChgOp_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]);
                param.put("msgTitle", chgMsg);
                param.put("msgDesc", chgMsg);
                param.put("actionId", 101310L);
                param.put("msgTag", chgMsg);
                param.put("senderId", RequestContext.get().getCurrUserId());
                param.put("sendTime", new Date());
                String params = "{\"eventId\":" + chgLawEntity.getPkValue() + "}";
                param.put("params", params);
                HRProducerServiceHelper.publishAction(param);
            }
            LawEntityOpHelper.addOpSyncAddSignComp(dataEntities);
        }
    }

    private void buildAdminOrgInfo(DynamicObject[] dataEntities) {
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntitie = dataEntities[i];
            DynamicObject adminOrg = (DynamicObject)dataEntitie.get(ADMINORG);
            if (null == adminOrg) continue;
            dataEntitie.set(UNIFORMSOCIALCREDITCODE, adminOrg.get(UNIFORMSOCIALCREDITCODE));
            dataEntitie.set(FIRMNAME, adminOrg.get("ffirmname"));
            dataEntitie.set(REPRESENTATIVE, (Object)adminOrg.getString("frepresentative"));
            dataEntitie.set(ESTABLISHMENTDATE, adminOrg.get(ESTABLISHMENTDATE));
            dataEntitie.set(STARTDATE, adminOrg.get(ESTABLISHMENTDATE));
            dataEntitie.set(ENDDATE, adminOrg.get(BUSINESSTERM));
            dataEntitie.set(PHONE, adminOrg.get(PHONE));
            dataEntitie.set(ADDRESS, (Object)adminOrg.getString("faddress"));
        }
    }

    private void chkChgName(HRBaseServiceHelper serviceHelper, String chgName, String dbName, BeginOperationTransactionArgs args) {
        boolean existsName = serviceHelper.isExists(new QFilter("name", "=", (Object)chgName));
        if (existsName && !StringUtils.equals((CharSequence)chgName, (CharSequence)dbName)) {
            String errorMsg = ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"LawEntityChgOp_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]);
            this.operationResult.setMessage(errorMsg);
            this.operationResult.setShowMessage(true);
            this.operationResult.setSuccess(false);
            args.setCancelOperation(true);
        }
    }

    private DynamicObject buildNewEntry(DynamicObject dbLawEntity, DynamicObjectCollection entryDys, DynamicObject chgLawEntity) {
        MainEntityType mainType = (MainEntityType)dbLawEntity.getDataEntityType();
        EntityType type = (EntityType)mainType.getAllEntities().get("entryentity");
        DynamicObject vrInf = (DynamicObject)type.createInstance();
        vrInf.set("chgindex", (Object)this.buildVerNum(entryDys));
        vrInf.set(VER_NUM, (Object)("V" + this.buildVerNum(entryDys) + ".0"));
        vrInf.set("chgdesc", chgLawEntity.get(DESC));
        vrInf.set("chgeffectdate", (Object)new Date());
        vrInf.set("chgtype", chgLawEntity.get(TYPE));
        vrInf.set("chgcreator1", (Object)RequestContext.get().getCurrUserId());
        vrInf.set("chgcreatetime1", (Object)new Date());
        vrInf.set("chgcreateorg", dbLawEntity.get(CREATEORG));
        vrInf.set("chgctrlstrategy", dbLawEntity.get(CTRLSTRATEGY));
        vrInf.set("chgnumber", dbLawEntity.get("number"));
        if (!ObjectUtils.isEmpty((Object)dbLawEntity.get("creator"))) {
            vrInf.set("chgcreator", ((DynamicObject)dbLawEntity.get("creator")).getPkValue());
        }
        vrInf.set("chgcreatetime", dbLawEntity.get("createtime"));
        if (!ObjectUtils.isEmpty((Object)dbLawEntity.get("modifier"))) {
            vrInf.set("chgmodifier", ((DynamicObject)dbLawEntity.get("modifier")).getPkValue());
        }
        vrInf.set("chgmodifytime", dbLawEntity.get("modifytime"));
        vrInf.set("chgstatus", dbLawEntity.get("status"));
        vrInf.set("chgenable", dbLawEntity.get("enable"));
        if (!ObjectUtils.isEmpty((Object)dbLawEntity.get("disabler"))) {
            vrInf.set("chgdisabler", ((DynamicObject)dbLawEntity.get("disabler")).getPkValue());
        }
        vrInf.set("chgdisabledate", dbLawEntity.get("disabledate"));
        vrInf.set("chgissyspreset", dbLawEntity.get("issyspreset"));
        vrInf.set("chgmasterid", dbLawEntity.get("masterid"));
        vrInf.set("chgname", dbLawEntity.get("name"));
        vrInf.set("chgsimplename", dbLawEntity.get("simplename"));
        vrInf.set("chgdescription", dbLawEntity.get("description"));
        vrInf.set("chgentitytype", dbLawEntity.get(ENTITYTYPE));
        vrInf.set("chgpropctl", dbLawEntity.get(PROPCTL));
        vrInf.set("chgoprsts", dbLawEntity.get(OPRSTS));
        vrInf.set("chgenterprise", dbLawEntity.get(ENTERPRISE));
        vrInf.set("chgsigncompany", dbLawEntity.get(SIGNCOMPANY));
        vrInf.set("chgtaxunit", dbLawEntity.get(TAXUNIT));
        vrInf.set("chgwelfarepayer", dbLawEntity.get(WELFAREPAYER));
        vrInf.set("chgpaysubject", dbLawEntity.get(PAYSUBJECT));
        if (!ObjectUtils.isEmpty((Object)dbLawEntity.get(ADMINORG))) {
            vrInf.set("chgadminorg", ((DynamicObject)dbLawEntity.get(ADMINORG)).getPkValue());
        }
        vrInf.set("chguniformsocialcreditcod", dbLawEntity.get(UNIFORMSOCIALCREDITCODE));
        vrInf.set("chgfirmname", dbLawEntity.get(FIRMNAME));
        vrInf.set("chgrepresentative", dbLawEntity.get(REPRESENTATIVE));
        vrInf.set("chgestablishmentdate", dbLawEntity.get(ESTABLISHMENTDATE));
        vrInf.set("chgstartdate", dbLawEntity.get(STARTDATE));
        vrInf.set("chgenddate", dbLawEntity.get(ENDDATE));
        vrInf.set("chgphone", dbLawEntity.get(PHONE));
        vrInf.set("chgaddress", dbLawEntity.get(ADDRESS));
        return vrInf;
    }

    private int buildVerNum(DynamicObjectCollection entryDys) {
        int verNum = 1;
        if (!CollectionUtils.isEmpty((Collection)entryDys)) {
            int lastestNum = verNum;
            for (DynamicObject entryDy : entryDys) {
                int currVerNum;
                String currVerStr = (String)entryDy.get(VER_NUM);
                if (StringUtils.isEmpty((CharSequence)currVerStr) || (currVerNum = Integer.parseInt(currVerStr.substring(1, currVerStr.length() - 2))) <= lastestNum) continue;
                lastestNum = currVerNum;
            }
            verNum = lastestNum + 1;
        }
        return verNum;
    }
}

