/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hcf.mservice;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hrmp.hcf.business.attachedtable.servicehelper.AttachedTabServiceHelper;
import kd.hrmp.hcf.business.attachedtable.util.AttachTableUtil;
import kd.hrmp.hcf.business.attachedtable.validate.HCFServiceValidate;
import kd.hrmp.hcf.business.common.service.ICandidateService;
import kd.hrmp.hcf.business.common.service.impl.CandidateService;
import kd.hrmp.hcf.business.datatrans.AttachmentHelper;
import kd.hrmp.hcf.business.datatrans.DataTransService;
import kd.hrmp.hcf.constants.Constants;
import kd.hrmp.hcf.mservice.api.IHCFService;

public class HCFService
implements IHCFService {
    private static final Log LOGGER = LogFactory.getLog(HCFService.class);
    private ICandidateService candidateService = new CandidateService();
    private static final Set<String> NON_HIS_TABLE = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{Constants.HCF_CANBANKCARD, Constants.HCF_CANOCPQUAL, Constants.HCF_EDUCERTIFICATE, Constants.HCF_RSMPATINV}));

    public Map<String, Object> saveOrUpdateCandidate(Map<String, Object> candidateSyncMap) {
        return DataTransService.getInstance().saveOrUpdateCandidates(candidateSyncMap);
    }

    public Map<String, Object> saveOrUpdateCandidates(List<Map<String, DynamicObjectCollection>> candidateInfo) {
        if (candidateInfo == null || candidateInfo.size() == 0) {
            return this.returnMap(false, "input params is empty");
        }
        for (Map<String, DynamicObjectCollection> subTable : candidateInfo) {
            for (Map.Entry<String, DynamicObjectCollection> entry : subTable.entrySet()) {
                String key = entry.getKey();
                if (NON_HIS_TABLE.contains(key)) continue;
                DynamicObjectCollection dynamicObjects = entry.getValue();
                DynamicObject[] dys = (DynamicObject[])dynamicObjects.toArray((Object[])new DynamicObject[0]);
                AttachedTabServiceHelper.updateAttachedTab((DynamicObject[])dys);
            }
        }
        return this.returnMap(true, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"HCFService_0", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
    }

    public DynamicObject getCandidateByNumberAppFileId(String number, Long appFileId) {
        return DataTransService.getInstance().getCandidate(number, appFileId);
    }

    public DynamicObject[] getCandidateByCandidateIds(List<Long> candidateIds) {
        return this.candidateService.getCandidate(candidateIds);
    }

    public boolean isExistCandidateByAppFileId(Long appFileId) {
        return this.candidateService.isExistCandidateByAppFileId(appFileId);
    }

    public Map<String, DynamicObjectCollection> getCandidate(Long id, Map<String, String> entityFields, Long vid) {
        if (id == null || id.equals(0L) || entityFields == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u6548", (String)"HCFService_1", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)entityFields.size());
        for (Map.Entry<String, String> entry : entityFields.entrySet()) {
            String tempKey = entry.getKey();
            HRBaseServiceHelper hRBaseServiceHelper = new HRBaseServiceHelper(tempKey);
            try {
                QFilter[] filters = new QFilter[]{new QFilter(Constants.FIELD_CANDIDATEID, "=", (Object)id)};
                QFilter[] qFilters = this.getAttachedTabFilters(tempKey, filters, vid);
                DynamicObject[] dynamicObject = hRBaseServiceHelper.query(entry.getValue(), qFilters);
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                Collections.addAll(dynamicObjectCollection, dynamicObject);
                result.put(tempKey, dynamicObjectCollection);
            }
            catch (Exception e) {
                LOGGER.error("getCandidate error", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"HCFService_2", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
            }
        }
        return result;
    }

    public Map<Long, Map<String, DynamicObjectCollection>> getCandidateBatch(List<Long> ids, Map<String, String> entityFields) {
        if (CollectionUtils.isEmpty(ids) || CollectionUtils.isEmpty(entityFields)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u65e0\u6548", (String)"HCFService_1", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
        }
        HashMap<Long, Map<String, DynamicObjectCollection>> resultMapOfCandidateId = new HashMap<Long, Map<String, DynamicObjectCollection>>(ids.size());
        try {
            for (Map.Entry<String, String> entity : entityFields.entrySet()) {
                DynamicObject[] dynamicObjects;
                String entityName = entity.getKey();
                HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
                QFilter[] filters = new QFilter[]{new QFilter(Constants.FIELD_CANDIDATEID, "in", ids)};
                QFilter[] qFilters = this.getAttachedTabFilters(entityName, filters, null);
                String fields = entity.getValue();
                if (StringUtils.isEmpty((CharSequence)fields)) {
                    dynamicObjects = helper.loadDynamicObjectArray(qFilters);
                } else {
                    if (!fields.matches("(.*)\\b" + Constants.FIELD_CANDIDATEID + "\\b(.*)")) {
                        fields = fields + "," + Constants.FIELD_CANDIDATEID;
                    }
                    dynamicObjects = helper.query(fields, qFilters);
                }
                Map<Long, List<DynamicObject>> dyMapOfCandidateId = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong(Constants.FIELD_CANDIDATEID)));
                if (CollectionUtils.isEmpty(dyMapOfCandidateId)) continue;
                for (Long id : ids) {
                    DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                    if (dyMapOfCandidateId.get(id) == null) continue;
                    dynamicObjectCollection.addAll((Collection)dyMapOfCandidateId.get(id));
                    HashMap<String, DynamicObjectCollection> result = (HashMap<String, DynamicObjectCollection>)resultMapOfCandidateId.get(id);
                    if (CollectionUtils.isEmpty((Map)result)) {
                        result = new HashMap<String, DynamicObjectCollection>(16);
                        resultMapOfCandidateId.put(id, result);
                    }
                    result.put(entity.getKey(), dynamicObjectCollection);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("getCandidate error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25", (String)"HCFService_2", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
        }
        return resultMapOfCandidateId;
    }

    public Map<String, Object> saveHisMultiRowEntity(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        return this.addTX(() -> {
            LOGGER.info(MessageFormat.format("HCFService.saveHisMultiRowEntity===={0}=", entityNumber));
            this.logCanInfo(entities, "=entities:{0}");
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)3);
            if (HCFServiceValidate.validate((Map)entities, (String)entityNumber, (Map)resultMap)) {
                return resultMap;
            }
            LOGGER.info(MessageFormat.format("HCFService.saveHisMultiRowEntity====saveHisMultiRowEntity==start{0}", entityNumber));
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
            for (Map.Entry entry : entities.entrySet()) {
                Long candidateId = (Long)entry.getKey();
                dynamicObjectList.addAll((Collection)entry.getValue());
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)entry.getValue();
                for (DynamicObject dynamicObject : dynamicObjects) {
                    dynamicObject.set("candidate", (Object)candidateId);
                    if (StringUtils.equals((CharSequence)entityNumber, (CharSequence)dynamicObject.getDataEntityType().getName())) continue;
                    resultMap.put("success", false);
                    resultMap.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u4e2d\u7684\u9875\u9762\u6807\u8bc6\u4e0d\u6b63\u786e\u3002", (String)"HCFService_3", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
                    return resultMap;
                }
            }
            this.doSaveHisMultiRowEntity(entities, entityNumber, resultMap, dynamicObjectList);
            return resultMap;
        });
    }

    private void doSaveHisMultiRowEntity(Map<Long, DynamicObjectCollection> entities, String entityNumber, Map<String, Object> resultMap, List<DynamicObject> dynamicObjectList) {
        try {
            Set<Long> candidateIds = entities.keySet();
            HRBaseServiceHelper currHelper = new HRBaseServiceHelper(entityNumber);
            QFilter[] filters = new QFilter[]{new QFilter("candidate", "in", candidateIds), new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus()), new QFilter("iscurrentversion", "=", (Object)true)};
            Object[] dynamicObjectsDb = currHelper.loadDynamicObjectArray(filters);
            ArrayList dynamicObjectsDBList = Lists.newArrayList((Object[])dynamicObjectsDb);
            for (int j = dynamicObjectsDBList.size() - 1; j >= 0; --j) {
                for (DynamicObject dyToSave : dynamicObjectList) {
                    if (dyToSave.getLong("id") != ((DynamicObject)dynamicObjectsDBList.get(j)).getLong("id")) continue;
                    dynamicObjectsDBList.remove(j);
                }
            }
            if (dynamicObjectsDBList.size() > 0) {
                AttachedTabServiceHelper.deleteDys(dynamicObjectsDBList.stream().map(dynamicObject -> dynamicObject.getLong("boid")).collect(Collectors.toList()), (String)entityNumber);
            }
            if (dynamicObjectList.size() > 0) {
                AttachedTabServiceHelper.updateAttachedTab((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
            }
            resultMap.put("success", true);
        }
        catch (Exception e) {
            resultMap.put("success", false);
            resultMap.put("message", e.getMessage());
        }
    }

    public Map<String, Object> saveHisMultiRowEntityWithoutDelete(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        LOGGER.info(MessageFormat.format("HCFService.saveNewHisMultiRowEntityWithoutDelete===={0}", entityNumber));
        this.logCanInfo(entities, "entity:{0}");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)3);
        try {
            for (Map.Entry<Long, DynamicObjectCollection> collection : entities.entrySet()) {
                DynamicObjectCollection dynamicObjectCollection = collection.getValue();
                long candidateId = collection.getKey();
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    dynamicObject.set("candidate", (Object)candidateId);
                }
                AttachedTabServiceHelper.updateAttachedTab((DynamicObject[])((DynamicObject[])dynamicObjectCollection.toArray((Object[])new DynamicObject[0])));
            }
            resultMap.put("success", true);
        }
        catch (KDBizException kdBizException) {
            resultMap.put("success", false);
            resultMap.put("message", kdBizException.getMessage());
        }
        LOGGER.info("HCFService.saveHisMultiRowEntityWithoutDelete====end");
        return resultMap;
    }

    public DynamicObjectCollection getHisMultiRowEntity(Long id, String entityNumber) {
        HRBaseServiceHelper currHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject[] query = currHelper.loadDynamicObjectArray(this.getAttachedTabFilters(entityNumber, id));
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.addAll(Arrays.asList(query));
        return collection;
    }

    public DynamicObjectCollection getHisMultiRowEntity(Long id, String entityNumber, QFilter[] filters) {
        HRBaseServiceHelper currHelper = new HRBaseServiceHelper(entityNumber);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.addAll(Arrays.asList(filters));
        qFilters.addAll(Arrays.asList(this.getAttachedTabFilters(entityNumber, id)));
        DynamicObject[] queryResult = currHelper.loadDynamicObjectArray(qFilters.toArray(new QFilter[0]));
        DynamicObjectCollection collection = new DynamicObjectCollection();
        Collections.addAll(collection, queryResult);
        return collection;
    }

    public Map<String, Object> saveHisSingleRowEntity(Map<Long, DynamicObject> entities, String entityNumber) {
        if (entities == null || entities.size() == 0) {
            return this.returnMap(false, ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u7684\u6570\u636e\u3002", (String)"HCFService_7", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
        }
        try {
            AttachedTabServiceHelper.updateAttachedTab((DynamicObject[])entities.values().toArray(new DynamicObject[0]));
            return this.returnMap(true, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"HCFService_0", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
        }
        catch (KDBizException kdBizException) {
            return this.returnMap(false, kdBizException.getMessage());
        }
    }

    public DynamicObject getSingleRowEntity(Long id, String entityNumber) {
        HRBaseServiceHelper currHelper = new HRBaseServiceHelper(entityNumber);
        return currHelper.loadDynamicObject(this.getAttachedTabFilters(entityNumber, id));
    }

    public Map<String, Object> saveMultiRowEntity(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        return this.addTX(() -> {
            HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
            HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
            Tuple<Boolean, Map<String, Object>> tuple = this.checkEntityTagAndPageTag(entities, entityNumber, map);
            if (!((Boolean)tuple.item1).booleanValue()) {
                return (Map)tuple.item2;
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
            for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
                Long personId = entry.getKey();
                QFilter candidate = new QFilter("candidate", "=", (Object)personId);
                QFilter ids = new QFilter("id", "not in", map.get(personId));
                hrBaseServiceHelper.deleteByFilter(new QFilter[]{candidate, ids});
            }
            for (Map.Entry<Long, List<Long>> entry : entities.entrySet()) {
                AttachTableUtil.updateTable((Long)entry.getKey(), (DynamicObjectCollection)((DynamicObjectCollection)entry.getValue()));
            }
            returnMap.put("sucess", true);
            returnMap.put("message", ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"HCFService_0", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
            return returnMap;
        });
    }

    public Map<String, Object> saveMultiRowEntityWithoutDelete(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        return this.addTX(() -> {
            Tuple<Boolean, Map<String, Object>> tuple = this.checkEntityTagAndPageTag(entities, entityNumber, new HashMap<Long, List<Long>>(16));
            if (!((Boolean)tuple.item1).booleanValue()) {
                return (Map)tuple.item2;
            }
            for (Map.Entry entry : entities.entrySet()) {
                AttachTableUtil.updateTable((Long)((Long)entry.getKey()), (DynamicObjectCollection)((DynamicObjectCollection)entry.getValue()));
            }
            return this.returnMap(true, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"HCFService_0", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
        });
    }

    private Tuple<Boolean, Map<String, Object>> checkEntityTagAndPageTag(Map<Long, DynamicObjectCollection> entities, String entityNumber, HashMap<Long, List<Long>> map) {
        for (Map.Entry<Long, DynamicObjectCollection> entry : entities.entrySet()) {
            HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
            Long personid = entry.getKey();
            DynamicObjectCollection dynamicObjects = entry.getValue();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                String entityName = dynamicObject.getDataEntityType().getName();
                if (!"".equals(entityNumber) && !entityNumber.equals(entityName)) {
                    returnMap.put("success", false);
                    returnMap.put("message", ResManager.loadKDString((String)"\u8868\u6570\u636e\u6807\u8bc6\u4e0e\u9875\u9762\u6807\u8bc6\u4e0d\u7b26\u3002", (String)"HCFService_5", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
                    return Tuple.create((Object)Boolean.FALSE, returnMap);
                }
                long id = dynamicObject.getLong("id");
                if (id == 0L) continue;
                ids.add(id);
            }
            map.put(personid, ids);
        }
        return Tuple.create((Object)Boolean.TRUE, null);
    }

    public Map<String, Object> deleteById(Long boId, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName) || boId == null || boId.equals(0L)) {
            return this.returnMap(false, "no entityName or id is empty");
        }
        if (NON_HIS_TABLE.contains(entityName)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
            serviceHelper.deleteOne((Object)boId);
        } else {
            AttachedTabServiceHelper.deleteDys((List)Lists.newArrayList((Object[])new Long[]{boId}), (String)entityName);
        }
        return this.returnMap(true, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"HCFService_0", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
    }

    public Map<Long, Map<String, Object>> deleteByIds(Set<Long> boIds, String entityName) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)boIds.size());
        if (NON_HIS_TABLE.contains(entityName)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
            serviceHelper.delete(boIds.toArray());
        } else {
            LOGGER.info("HCFService.deleteByIds.boIds:", boIds);
            LOGGER.info("HCFService.deleteByIds.entityName:", (Object)entityName);
            AttachedTabServiceHelper.deleteDys((List)Lists.newArrayList(boIds), (String)entityName);
        }
        boIds.forEach(id -> returnMap.put(id, this.returnMap(true, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"HCFService_0", (String)"hrmp-hcf-mservice", (Object[])new Object[0]))));
        return returnMap;
    }

    public DynamicObject getById(Long id, String entityName) {
        if (HRStringUtils.isEmpty((String)entityName) || id == null || id == 0L) {
            return null;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        return hrBaseServiceHelper.queryOne((Object)id);
    }

    public Map<String, Object> deleteByIdNoHis(Long id, String entityName) {
        return this.addTX(() -> {
            if (StringUtils.isEmpty((CharSequence)entityName) || id == null || id.equals(0L)) {
                return this.returnMap(false, ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u9519\u8bef\u3002", (String)"HCFService_4", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
            hrBaseServiceHelper.deleteOne((Object)id);
            return this.returnMap(true, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"HCFService_0", (String)"hrmp-hcf-mservice", (Object[])new Object[0]));
        });
    }

    public Long saveCandidate(DynamicObject dy) {
        long candidateId = dy.getLong("id");
        if (candidateId == 0L) {
            candidateId = ORM.create().genLongId("hcf_candidate");
            dy.set("id", (Object)candidateId);
        }
        AttachedTabServiceHelper.executeHisUpdate((DynamicObject[])new DynamicObject[]{dy});
        return candidateId;
    }

    public List<Long> saveCandidates(Set<DynamicObject> dys) {
        if (dys == null || dys.size() == 0) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> candidateIds = new ArrayList<Long>(dys.size());
        for (DynamicObject dy : dys) {
            candidateIds.add(this.saveCandidate(dy));
        }
        return candidateIds;
    }

    public Long geneCandidateInfo(HashMap<String, DynamicObjectCollection> candidateInfo) {
        this.logCanInfo(candidateInfo, "geneCandidateInfoNewHis==begin {0}");
        DynamicObjectCollection candidate = candidateInfo.get("hcf_candidate");
        Long candidateId = this.saveCandidate((DynamicObject)candidate.get(0));
        this.saveCandidateInfo(candidateInfo, candidateId);
        this.logCanInfo(candidateInfo, "geneCandidateInfoNewHis==end {0}");
        return candidateId;
    }

    public void saveCandidateInfo(Map<String, DynamicObjectCollection> candidateInfo, Long candidateId) {
        this.logCanInfo(candidateInfo, "saveCandidateInfoNewHis==begin{0}");
        candidateInfo.forEach((key, value) -> {
            if ("hcf_candidate".equals(key)) {
                return;
            }
            HashMap entities = Maps.newHashMapWithExpectedSize((int)1);
            entities.put(candidateId, value);
            if (NON_HIS_TABLE.contains(key)) {
                this.saveMultiRowEntityWithoutDelete(entities, (String)key);
            } else {
                this.saveHisMultiRowEntityWithoutDelete(entities, (String)key);
            }
        });
    }

    private void logCanInfo(Map entities, String msgTemplate) {
        try {
            entities.forEach((id, dynObjs) -> {
                LOGGER.info(MessageFormat.format("key:{0}", id));
                if (dynObjs instanceof DynamicObjectCollection) {
                    ((DynamicObjectCollection)dynObjs).forEach(dynamicObject -> LOGGER.info(MessageFormat.format(msgTemplate, LogPrivacyUtil.filterPrivacyPropForDynamicObj((DynamicObject)dynamicObject, (List)Lists.newArrayList((Object[])new String[]{"phone", "email", "certificatenumber", "File", "file", "imageData", "phones", "lastname", "firstname", "firstnameen", "lastnameen", "birthdate", "percardname", "PHOTO_JPG", "fileName", "major", "schoolrecord", "degreenumber", "graauthcode", "diplomanumber", "isforeignstudent", "PHOTO_NO", "DOCID", "peremail", "emrgphone", "bankdeposit"})))));
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public List<Map<String, Object>> getEntity(Long candidateId, String entity, String localeId) {
        try {
            ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
            DynamicObject[] objs = AttachTableUtil.getObjs((String)entity, (Long)candidateId);
            Map allFields = AttachTableUtil.getAllBusinessFiledFromEntity((String)entity);
            AttachTableUtil.objs2List((String)localeId, maps, (DynamicObject[])objs, (Map)allFields, (String)"creator,createtime,createtime,modifytime,modifier");
            return maps;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return new ArrayList<Map<String, Object>>();
        }
    }

    public void deleteRowEntity(String entityName, List<Long> candidateIds) {
        if (candidateIds.size() == 0) {
            return;
        }
        this.addTX(() -> {
            try {
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
                if (NON_HIS_TABLE.contains(entityName)) {
                    DynamicObject[] dys = hrBaseServiceHelper.query(new QFilter[]{new QFilter("candidate", "in", (Object)candidateIds)});
                    if (dys.length > 0) {
                        HRBaseServiceHelper currHelper = new HRBaseServiceHelper(entityName);
                        currHelper.delete(Arrays.stream(dys).map(dynamicObject -> dynamicObject.getLong("id")).toArray());
                    }
                } else {
                    DynamicObject[] dys = hrBaseServiceHelper.query("boid", new QFilter[]{new QFilter("candidate", "in", (Object)candidateIds), new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus()), new QFilter("iscurrentversion", "=", (Object)true)});
                    if (dys.length > 0) {
                        AttachedTabServiceHelper.deleteDys(Arrays.stream(dys).map(dynamicObject -> dynamicObject.getLong("boid")).collect(Collectors.toList()), (String)entityName);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("deleteRowEntity info is exception:", (Throwable)exception);
            }
            return null;
        });
    }

    private <T> T addTX(TXOperation<T> TXOperation2) {
        try (TXHandle required = TX.required();){
            T t = TXOperation2.doOption();
            return t;
        }
    }

    private QFilter[] getAttachedTabFilters(String entityName, QFilter[] filters, Long vid) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(Arrays.asList(filters));
        if (!NON_HIS_TABLE.contains(entityName)) {
            if (vid != null && vid != 0L) {
                qFilters.add(new QFilter("id", "=", (Object)vid));
            } else {
                qFilters.add(new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus()));
                qFilters.add(new QFilter("iscurrentversion", "=", (Object)true));
            }
        }
        return qFilters.toArray(new QFilter[0]);
    }

    private QFilter[] getAttachedTabFilters(String entityName, Long candidateId) {
        if (NON_HIS_TABLE.contains(entityName)) {
            return new QFilter[]{new QFilter("candidate", "=", (Object)candidateId)};
        }
        return new QFilter[]{new QFilter("candidate", "=", (Object)candidateId), new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus()), new QFilter("iscurrentversion", "=", (Object)true)};
    }

    private Map<String, Object> returnMap(boolean success, String message) {
        return ImmutableMap.of((Object)"success", (Object)success, (Object)"message", (Object)message);
    }

    public DynamicObject[] queryHcfAttachedData(String hcfEntityName, String hcfProperties, QFilter[] qFilters) {
        if (hcfEntityName.startsWith("hcf")) {
            HRBaseServiceHelper hcfEntityHelper = new HRBaseServiceHelper(hcfEntityName);
            return hcfEntityHelper.query(hcfProperties, qFilters);
        }
        LOGGER.error("No permission of this entity.");
        return new DynamicObject[0];
    }

    public List<Map<String, Object>> getHcfAttachs(Long appfileId) {
        return DataTransService.getInstance().getHcfAttachs(appfileId);
    }

    public Map<String, Object> saveBizCandidate(Map<String, Object> candidate) {
        return this.candidateService.saveBizCandidate(candidate);
    }

    public DynamicObject[] getCandidateAttachs(Long appFileId, String attachId) {
        return DataTransService.getInstance().getCandidateAttachs(appFileId, attachId);
    }

    public void updateCancontactInfo(Long appfileId, String phone, String email) {
        DataTransService.getInstance().updateCancontactInfo(appfileId, phone, email);
    }

    public void updateCancreInfo(Long appfileId, Long typeId, String number) {
        DataTransService.getInstance().updateCancreInfo(appfileId, typeId, number);
    }

    public void updateAttachmentToHcf(Long appfileId, List<Map<String, Object>> attachs) {
        DataTransService.getInstance().updateAttachmentToHcf(appfileId, attachs);
    }

    public DynamicObject getCurrentCanBaseInfoByCandidateId(Long candidateId) {
        return this.candidateService.getCurrentCanBaseInfoByCandidateId(candidateId);
    }

    public void uploadAttachment(Long baseInfoId, DynamicObject attachmentObj) {
        AttachmentHelper.getInstance().uploadAttachment(baseInfoId, attachmentObj);
    }

    private static interface TXOperation<T> {
        public T doOption();
    }
}

