/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hcf.business.attachedtable.servicehelper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.application.newhismodel.IHisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRStringUtils;

public class AttachedTabServiceHelper {
    private static final Log logger = LogFactory.getLog(AttachedTabServiceHelper.class);
    private static final IHisModelController hisModelController = new HisModelController();

    public static void updateAttachedTab(DynamicObject[] dys) {
        logger.info("AttachedTabServiceHelper.updateAttachedTabNewHis====start...");
        if (dys == null || dys.length == 0) {
            return;
        }
        AttachedTabServiceHelper.writeBackName(dys);
        logger.info("AttachedTabServiceHelper.executeHistoryAndInstance====start...");
        AttachedTabServiceHelper.executeHisUpdate(dys);
        logger.info("AttachedTabServiceHelper.updateAttachedTab====end...");
    }

    public static HisResponse<VersionChangeRespData> executeHisUpdate(DynamicObject[] dys) {
        String entityNum = dys[0].getDataEntityType().getName();
        HisVersionParamBo hisVersionParamBo = AttachedTabServiceHelper.buildNoLineTimeHisVersionParamBo(dys, entityNum);
        return hisModelController.noLineTimeHisVersionChange(hisVersionParamBo);
    }

    private static HisVersionParamBo buildNoLineTimeHisVersionParamBo(DynamicObject[] dys, String entityNum) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEffImmediately(true);
        hisVersionParamBo.setOperateType(EnumHisOperateType.NO_TIME_SAVE_VERSION.getType());
        hisVersionParamBo.setEntityNumber(entityNum);
        hisVersionParamBo.setHisDyns(dys);
        return hisVersionParamBo;
    }

    private static void writeBackName(DynamicObject[] canBaseInfosToUpdate) {
        if (null == canBaseInfosToUpdate || canBaseInfosToUpdate.length == 0 || !canBaseInfosToUpdate[0].getDataEntityType().getName().equals("hcf_canbaseinfo")) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, DynamicObject> idDyMap = new HashMap<Long, DynamicObject>(canBaseInfosToUpdate.length, 1.0f);
        for (DynamicObject canBaseInfoToUpdate : canBaseInfosToUpdate) {
            long id = canBaseInfoToUpdate.getLong("boid");
            if (0L == id) continue;
            ids.add(id);
            idDyMap.put(id, canBaseInfoToUpdate);
        }
        if (ids.size() == 0) {
            return;
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        DynamicObject[] dysInDb = new HRBaseServiceHelper(canBaseInfosToUpdate[0].getDataEntityType().getName()).query("name", new QFilter[]{idsFilter});
        DynamicObjectCollection nameChangedCanBaseInfos = new DynamicObjectCollection();
        for (DynamicObject dyInDb : dysInDb) {
            long id = dyInDb.getLong("id");
            DynamicObject dyToUpdate = (DynamicObject)idDyMap.get(id);
            if (HRStringUtils.equals((String)dyInDb.getString("name"), (String)dyToUpdate.getString("name"))) continue;
            nameChangedCanBaseInfos.add((Object)dyToUpdate);
        }
        AttachedTabServiceHelper.syncNameForCandidate(nameChangedCanBaseInfos);
    }

    private static void syncNameForCandidate(DynamicObjectCollection nameChangedCanBaseInfos) {
        if (nameChangedCanBaseInfos == null || nameChangedCanBaseInfos.size() == 0) {
            return;
        }
        ArrayList candidateIds = new ArrayList(nameChangedCanBaseInfos.size());
        HashMap idNameMap = Maps.newHashMapWithExpectedSize((int)nameChangedCanBaseInfos.size());
        nameChangedCanBaseInfos.forEach(nameChangedCanBaseInfo -> {
            long candidateId = nameChangedCanBaseInfo.getDynamicObject("candidate").getLong("id");
            candidateIds.add(candidateId);
            String name = nameChangedCanBaseInfo.getString("name");
            idNameMap.put(candidateId, name);
        });
        QFilter[] idsFilter = new QFilter[]{new QFilter("id", "in", candidateIds)};
        HRBaseServiceHelper candidateServiceHelper = new HRBaseServiceHelper("hcf_candidate");
        DynamicObject[] candidates = candidateServiceHelper.query("name,number,boid", idsFilter);
        if (candidates.length == 0) {
            return;
        }
        DynamicObject[] newCandidates = new DynamicObject[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            newCandidates[i] = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_candidate"));
            long id = candidates[i].getLong("id");
            newCandidates[i].set("name", idNameMap.get(id));
            newCandidates[i].set("number", (Object)candidates[i].getString("number"));
            newCandidates[i].set("boid", (Object)candidates[i].getLong("boid"));
        }
        AttachedTabServiceHelper.executeHisUpdate(newCandidates);
    }

    public static void deleteDys(List<Long> boIds, String entityNum) {
        logger.info("deleteAll start...");
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNum);
        hisBaseBo.setBoIdList(boIds);
        hisModelController.deleteBo(hisBaseBo);
        logger.info("deleteAll end...");
    }
}

