/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hcf.business.attachedtable.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class AttachTableUtil {
    public static void updateTable(Long personid, DynamicObjectCollection dynamicObjects) {
        String entityName = ((DynamicObject)dynamicObjects.get(0)).getDataEntityType().getName();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        DynamicObjectCollection newObj = new DynamicObjectCollection();
        HashMap<Long, Object> idToDy = new HashMap<Long, Object>();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            dynamicObject.set("candidate", (Object)personid);
            Long id = dynamicObject.getLong("id");
            QFilter candidateFilter = new QFilter("candidate", "=", (Object)personid);
            QFilter idFilter = new QFilter("id", "=", (Object)id);
            boolean exists = hrBaseServiceHelper.isExists(new QFilter[]{candidateFilter, idFilter});
            if (!exists) {
                newObj.add(dynamicObjects.get(i));
                continue;
            }
            idToDy.put(id, dynamicObjects.get(i));
            ids.add(id);
        }
        QFilter idsFilter = new QFilter("id", "in", ids);
        String fields = AttachTableUtil.getBusinessField(dynamicObjects);
        DynamicObject[] dbObj = hrBaseServiceHelper.query(fields, new QFilter[]{idsFilter});
        HashSet<String> ignorekeys = new HashSet<String>();
        ignorekeys.add("creator");
        ignorekeys.add("createtime");
        for (int i = 0; i < dbObj.length; ++i) {
            DynamicObject from = (DynamicObject)idToDy.get(dbObj[i].get("id"));
            DynamicObject to = dbObj[i];
            AttachTableUtil.copy(from, to, ignorekeys);
            dbObj[i].set("modifier", (Object)RequestContext.get().getUserId());
            dbObj[i].set("modifytime", (Object)new Date());
        }
        if (newObj.size() != 0) {
            hrBaseServiceHelper.save(newObj);
        } else {
            hrBaseServiceHelper.update(dbObj);
        }
    }

    private static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase(Locale.ROOT));
        }
        for (IDataEntityProperty pro : fromPros) {
            String proName = String.valueOf(pro.getName()).toLowerCase(Locale.ROOT);
            if (ignoreKeys.contains(proName) || !toPsSet.contains(proName)) continue;
            Object value = fromObj.get(proName);
            toObj.set(proName, value);
        }
    }

    public static String getBusinessField(DynamicObjectCollection dynamicObjects) {
        String name = ((DynamicObject)dynamicObjects.get(0)).getDataEntityType().getName();
        String result = AttachTableUtil.getBusinessFieldByEntity(name);
        return result;
    }

    public static String getBusinessFieldByEntity(String name) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)name);
        Map allFields = dataEntityType.getAllFields();
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> ordinaryFields = new ArrayList<String>();
        ordinaryFields.add("creator");
        ordinaryFields.add("createtime");
        for (String field : allFields.keySet()) {
            if (ordinaryFields.contains(field)) continue;
            stringBuilder.append(field.toLowerCase(Locale.ROOT)).append(",");
        }
        return stringBuilder.substring(0, stringBuilder.lastIndexOf(","));
    }

    public static void objs2List(String localeId, ArrayList<Map<String, Object>> maps, DynamicObject[] objs, Map<String, IDataEntityProperty> allFields, String natureFiled) {
        List<String> natureFileds = Arrays.asList(natureFiled.split(","));
        for (int i = 0; i < objs.length; ++i) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("id", String.valueOf(objs[i].getLong("id")));
            for (String filed : allFields.keySet()) {
                if (natureFileds.contains(filed)) continue;
                Object value = objs[i].get(filed);
                if (value instanceof ILocaleString) {
                    map1.put(filed, ((ILocaleString)value).get((Object)localeId));
                    continue;
                }
                if (value instanceof DynamicObject) {
                    map1.put(filed, String.valueOf(((DynamicObject)value).getLong("id")));
                    continue;
                }
                if (value instanceof Long) {
                    map1.put(filed, String.valueOf(value));
                    continue;
                }
                map1.put(filed, value);
            }
            maps.add(map1);
        }
    }

    public static Map<String, IDataEntityProperty> getAllBusinessFiledFromEntity(String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return dataEntityType.getAllFields();
    }

    public static DynamicObject[] getObjs(String entity, Long candidateId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        DynamicObject[] objs = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        return objs;
    }
}

