/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hcf.business.common.service.impl;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hcf.business.attachedtable.servicehelper.AttachedTabServiceHelper;
import kd.hrmp.hcf.business.attachedtable.util.AttachTableUtil;
import kd.hrmp.hcf.business.common.service.ICandidateService;
import kd.hrmp.hcf.business.config.EntityConfigService;
import org.apache.commons.lang3.time.DateUtils;

public class CandidateService
implements ICandidateService {
    private final Log logger = LogFactory.getLog(CandidateService.class);
    private static final String DEFAULT_DATE_PATTERN_TIME = "yyyy-MM-dd HH:mm:ss";
    private static final String CODE_RULE_ENTITY = "hom_candidatenumber";
    HRBaseServiceHelper CANDIDATE_SERVICE = new HRBaseServiceHelper("hcf_candidate");
    HRBaseServiceHelper CANBASEINFO_SERVICE = new HRBaseServiceHelper("hcf_canbaseinfo");

    @Override
    public DynamicObject[] getCandidate(List<Long> candidateIds) {
        return this.CANDIDATE_SERVICE.loadDynamicObjectArray(candidateIds.toArray());
    }

    @Override
    public Map<String, Object> saveBizCandidate(Map<String, Object> candidate) {
        this.logger.info("saveBizCandidate-1> start");
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        Map<String, DynamicObject> entityConfigMap = CandidateService.getEntityConfig();
        this.checkWhiteList(candidate, entityConfigMap);
        Map<String, DynamicObjectCollection> candidateMap = this.getCandidateDynamicObject(candidate, entityConfigMap);
        try (TXHandle required = TX.required();){
            DynamicObjectCollection candidateCollection = candidateMap.get("hcf_candidate");
            DynamicObject dy = (DynamicObject)candidateCollection.get(0);
            Map<String, String> candidateData = this.saveCandidateDynamicObject(dy);
            Long candidateid = Long.parseLong(candidateData.get("id"));
            this.saveCandidateSubDynamicObject(candidateid, candidateMap, entityConfigMap);
            this.logger.info("saveBizCandidate-2> end.");
            returnData.putAll(candidateData);
            HashMap<String, Object> hashMap = returnData;
            return hashMap;
        }
    }

    private static Map<String, DynamicObject> getEntityConfig() {
        DynamicObject[] rows = EntityConfigService.getAllEntityconfig();
        HashMap<String, Object> map = new HashMap<String, DynamicObject>(32);
        if (rows != null) {
            map = new HashMap(rows.length);
            for (DynamicObject row : rows) {
                map.put(row.getString("number"), row);
            }
        }
        return map;
    }

    private void checkWhiteList(Map<String, Object> candidate, Map<String, DynamicObject> entityConfigMap) {
        for (Map.Entry<String, Object> entry : candidate.entrySet()) {
            if (entityConfigMap.containsKey(entry.getKey())) continue;
            throw new KDBizException(entry.getKey() + " invalidate!");
        }
    }

    private Map<String, String> saveCandidateDynamicObject(DynamicObject candidate) {
        DynamicObject[] newDynamicObjects;
        String number;
        HashMap<String, String> returnData = new HashMap<String, String>(3);
        Long candidateId = candidate.getLong("id");
        if (candidateId == 0L) {
            candidateId = ORM.create().genLongId("hcf_candidate");
            candidate.set("id", (Object)candidateId);
        }
        if ((number = candidate.getString("number")) == null || number.trim().length() == 0) {
            String candidateNumber = CodeRuleServiceHelper.getNumber((String)CODE_RULE_ENTITY, (DynamicObject)candidate, null);
            candidate.set("number", (Object)candidateNumber);
        }
        HisResponse<VersionChangeRespData> hisResponse = AttachedTabServiceHelper.executeHisUpdate(new DynamicObject[]{candidate});
        returnData.put("id", String.valueOf(candidateId));
        returnData.put("number", candidate.getString("number"));
        if (hisResponse.getData() != null && (newDynamicObjects = ((VersionChangeRespData)hisResponse.getData()).getNewDynamicObjects()) != null && newDynamicObjects.length > 0) {
            returnData.put("boid", String.valueOf(newDynamicObjects[0].getLong("boid")));
        }
        return returnData;
    }

    private void saveCandidateSubDynamicObject(Long candidateid, Map<String, DynamicObjectCollection> candidateMap, Map<String, DynamicObject> entityConfigMap) {
        candidateMap.forEach((key, value) -> {
            if (!"hcf_candidate".equals(key)) {
                HashMap entities = Maps.newHashMapWithExpectedSize((int)1);
                entities.put(candidateid, value);
                if (((DynamicObject)entityConfigMap.get(key)).getBoolean("ishismodel")) {
                    this.saveHisMultiRowEntityWithoutDelete(entities, (String)key);
                } else {
                    this.saveMultiRowEntityWithoutDelete(entities, (String)key);
                }
            }
        });
    }

    private Map<String, DynamicObjectCollection> getCandidateDynamicObject(Map<String, Object> candidate, Map<String, DynamicObject> entityConfigMap) {
        HashMap<String, DynamicObjectCollection> candidateMap = new HashMap<String, DynamicObjectCollection>(candidate.size());
        for (Map.Entry<String, Object> entry : candidate.entrySet()) {
            String entity = entry.getKey();
            Object data = entry.getValue();
            DynamicObject entityConfig = entityConfigMap.get(entity);
            DynamicObjectCollection collection = new DynamicObjectCollection();
            if (entityConfig.getBoolean("ismultivalue") == Boolean.FALSE.booleanValue()) {
                DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entity);
                Map propertyMap = (Map)data;
                for (Map.Entry propertyEntry : propertyMap.entrySet()) {
                    String key = (String)propertyEntry.getKey();
                    Object value = propertyEntry.getValue();
                    this.validate(dy, key, value);
                    Object targetValue = this.getValue(dy, key, value);
                    dy.set(key, targetValue);
                }
                collection.add((Object)dy);
            } else if (entityConfig.getBoolean("ismultivalue")) {
                List rows = (List)data;
                for (Map row : rows) {
                    DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entity);
                    for (Map.Entry propertyEntry : row.entrySet()) {
                        String key = (String)propertyEntry.getKey();
                        Object value = propertyEntry.getValue();
                        this.validate(dy, key, value);
                        Object targetValue = this.getValue(dy, key, value);
                        dy.set(key, targetValue);
                    }
                    collection.add((Object)dy);
                }
            }
            candidateMap.put(entity, collection);
        }
        return candidateMap;
    }

    private void validate(DynamicObject dy, String key, Object value) {
        IDataEntityType dType = dy.getDataEntityType();
        IDataEntityProperty property = (IDataEntityProperty)dType.getProperties().get((Object)key);
        if (property instanceof MulBasedataProp) {
            if (value instanceof List) {
                List basedataids = (List)value;
                if (basedataids != null) {
                    for (Object basedataid : basedataids) {
                        if (CandidateService.isNumber(basedataid).booleanValue()) continue;
                        this.throwMessage(key);
                    }
                }
            } else {
                this.throwMessage(key);
            }
        } else if (property instanceof BasedataProp) {
            if (!CandidateService.isNumber(value).booleanValue()) {
                this.throwMessage(key);
            }
        } else if (property instanceof DateProp) {
            try {
                DateUtils.parseDate((String)((String)value), (String[])new String[]{DEFAULT_DATE_PATTERN_TIME});
            }
            catch (ParseException e) {
                this.throwMessage(key);
            }
        } else if (property instanceof MuliLangTextProp) {
            if (!CandidateService.isMap(value).booleanValue()) {
                this.throwMessage(key);
            } else {
                Lang[] langs = Lang.values();
                HashSet<String> langSet = new HashSet<String>(40);
                for (Lang lang : langs) {
                    langSet.add(lang.name());
                }
                if (value != null) {
                    Map map = (Map)value;
                    for (Map.Entry entry : map.entrySet()) {
                        String itemValue;
                        if (!langSet.contains(entry.getKey())) {
                            this.throwLangMessage(key, (String)entry.getKey());
                        }
                        if ((itemValue = (String)entry.getValue()) == null) continue;
                        int expectMaxLength = ((MuliLangTextProp)property).getMaxLenth();
                        int actualLength = itemValue.length();
                        if (actualLength <= expectMaxLength) continue;
                        this.throwLengthMessage(key, expectMaxLength);
                    }
                }
            }
        } else if (property instanceof TextProp) {
            if (CandidateService.isNumber(value).booleanValue()) {
                this.throwMessage(key);
            } else if (value != null) {
                int expectMaxLength = ((TextProp)property).getMaxLenth();
                int actualLength = value.toString().length();
                if (actualLength > expectMaxLength) {
                    this.throwLengthMessage(key, expectMaxLength);
                }
            }
        } else if (property instanceof LongProp) {
            if (!CandidateService.isNumber(value).booleanValue()) {
                this.throwMessage(key);
            }
        } else if (property instanceof IntegerProp) {
            if (!CandidateService.isNumber(value).booleanValue()) {
                this.throwMessage(key);
            }
        } else if (property instanceof PictureProp) {
            if (!CandidateService.isString(value).booleanValue()) {
                this.throwMessage(key);
            }
        } else if (property instanceof BooleanProp && !CandidateService.isString(value).booleanValue()) {
            this.throwMessage(key);
        }
    }

    private Object getValue(DynamicObject dy, String key, Object value) {
        Object result = value;
        IDataEntityType dType = dy.getDataEntityType();
        IDataEntityProperty property = (IDataEntityProperty)dType.getProperties().get((Object)key);
        if (property instanceof MulBasedataProp) {
            DynamicObjectCollection collection = new DynamicObjectCollection();
            DynamicObjectType subEntityType = ((MulBasedataProp)property).getDynamicCollectionItemPropertyType();
            List basedataids = (List)value;
            if (basedataids != null) {
                for (Object basedataid : basedataids) {
                    DynamicObject item = new DynamicObject(subEntityType);
                    item.set("fbasedataid", basedataid);
                    collection.add((Object)item);
                }
            }
            result = collection;
        } else if (property instanceof DateProp) {
            try {
                Date date = DateUtils.parseDate((String)((String)value), (String[])new String[]{DEFAULT_DATE_PATTERN_TIME});
                result = date;
            }
            catch (ParseException parseException) {}
        } else if (property instanceof MuliLangTextProp) {
            result = this.getMuliLangValue(key, value);
        }
        return result;
    }

    private LocaleString getMuliLangValue(String key, Object value) {
        Map map = (Map)value;
        LocaleString ls = new LocaleString();
        for (Map.Entry entry : map.entrySet()) {
            ls.setItem((String)entry.getKey(), entry.getValue());
        }
        return ls;
    }

    private void throwMessage(String key) {
        throw new KDBizException("[" + key + "],Data type invalidate,please check!");
    }

    private void throwLangMessage(String key, String lang) {
        throw new KDBizException("[" + key + "],Lang " + lang + " invalidate,please check!");
    }

    private void throwLengthMessage(String key, int length) {
        throw new KDBizException("[" + key + "] too long! expect " + length + "!");
    }

    private void saveMultiRowEntityWithoutDelete(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        this.checkEntityTagAndPageTag(entities, entityNumber);
        for (Map.Entry<Long, DynamicObjectCollection> entry : entities.entrySet()) {
            AttachTableUtil.updateTable(entry.getKey(), entry.getValue());
        }
    }

    private void checkEntityTagAndPageTag(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        for (Map.Entry<Long, DynamicObjectCollection> entry : entities.entrySet()) {
            DynamicObjectCollection dynamicObjects = entry.getValue();
            for (DynamicObject dynamicObject : dynamicObjects) {
                String entityName = dynamicObject.getDataEntityType().getName();
                if ("".equals(entityNumber) || entityNumber.equals(entityName)) continue;
                String message = ResManager.loadKDString((String)"\u8868\u6570\u636e\u6807\u8bc6\u4e0e\u9875\u9762\u6807\u8bc6\u4e0d\u7b26\u3002", (String)"HCFService_5", (String)"hrmp-hcf-mservice", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("hcf.100001", message), new Object[0]);
            }
        }
    }

    private Map<String, Object> saveHisMultiRowEntityWithoutDelete(Map<Long, DynamicObjectCollection> entities, String entityNumber) {
        this.checkEntityTagAndPageTag(entities, entityNumber);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)3);
        try {
            for (Map.Entry<Long, DynamicObjectCollection> collection : entities.entrySet()) {
                DynamicObjectCollection dynamicObjectCollection = collection.getValue();
                long candidateId = collection.getKey();
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    dynamicObject.set("candidate", (Object)candidateId);
                }
                AttachedTabServiceHelper.updateAttachedTab((DynamicObject[])dynamicObjectCollection.toArray((Object[])new DynamicObject[0]));
            }
            resultMap.put("success", true);
        }
        catch (KDBizException kdBizException) {
            resultMap.put("success", false);
            resultMap.put("message", kdBizException.getMessage());
        }
        return resultMap;
    }

    private static Boolean isNumber(Object value) {
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof BigDecimal || value instanceof Float) {
            return true;
        }
        return false;
    }

    private static Boolean isString(Object value) {
        if (value instanceof String) {
            return true;
        }
        return false;
    }

    private static Boolean isMap(Object value) {
        if (value instanceof Map) {
            return true;
        }
        return false;
    }

    @Override
    public DynamicObject getCurrentCanBaseInfoByCandidateId(Long candidateId) {
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return this.CANBASEINFO_SERVICE.queryOne(qFilter.toArray());
    }

    @Override
    public boolean isExistCandidateByAppFileId(Long appFileId) {
        QFilter appFileFilter = new QFilter("appfileid", "=", (Object)appFileId);
        return this.CANDIDATE_SERVICE.isExists(appFileFilter);
    }
}

