/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hcf.business.datatrans;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileNameUtils;
import kd.hrmp.hcf.business.datatrans.AttachmentService;

public class AttachmentHelper {
    private static final Log LOG = LogFactory.getLog(AttachmentHelper.class);
    private final AttachmentService attachmentService = AttachmentService.getInstance();

    public void uploadAttachment(Long baseInfoId, DynamicObject attachmentObj) {
        String attachmentUrl = attachmentObj.getString("ffileid");
        String attachmentName = attachmentObj.getString("attachmentname");
        String fileSize = attachmentObj.getString("attachmentsize");
        String desc = attachmentObj.getString("customfilename");
        this.attachmentService.saveAttachment(baseInfoId, attachmentName, desc, attachmentUrl, fileSize, "hcf_canbaseinfo");
        LOG.info("save attach success");
    }

    private String getFilePathParam(Long offerId, String fileExt) {
        RequestContext requestContext = RequestContext.get();
        return FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)"hcf", (String)"hcf_canbaseinfo", (Object)offerId, (String)fileExt);
    }

    public static AttachmentHelper getInstance() {
        return Instance.INSTANCE;
    }

    public static class Instance {
        private static final AttachmentHelper INSTANCE = new AttachmentHelper();
    }
}

