/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hcf.business.datatrans;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class AttachmentService {
    private static final Log LOG = LogFactory.getLog(AttachmentService.class);

    public void saveAttachment(Object pkId, String fileName, String desc, String url, String fileSize, String formId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_attachment");
        Date today = AttachmentService.nowDateTime();
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        Long attachId = ID.genLongId();
        dynamicObject.set("id", (Object)attachId);
        dynamicObject.set("FNUMBER", (Object)attachId);
        dynamicObject.set("FBillType", (Object)formId);
        dynamicObject.set("FInterID", pkId);
        dynamicObject.set("FModifyTime", (Object)today);
        dynamicObject.set("fcreatetime", (Object)today);
        dynamicObject.set("FaliasFileName", (Object)fileName);
        dynamicObject.set("FAttachmentName", (Object)fileName);
        dynamicObject.set("FExtName", (Object)fileName.substring(fileName.lastIndexOf(46) + 1));
        dynamicObject.set("FATTACHMENTSIZE", (Object)fileSize);
        dynamicObject.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("fattachmentpanel", (Object)"attachmentpanelap");
        dynamicObject.set("fdescription", (Object)(desc == null ? "" : desc));
        dynamicObject.set("FFileId", (Object)url);
        LOG.info("AttachmentService.uploadAttachment fz success");
        serviceHelper.saveOne(dynamicObject);
        LOG.info("AttachmentService.uploadAttachment success");
    }

    public static Date nowDateTime() {
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static AttachmentService getInstance() {
        return Instance.INSTANCE;
    }

    public static class Instance {
        private static final AttachmentService INSTANCE = new AttachmentService();
    }
}

