/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hcf.business.datatrans;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.lang.HZPinyin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hcf.business.attachedtable.servicehelper.AttachedTabServiceHelper;
import kd.hrmp.hcf.business.attachedtable.util.AttachTableUtil;
import kd.hrmp.hcf.business.datatrans.AttachmentService;
import kd.hrmp.hcf.business.datatrans.DataTransCfgServiceHelper;
import kd.hrmp.hcf.business.datatrans.DataTransInfoServiceHelper;
import kd.hrmp.hcf.vo.CandidateKeyPairVO;

public class DataTransService {
    private static final Log LOGGER = LogFactory.getLog(DataTransService.class);
    private HRBaseServiceHelper CANDIDATE_SERVICEHELPER = new HRBaseServiceHelper("hcf_candidate");
    private static String[] HASTIMEPAGE = new String[]{"hcf_canbaseinfo", "hcf_canaddress", "hcf_business", "hcf_cancontact", "hcf_cancontactinfo", "hcf_cancre", "hcf_caneduexp", "hcf_canfamily", "hcf_canlgability", "hcf_canprework", "hcf_canprojectexp", "hcf_cantraining", "hcf_personalarea", "hcf_rsmacdachv", "hcf_rsmawrhon", "hcf_rsmhobby", "hcf_rsminterexp", "hcf_rsmproskl", "hcf_rsmschjob", "hcf_rsmvolexp"};

    private DataTransService() {
    }

    public static DataTransService getInstance() {
        return new DataTransService();
    }

    public Map<String, Object> saveOrUpdateCandidates(Map<String, Object> candidateSyncMap) {
        return this.addTX(() -> {
            LOGGER.info("DataTransService.saveOrUpdateCandidates.candidateSyncMap\uff1a{}", (Object)candidateSyncMap);
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            List dynCollList = (List)candidateSyncMap.get("dynCollList");
            String number = (String)candidateSyncMap.get("number");
            Long appFileId = (Long)candidateSyncMap.get("appFileId");
            String apply = (String)candidateSyncMap.get("apply");
            if (dynCollList == null || dynCollList.size() == 0) {
                result.put("success", false);
                result.put("message", "param error\uff01");
            }
            LOGGER.info("appFile id is {}", (Object)appFileId);
            LOGGER.info("number is {}", (Object)number);
            DynamicObject candidate = this.getCandidate(number, appFileId);
            LOGGER.info("candidate is {}", (Object)candidate);
            if (candidate == null) {
                LOGGER.info("kd.hrmp.hcf.business.datatrans.DataTransService.saveOrUpdateCandidates new candidate");
                candidate = this.generateCandidate(candidateSyncMap);
                AttachedTabServiceHelper.executeHisUpdate(new DynamicObject[]{candidate});
            }
            Long candidateId = candidate.getLong("id");
            List<DynamicObjectCollection> transDynCollList = this.getTransDynColl(candidateId, apply, dynCollList);
            for (DynamicObjectCollection collection : transDynCollList) {
                DynamicObject[] dys = (DynamicObject[])collection.toArray((Object[])new DynamicObject[collection.size()]);
                String pageTo = dys[0].getDataEntityType().getName();
                if (Arrays.asList(HASTIMEPAGE).contains(pageTo)) {
                    AttachedTabServiceHelper.updateAttachedTab(dys);
                } else {
                    this.deleteHisData(candidateId, pageTo);
                    AttachTableUtil.updateTable(candidateId, collection);
                }
                result.put("success", true);
                result.put("message", "success\uff01");
            }
            return result;
        });
    }

    private void deleteHisData(Long candidateId, String entityName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        serviceHelper.deleteByFilter(qFilter.toArray());
    }

    public void updateCancontactInfo(Long appfileId, String phone, String email) {
        DynamicObject candidate = this.getCandidate(null, appfileId);
        if (candidate == null) {
            return;
        }
        Long candidateId = candidate.getLong("id");
        HRBaseServiceHelper contactServiceHelper = new HRBaseServiceHelper("hcf_cancontactinfo");
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject dyn = contactServiceHelper.loadDynamicObject(qFilter.toArray());
        DynamicObject newdyn = contactServiceHelper.generateEmptyDynamicObject();
        if (dyn != null) {
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)newdyn);
            newdyn.set("id", (Object)ID.genLongId());
            if (HRStringUtils.isNotEmpty((String)phone)) {
                newdyn.set("phone", (Object)phone);
            }
            if (HRStringUtils.isNotEmpty((String)email)) {
                newdyn.set("peremail", (Object)email);
            }
        } else {
            newdyn.set("id", (Object)ID.genLongId());
            newdyn.set("candidate", (Object)candidateId);
            newdyn.set("phone", (Object)phone);
            newdyn.set("peremail", (Object)email);
        }
        DynamicObject[] newdyns = new DynamicObject[]{newdyn};
        AttachedTabServiceHelper.updateAttachedTab(newdyns);
    }

    public void updateCancreInfo(Long appfileId, Long typeId, String number) {
        DynamicObject candidate = this.getCandidate(null, appfileId);
        if (candidate == null) {
            return;
        }
        Long candidateId = candidate.getLong("id");
        HRBaseServiceHelper cancreServiceHelper = new HRBaseServiceHelper("hcf_cancre");
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        qFilter.and(new QFilter("credentialstype.id", "=", (Object)typeId));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject dyn = cancreServiceHelper.loadDynamicObject(qFilter.toArray());
        DynamicObject newdyn = cancreServiceHelper.generateEmptyDynamicObject();
        if (dyn != null) {
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)newdyn);
            newdyn.set("id", (Object)ID.genLongId());
            newdyn.set("number", (Object)number);
        } else {
            newdyn.set("id", (Object)ID.genLongId());
            newdyn.set("candidate", (Object)candidateId);
            newdyn.set("credentialstype", (Object)typeId);
            newdyn.set("number", (Object)number);
        }
        DynamicObject[] newdyns = new DynamicObject[]{newdyn};
        AttachedTabServiceHelper.updateAttachedTab(newdyns);
    }

    public void updateAttachmentToHcf(Long appfileId, List<Map<String, Object>> attachs) {
        DynamicObject candidate = this.getCandidate(null, appfileId);
        if (candidate == null) {
            return;
        }
        Long candidateId = candidate.getLong("id");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcf_canbaseinfo");
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject baseInfoDyn = serviceHelper.queryOne(qFilter.toArray());
        AttachmentServiceHelper.remove((String)"hcf_canbaseinfo", (Object)baseInfoDyn.getPkValue());
        LOGGER.info("updateAttachmentToHcf fz pkid: {}", baseInfoDyn.getPkValue());
        LOGGER.info("updateAttachmentToHcf fz attachs: {}", attachs);
        for (Map<String, Object> attach : attachs) {
            DynamicObject attachmentObj = AttachmentServiceHelper.getAttCreatorByUID((String)attach.get("uid").toString());
            AttachmentService.getInstance().saveAttachment(baseInfoDyn.getPkValue(), String.valueOf(attach.get("name")), attachmentObj.getString("fdescription"), attachmentObj.getString("ffileid"), String.valueOf(attach.get("size")), "hcf_canbaseinfo");
        }
    }

    public List<Map<String, Object>> getHcfAttachs(Long appfileId) {
        DynamicObject candidate = this.getCandidate(null, appfileId);
        if (candidate == null) {
            return null;
        }
        Long candidateId = candidate.getLong("id");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcf_canbaseinfo");
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject baseInfoDyn = serviceHelper.queryOne(qFilter.toArray());
        return AttachmentServiceHelper.getAttachments((String)"hcf_canbaseinfo", (Object)baseInfoDyn.getPkValue(), (String)"attachmentpanelap", (boolean)false);
    }

    public DynamicObject getCandidate(String number, Long appFileId) {
        QFilter qFilter;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcf_candidate");
        if (!HRStringUtils.isEmpty((String)number)) {
            qFilter = new QFilter("number", "=", (Object)number);
        } else if (!appFileId.equals(0L)) {
            qFilter = new QFilter("appfileid", "=", (Object)appFileId);
        } else {
            return null;
        }
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return serviceHelper.loadDynamicObject(qFilter);
    }

    public DynamicObject[] getCandidateAttachs(Long appFileId, String attachId) {
        DynamicObject candidate = this.getCandidate(null, appFileId);
        if (candidate == null) {
            return null;
        }
        Long candidateId = candidate.getLong("id");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(attachId);
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    private DynamicObject generateCandidate(Map<String, Object> candidateSyncMap) {
        String number = (String)candidateSyncMap.get("number");
        String name = (String)candidateSyncMap.get("name");
        String billNo = (String)candidateSyncMap.get("billNo");
        Long appFileId = (Long)candidateSyncMap.get("appFileId");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcf_candidate");
        DynamicObject candidate = serviceHelper.generateEmptyDynamicObject();
        Long candidateId = ORM.create().genLongId("hcf_candidate");
        candidate.set("id", (Object)candidateId);
        candidate.set("name", (Object)name);
        candidate.set("number", (Object)number);
        candidate.set("entrynumber", (Object)billNo);
        candidate.set("datasource", (Object)"0");
        candidate.set("appfileid", (Object)appFileId);
        return candidate;
    }

    private List<DynamicObjectCollection> getTransDynColl(Long candidateId, String apply, List<DynamicObjectCollection> dynCollList) {
        List<CandidateKeyPairVO> keyPairVOList = this.getTransPageKeyPairVOList(apply);
        ArrayList result = Lists.newArrayListWithCapacity((int)dynCollList.size());
        for (DynamicObjectCollection dynColl : dynCollList) {
            if (dynColl.size() == 0) continue;
            String entityName = ((DynamicObject)dynColl.get(0)).getDataEntityType().getName();
            for (CandidateKeyPairVO candidateKeyPairVO : keyPairVOList) {
                String pageFrom = candidateKeyPairVO.getPageFrom();
                if (!HRStringUtils.equals((String)pageFrom, (String)entityName)) continue;
                DynamicObjectCollection collection = this.generateDynamicObjectColl(candidateId, dynColl, candidateKeyPairVO);
                result.add(collection);
            }
        }
        return result;
    }

    private DynamicObjectCollection generateDynamicObjectColl(Long candidateId, DynamicObjectCollection dynColl, CandidateKeyPairVO candidateKeyPairVO) {
        String pageTo = candidateKeyPairVO.getPageTo();
        Map keyPair = candidateKeyPairVO.getKeyPair();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (DynamicObject dyn : dynColl) {
            if ("tstpm_srrsm".equals(candidateKeyPairVO.getPageFrom()) && "hcf_cancre".equals(pageTo)) continue;
            String[] hasTimePages = HASTIMEPAGE;
            if (Arrays.asList(hasTimePages).contains(pageTo)) {
                DataTransInfoServiceHelper.updateContactByCandidateId(candidateId, pageTo);
            }
            DynamicObject toDyn = this.CANDIDATE_SERVICEHELPER.generateEmptyDynamicObject(pageTo);
            HashSet unCopys = null;
            ArrayList<String> fromPages = new ArrayList<String>(3);
            fromPages.add("tstpm_srscarfmrsmworkexp");
            fromPages.add("tstpm_srrsmworkexp");
            if (fromPages.contains(candidateKeyPairVO.getPageFrom()) && "hcf_canprework".equals(pageTo)) {
                unCopys = Sets.newHashSet();
                unCopys.add("companysize");
            }
            if ("tstpm_arfrsm".equals(candidateKeyPairVO.getPageFrom()) && "hcf_canbaseinfo".equals(candidateKeyPairVO.getPageTo())) {
                this.updateCanaddress(candidateId, dyn.getString("rgstprmtrsdtxt"));
            }
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)toDyn, (Set)unCopys, (Map)keyPair);
            toDyn.set("candidate", (Object)candidateId);
            this.syncArfHandle(dyn, toDyn, candidateKeyPairVO);
            collection.add((Object)toDyn);
        }
        return collection;
    }

    private void syncArfHandle(DynamicObject dyn, DynamicObject toDyn, CandidateKeyPairVO candidateKeyPairVO) {
        if ("hcf_canbaseinfo".equals(candidateKeyPairVO.getPageTo())) {
            String name = toDyn.getString("name");
            String nameen = "";
            try {
                nameen = HZPinyin.getFullSpell((String)name);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("DataTransService.syncArfHandle converterToSpell error name : {}", (Object)name, (Object)e);
            }
            LOGGER.info("DataTransService.syncArfHandle name : {} nameen : {}", (Object)name, (Object)nameen);
            toDyn.set("nameen", (Object)nameen);
        }
        if ("tstpm_arfrsm".equals(candidateKeyPairVO.getPageFrom()) && "hcf_canbaseinfo".equals(candidateKeyPairVO.getPageTo())) {
            toDyn.set("nativeplace", (Object)dyn.getString("nativeplacetxt"));
            if (dyn.getBigDecimal("workingyears") != null) {
                BigDecimal base = new BigDecimal(12);
                toDyn.set("workseniority", (Object)dyn.getBigDecimal("workingyears").divide(base, 2, 4));
            }
            if (dyn.get("gender") != null) {
                toDyn.set("gender", (Object)dyn.getDynamicObject("gender"));
            }
        } else if ("tstpm_srscarfmrsmworkexp".equals(candidateKeyPairVO.getPageFrom())) {
            if (dyn.get("companynature") != null) {
                toDyn.set("businesstype", (Object)dyn.getLong("companynature.id"));
            }
            if (HRStringUtils.isNotEmpty((String)dyn.getString("underlingnumbertxt"))) {
                toDyn.set("subordinates", (Object)dyn.getString("underlingnumbertxt"));
            }
        } else if ("tstpm_srscarfmrsminterexp".equals(candidateKeyPairVO.getPageFrom())) {
            toDyn.set("location", (Object)dyn.getString("workaddress"));
        } else if ("tstpm_srscarfmcertificate".equals(candidateKeyPairVO.getPageFrom()) && "hcf_cancre".equals(candidateKeyPairVO.getPageTo())) {
            toDyn.set("ismajor", (Object)"1");
        }
    }

    private List<CandidateKeyPairVO> getTransPageKeyPairVOList(String apply) {
        DynamicObject[] configs = DataTransCfgServiceHelper.getConfigs(apply);
        ArrayList keyPairList = Lists.newArrayListWithExpectedSize((int)configs.length);
        for (DynamicObject config : configs) {
            String pageFromNumber = config.getString("pagefrom.number");
            String pageToNumber = config.getString("pageto.number");
            DynamicObjectCollection entryentity = config.getDynamicObjectCollection("entryentity");
            HashMap keyMap = Maps.newHashMapWithExpectedSize((int)entryentity.size());
            for (DynamicObject dynamicObject : entryentity) {
                String keyfrom = dynamicObject.getString("keyfrom");
                String keyto = dynamicObject.getString("keyto");
                keyMap.put(keyfrom, keyto);
            }
            keyPairList.add(new CandidateKeyPairVO(pageFromNumber, pageToNumber, (Map)keyMap));
        }
        return keyPairList;
    }

    public void updateCanaddress(Long candidateId, String location) {
        if (HRStringUtils.isEmpty((String)location)) {
            return;
        }
        HRBaseServiceHelper adrServiceHelper = new HRBaseServiceHelper("hcf_canaddress");
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        qFilter.and(new QFilter("addresstype.id", "=", (Object)1020));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject dyn = adrServiceHelper.loadDynamicObject(qFilter.toArray());
        DynamicObject newdyn = adrServiceHelper.generateEmptyDynamicObject();
        if (dyn != null) {
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)newdyn);
            newdyn.set("id", (Object)ID.genLongId());
            newdyn.set("addressinfo", (Object)location);
        } else {
            newdyn.set("id", (Object)ID.genLongId());
            newdyn.set("candidate", (Object)candidateId);
            newdyn.set("addresstype", (Object)1020);
            newdyn.set("addressinfo", (Object)location);
        }
        DynamicObject[] newdyns = new DynamicObject[]{newdyn};
        AttachedTabServiceHelper.updateAttachedTab(newdyns);
    }

    private <T> T addTX(TXOperation<T> TXOperation2) {
        try (TXHandle required = TX.required();){
            T t = TXOperation2.doOption();
            return t;
        }
    }

    private static interface TXOperation<T> {
        public T doOption();
    }
}

