/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hies.entry.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.ext.hr.metadata.edit.QueryEdit;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TimeRangeEdit;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.hr.hies.common.util.MethodUtil;
import kd.hrmp.hies.entry.business.template.EntryExcelGenerateHelper;
import kd.hrmp.hies.entry.common.HiesEntryRes;
import kd.hrmp.hies.entry.common.dto.FieldHeaderWriterFormat;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class ExportEntryDataHelper {
    private static final Log LOGGER = LogFactory.getLog(ExportEntryDataHelper.class);

    public static String getEntryKey(Map<String, Object> customParams) {
        String operateKey = (String)customParams.get("hr_entryId");
        if (StringUtils.isEmpty((CharSequence)operateKey)) {
            return null;
        }
        String formId = (String)customParams.get("formId");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        EntityItem itemById = entityMetadata.getItemById(operateKey);
        return itemById.getKey();
    }

    public static DynamicObject getSysparam() {
        QFilter[] qFilters = null;
        DynamicObject sysparam = BusinessDataServiceHelper.loadSingle((String)"hies_diaesysparam", qFilters);
        return sysparam;
    }

    public static boolean isBDType(IDataEntityProperty field) {
        return field instanceof MulBasedataProp || field instanceof BasedataProp;
    }

    private static void getFieldCation(List<KeyValue> captions, AtomicInteger columnIndex, IFormView view, Control control, String baseinfoformat) {
        if (control instanceof BasedataPropEdit) {
            return;
        }
        if (ObjectUtils.isEmpty((Object)control)) {
            LOGGER.error("ControlAp_is_null,getFieldCation_columnIndex=" + columnIndex.get());
            return;
        }
        FieldEdit fieldEdit = (FieldEdit)control;
        IDataEntityProperty field = fieldEdit.getProperty();
        if (ExportEntryDataHelper.isBDType(field)) {
            Map<String, Map<String, String>> basedataProps = ExportEntryDataHelper.prepareBasedataProps(control, baseinfoformat);
            int index = 0;
            for (Map<String, String> item : basedataProps.values()) {
                String display = item.get("text");
                boolean mustInput = ExportEntryDataHelper.isMustInput(field);
                FieldHeaderWriterFormat format = new FieldHeaderWriterFormat();
                format.setProp(field);
                format.setMustInput(mustInput && index == 0);
                if (format.isMustInput()) {
                    display = "*" + display;
                }
                KeyValue keyValue = new KeyValue(item.get("name"), (Object)display, new Object[]{format}, Integer.valueOf(columnIndex.incrementAndGet()));
                captions.add(keyValue);
                ++index;
            }
        } else if (control instanceof DateRangeEdit) {
            DateRangeEdit dr = (DateRangeEdit)control;
            IDataEntityProperty property1 = view.getModel().getProperty(dr.getStartDateFieldKey());
            if (property1 == null) {
                return;
            }
            FieldHeaderWriterFormat format1 = new FieldHeaderWriterFormat();
            format1.setMustInput(ExportEntryDataHelper.isMustInput(property1));
            format1.setProp(property1);
            KeyValue keyValue = new KeyValue(dr.getStartDateFieldKey(), (Object)ExportEntryDataHelper.getFinallyFieldName(property1, property1.getDisplayName().getLocaleValue(), false), new Object[]{format1}, Integer.valueOf(columnIndex.incrementAndGet()));
            captions.add(keyValue);
            IDataEntityProperty property2 = view.getModel().getProperty(dr.getEndDateFieldKey());
            if (property2 == null) {
                return;
            }
            FieldHeaderWriterFormat format2 = new FieldHeaderWriterFormat();
            format2.setMustInput(ExportEntryDataHelper.isMustInput(property2));
            format2.setProp(property2);
            keyValue = new KeyValue(dr.getEndDateFieldKey(), (Object)ExportEntryDataHelper.getFinallyFieldName(property2, property2.getDisplayName().getLocaleValue(), false), new Object[]{format2}, Integer.valueOf(columnIndex.incrementAndGet()));
            captions.add(keyValue);
        } else if (control instanceof TimeRangeEdit) {
            TimeRangeEdit dr = (TimeRangeEdit)control;
            IDataEntityProperty property1 = view.getModel().getProperty(dr.getStartDateFieldKey());
            if (property1 == null) {
                return;
            }
            FieldHeaderWriterFormat format1 = new FieldHeaderWriterFormat();
            format1.setMustInput(ExportEntryDataHelper.isMustInput(property1));
            format1.setProp(property1);
            KeyValue keyValue = new KeyValue(dr.getStartDateFieldKey(), (Object)ExportEntryDataHelper.getFinallyFieldName(property1, property1.getDisplayName().getLocaleValue(), false), new Object[]{format1}, Integer.valueOf(columnIndex.incrementAndGet()));
            captions.add(keyValue);
            IDataEntityProperty property2 = view.getModel().getProperty(dr.getEndDateFieldKey());
            if (property2 == null) {
                return;
            }
            FieldHeaderWriterFormat format2 = new FieldHeaderWriterFormat();
            format2.setMustInput(ExportEntryDataHelper.isMustInput(property2));
            format2.setProp(property2);
            keyValue = new KeyValue(dr.getEndDateFieldKey(), (Object)ExportEntryDataHelper.getFinallyFieldName(property2, property2.getDisplayName().getLocaleValue(), false), new Object[]{format2}, Integer.valueOf(columnIndex.incrementAndGet()));
            captions.add(keyValue);
        } else if (field instanceof LargeTextProp) {
            FieldHeaderWriterFormat format1 = new FieldHeaderWriterFormat();
            format1.setMustInput(ExportEntryDataHelper.isMustInput(field));
            format1.setProp(field);
            KeyValue keyValue = new KeyValue(control.getKey(), (Object)ExportEntryDataHelper.getFinallyFieldName(field, field.getDisplayName().getLocaleValue(), false), new Object[]{format1}, Integer.valueOf(columnIndex.incrementAndGet()));
            captions.add(keyValue);
            IDataEntityProperty property1 = (IDataEntityProperty)field.getParent().getProperties().get((Object)(control.getKey() + "_tag"));
            FieldHeaderWriterFormat format2 = new FieldHeaderWriterFormat();
            format2.setMustInput(ExportEntryDataHelper.isMustInput(field));
            format2.setProp(field);
            keyValue = new KeyValue(control.getKey() + "_tag", (Object)ExportEntryDataHelper.getFinallyFieldName(field, property1.getDisplayName().getLocaleValue(), false), new Object[]{format2}, Integer.valueOf(columnIndex.incrementAndGet()));
            captions.add(keyValue);
        } else if (field instanceof MuliLangTextProp) {
            IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
            List enableLangs = service.getMultiLangEnabledLang();
            ArrayList<String> items = new ArrayList<String>(enableLangs.size());
            String currLang = RequestContext.getOrCreate().getLang().name();
            HashMap langMap = Maps.newHashMapWithExpectedSize((int)3);
            for (EnabledLang lang : enableLangs) {
                if (lang.number.equals(currLang)) {
                    items.add(0, field.getName() + "." + lang.number);
                } else {
                    items.add(field.getName() + "." + lang.number);
                }
                langMap.put(field.getName() + "." + lang.number, lang.name);
            }
            int index = 0;
            for (String item : items) {
                FieldHeaderWriterFormat format = new FieldHeaderWriterFormat();
                format.setProp(field);
                format.setMustInput(ExportEntryDataHelper.isMustInput(field) && index == 0);
                KeyValue keyValue = new KeyValue(item, (Object)ExportEntryDataHelper.getFinallyFieldName(field, field.getDisplayName().getLocaleValue() + "." + (String)langMap.get(item), index == 0), new Object[]{format}, Integer.valueOf(columnIndex.incrementAndGet()));
                captions.add(keyValue);
                ++index;
            }
        } else {
            if (field == null) {
                return;
            }
            FieldHeaderWriterFormat format = new FieldHeaderWriterFormat();
            format.setMustInput(ExportEntryDataHelper.isMustInput(field));
            format.setProp(field);
            KeyValue keyValue = new KeyValue(control.getKey(), (Object)ExportEntryDataHelper.getFinallyFieldName(field, field.getDisplayName().getLocaleValue(), false), new Object[]{format}, Integer.valueOf(columnIndex.incrementAndGet()));
            captions.add(keyValue);
        }
    }

    public static Map<String, Map<String, String>> prepareBasedataProps(Control control, String baseinfoformat) {
        String text;
        IDataEntityProperty refprop;
        String numberField;
        String nameField;
        LinkedHashMap ret = Maps.newLinkedHashMapWithExpectedSize((int)2);
        String imptPropName = "";
        String imptPropNumber = "";
        String imptPropId = "";
        String imptProp = "";
        boolean isHrQueryBd = false;
        BasedataEdit bd = (BasedataEdit)control;
        IDataEntityProperty prop = bd.getProperty();
        BasedataEntityType refPropType = (BasedataEntityType)((IBasedataField)prop).getComplexType();
        DataEntityPropertyCollection properties = refPropType.getProperties();
        if (control instanceof QueryEdit) {
            isHrQueryBd = true;
            nameField = "name";
            numberField = "number";
        } else {
            nameField = refPropType.getNameProperty();
            numberField = refPropType.getNumberProperty();
            if (StringUtils.isEmpty((CharSequence)nameField) && StringUtils.isEmpty((CharSequence)numberField)) {
                baseinfoformat = "id";
            }
        }
        switch (baseinfoformat) {
            case "number": {
                imptPropNumber = numberField;
                if (numberField.equalsIgnoreCase(nameField)) break;
                imptPropName = nameField;
                break;
            }
            case "name": {
                imptPropName = nameField;
                break;
            }
            case "number_name": {
                imptProp = "number_name";
                break;
            }
            case "id": {
                imptPropId = "id";
                break;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)imptPropNumber)) {
            refprop = (IDataEntityProperty)properties.get((Object)imptPropNumber);
            Map attr = ret.computeIfAbsent("number", val -> new HashMap(6));
            attr.put("name", control.getKey() + "." + imptPropNumber);
            text = ExportEntryDataHelper.getDisplayName(refprop);
            if (isHrQueryBd) {
                text = ResManager.loadKDString((String)"\u5de5\u53f7", (String)HiesEntryRes.ExportEntryDataHelper_5.resId(), (String)"hrmp-hies-import", (Object[])new Object[0]);
            }
            attr.put("text", bd.getProperty().getDisplayName().getLocaleValue() + '.' + text);
            ret.put("number", attr);
        }
        if (StringUtils.isNotEmpty((CharSequence)imptPropName)) {
            refprop = (IDataEntityProperty)properties.get((Object)imptPropName);
            Map attr = ret.computeIfAbsent("name", val -> new HashMap(6));
            attr.put("name", control.getKey() + "." + imptPropName);
            text = ExportEntryDataHelper.getDisplayName(refprop);
            if (isHrQueryBd) {
                text = ResManager.loadKDString((String)"\u59d3\u540d", (String)HiesEntryRes.ExportEntryDataHelper_1.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
            }
            attr.put("text", bd.getProperty().getDisplayName().getLocaleValue() + '.' + text);
            ret.put("name", attr);
        }
        if (StringUtils.isNotEmpty((CharSequence)imptProp)) {
            HashMap attr = Maps.newHashMapWithExpectedSize((int)2);
            attr.put("name", control.getKey());
            attr.put("text", bd.getProperty().getDisplayName().getLocaleValue());
            ret.put("number_name", attr);
        }
        if (StringUtils.isNotEmpty((CharSequence)imptPropId)) {
            refprop = (IDataEntityProperty)properties.get((Object)"id");
            Map attr = ret.computeIfAbsent("id", val -> new HashMap(6));
            attr.put("name", prop.getName() + '.' + imptPropId);
            attr.put("text", refprop != null ? ExportEntryDataHelper.getDisplayName(prop) + ExportEntryDataHelper.getDisplayName(refprop) : imptPropId);
            ret.put("id", attr);
        }
        return ret;
    }

    private static String getControlDisplayName(Control control) {
        FieldEdit dd = (FieldEdit)control;
        return dd.getProperty().getDisplayName().getLocaleValue();
    }

    private static String getDisplayName(IDataEntityProperty prop) {
        if (prop == null) {
            return "";
        }
        LocaleString displayName = prop.getDisplayName();
        if (displayName == null) {
            return prop.getName();
        }
        return displayName.toString();
    }

    private static boolean isMustInput(IDataEntityProperty field) {
        boolean result;
        if (field == null) {
            return false;
        }
        if (field instanceof MulBasedataProp) {
            MulBasedataProp fieldProp = (MulBasedataProp)field;
            result = fieldProp.isMustInput();
        } else if (field instanceof BasedataProp) {
            BasedataProp fieldProp = (BasedataProp)field;
            result = fieldProp.isMustInput();
        } else if (field instanceof RefBillProp) {
            RefBillProp fieldProp = (RefBillProp)field;
            result = fieldProp.isMustInput();
        } else {
            FieldProp fieldProp = (FieldProp)field;
            result = fieldProp.isMustInput();
        }
        return result;
    }

    private static String getFinallyFieldName(IDataEntityProperty field, String name, boolean isCurrentLang) {
        if (ExportEntryDataHelper.isMustInput(field)) {
            if (field instanceof MuliLangTextProp && !isCurrentLang) {
                return name;
            }
            return "*" + name;
        }
        return name;
    }

    public static String getEntryName(String entryKey, IDataModel dataModel) {
        LocaleString caption = dataModel.getProperty(entryKey).getDisplayName();
        if (caption != null) {
            return StringUtils.isEmpty((CharSequence)caption.toString()) ? entryKey : caption.getLocaleValue();
        }
        return ResManager.loadKDString((String)"\u65e0\u5355\u636e\u4f53\u540d\u79f0\u3002", (String)HiesEntryRes.ExportEntryDataHelper_6.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]);
    }

    public static List<KeyValue> getExpHeader(Map<String, Object> params, IFormView view, String defaultBaseinfoformat, Map<String, String> f7formatCfg) {
        String formId = (String)params.get("formId");
        String entryKey = ExportEntryDataHelper.getEntryKey(params);
        return ExportEntryDataHelper.initCaptions(entryKey, view, ExportEntryDataHelper.getSettingFieldInfo(view, entryKey), defaultBaseinfoformat, f7formatCfg);
    }

    private static List<KeyValue> initCaptions(String entryKey, IFormView view, Map fieldMap, String defaultBaseinfoformat, Map<String, String> f7formatCfg) {
        ArrayList<KeyValue> captions = new ArrayList<KeyValue>();
        AtomicInteger columnIndex = new AtomicInteger(-1);
        FieldHeaderWriterFormat idFormat = new FieldHeaderWriterFormat();
        StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"1.\u5185\u7801\u662f\u5339\u914d\u5355\u636e\u4f53\u6216\u5b50\u5355\u636e\u4f53\u7684\u552f\u4e00\u6807\u8bc6\uff0c\u7528\u4e8e\u786e\u5b9a\u6570\u636e\u7684\u552f\u4e00\u6027\uff1b", (String)HiesEntryRes.ExportEntryDataHelper_0.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
        builder.append('\n');
        builder.append(ResManager.loadKDString((String)"2.\u5982\u9700\u66f4\u65b0\u5206\u5f55\u4fe1\u606f\uff0c\u8bf7\u586b\u5199\u5185\u7801\uff1b\u65b0\u589e\u5206\u5f55\uff0c\u65e0\u9700\u586b\u5199\uff1b", (String)HiesEntryRes.ExportEntryDataHelper_3.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
        builder.append('\n');
        builder.append(ResManager.loadKDString((String)"3.\u83b7\u53d6\u5185\u7801\u65b9\u5f0f\uff1a\u4f7f\u7528\u201c\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u201d\uff0c\u5219\u53ef\u5bfc\u51fa\u5206\u5f55\u7684\u5185\u7801\u3002", (String)HiesEntryRes.ExportEntryDataHelper_4.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]));
        idFormat.setComment(builder.toString());
        KeyValue primaryKV = new KeyValue(entryKey + "_id", (Object)ResManager.loadKDString((String)"\u5185\u7801", (String)HiesEntryRes.ExportEntryDataHelper_2.resId(), (String)"hrmp-hies-entry", (Object[])new Object[0]), new Object[]{idFormat}, Integer.valueOf(columnIndex.incrementAndGet()));
        captions.add(primaryKV);
        JSONArray cwgNames = (JSONArray)fieldMap.get("cwg");
        if (cwgNames == null) {
            return captions;
        }
        for (Object cwgName : cwgNames) {
            JSONObject cwgNameJsonObject = (JSONObject)cwgName;
            String colId = cwgNameJsonObject.getString("colId");
            Object children = cwgNameJsonObject.get((Object)"children");
            if (children != null) {
                ExportEntryDataHelper.dealChildCaptions(view, defaultBaseinfoformat, f7formatCfg, captions, columnIndex, cwgNameJsonObject);
                continue;
            }
            Control control = view.getControl(colId);
            if (ObjectUtils.isEmpty((Object)control)) {
                LOGGER.error("ControlAp_is_null,getFieldCation_columnIndex=" + columnIndex.get());
                continue;
            }
            if (control.isInvisible()) continue;
            String baseinfoformat = f7formatCfg.getOrDefault(colId, defaultBaseinfoformat);
            ExportEntryDataHelper.getFieldCation(captions, columnIndex, view, control, baseinfoformat);
        }
        return captions;
    }

    private static void dealChildCaptions(IFormView view, String defaultBaseinfoformat, Map<String, String> f7formatCfg, List<KeyValue> captions, AtomicInteger columnIndex, JSONObject cwgNameJsonObject) {
        String colId = cwgNameJsonObject.getString("colId");
        String name = cwgNameJsonObject.getString("name");
        JSONArray children = (JSONArray)cwgNameJsonObject.get((Object)"children");
        ArrayList subCaptions = Lists.newArrayListWithExpectedSize((int)16);
        int index = columnIndex.incrementAndGet();
        KeyValue kv = new KeyValue(colId, (Object)new KeyValue(name, (Object)subCaptions, Integer.valueOf(index)), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(index));
        captions.add(kv);
        columnIndex.decrementAndGet();
        for (Object item : children) {
            JSONObject childJson = (JSONObject)item;
            String colId2 = childJson.getString("colId");
            Control control = view.getControl(colId2);
            if (ObjectUtils.isEmpty((Object)control)) {
                LOGGER.error("ControlAp_is_null,getFieldCation_columnIndex=" + columnIndex.get());
                continue;
            }
            if (control.isInvisible()) continue;
            Object nextLevelChildren = childJson.get((Object)"children");
            if (nextLevelChildren != null) {
                ExportEntryDataHelper.dealChildCaptions(view, defaultBaseinfoformat, f7formatCfg, subCaptions, columnIndex, childJson);
                continue;
            }
            String baseinfoformat = f7formatCfg.getOrDefault(colId2, defaultBaseinfoformat);
            ExportEntryDataHelper.getFieldCation(subCaptions, columnIndex, view, control, baseinfoformat);
        }
    }

    public static Map.Entry<String, IDataEntityProperty> getEntryBoidEntityProperty(String entityId, String entryKey) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        EntityType entryEntityType = dataEntityType.getAllEntities().getOrDefault(entryKey, null);
        if (ObjectUtils.isEmpty((Object)entryEntityType)) {
            return null;
        }
        Map fields = entryEntityType.getFields();
        if (MapUtils.isEmpty((Map)fields)) {
            return null;
        }
        Optional<Map.Entry> findFirstEntryBoidKey = fields.entrySet().stream().filter(item -> ((String)item.getKey()).startsWith("entryboid")).findFirst();
        if (findFirstEntryBoidKey.isPresent()) {
            return findFirstEntryBoidKey.get();
        }
        return null;
    }

    private static Map<String, ControlAp> getEntryControlAps(List<ControlAp<?>> allItems, String entryKey) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (ControlAp<?> item : allItems) {
            if (!entryKey.equalsIgnoreCase(item.getKey()) || !(item instanceof EntryAp)) continue;
            EntryAp entryAp = (EntryAp)item;
            for (ControlAp ap : entryAp.getItems()) {
                if (ap instanceof EntryFieldGroupAp) {
                    for (ControlAp aap : ((EntryFieldGroupAp)ap).getItems()) {
                        map.put(aap.getKey(), aap);
                    }
                    continue;
                }
                map.put(ap.getKey(), ap);
            }
        }
        return map;
    }

    private static Map<String, Object> getSettingFieldInfo(IFormView currView, String entryKey) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)6);
        FormShowParameter showParameter = currView.getFormShowParameter();
        String settingkey = showParameter.getShowParameter().getSettingKey();
        String json = UserConfigServiceHelper.getSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)settingkey);
        if (StringUtils.isEmpty((CharSequence)json)) {
            LOGGER.info("getSettingFieldInfo_json is null");
            return map;
        }
        JSONObject settings = JSON.parseObject((String)json).getJSONObject(entryKey);
        JSONArray csJsonArray = settings.getJSONArray("cs");
        csJsonArray.removeIf(item -> {
            String colId = (String)item;
            return "seq".equalsIgnoreCase(colId);
        });
        JSONArray cwgJsonArray = settings.getJSONArray("cwg");
        cwgJsonArray.removeIf(item -> {
            JSONObject obj = (JSONObject)item;
            String colId = obj.getString("colId");
            Control control = currView.getControl(obj.getString("colId"));
            return control instanceof OperationColumn || "seq".equalsIgnoreCase(colId);
        });
        JSONObject cvJsonobj = settings.getJSONObject("cv");
        cvJsonobj.remove((Object)"seq");
        cvJsonobj.remove((Object)"rk");
        map.put("cs", csJsonArray);
        map.put("cwg", cwgJsonArray);
        map.put("cv", cvJsonobj);
        return map;
    }

    public static Map<String, Map<String, Object>> getEntryBdMainProp(IFormView view, String entryKey) {
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, IDataEntityProperty> currentEntryField = ExportEntryDataHelper.getEntryAllField(view, entryKey);
        for (Map.Entry<String, IDataEntityProperty> next : currentEntryField.entrySet()) {
            IDataEntityProperty fldProperty = next.getValue();
            Map bdMainProp = null;
            if (fldProperty instanceof IBasedataField) {
                BasedataEntityType type = (BasedataEntityType)((IBasedataField)fldProperty).getComplexType();
                bdMainProp = MethodUtil.getBdMainProp((String)type.getName());
            }
            if (bdMainProp == null) continue;
            fieldMap.put(fldProperty.getName(), bdMainProp);
        }
        return fieldMap;
    }

    public static Map<String, IDataEntityProperty> getEntryAllField(IFormView view, String entryKey) {
        HashMap fields = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)view.getEntityId());
        EntityType entityType = (EntityType)mainEntityType.getAllEntities().get(entryKey);
        fields.putAll(entityType.getFields());
        Map<String, Object> fieldMap = ExportEntryDataHelper.getSettingFieldInfo(view, entryKey);
        if (ObjectUtils.isEmpty(fieldMap)) {
            return fields;
        }
        JSONArray csNames = (JSONArray)fieldMap.get("cs");
        for (Object csName : csNames) {
            String colId = (String)csName;
            ExportEntryDataHelper.addField(fields, view, colId, entityType);
        }
        JSONObject cvNames = (JSONObject)fieldMap.get("cv");
        for (Map.Entry next : cvNames.entrySet()) {
            String colId = (String)next.getKey();
            if (fields.containsKey(colId)) continue;
            ExportEntryDataHelper.addField(fields, view, colId, entityType);
        }
        return fields;
    }

    private static void addField(Map<String, IDataEntityProperty> fields, IFormView view, String colId, EntityType entityType) {
        DateRangeEdit dr;
        Control control = view.getControl(colId);
        if (control == null || control instanceof BasedataPropEdit || !(control instanceof FieldEdit)) {
            return;
        }
        Map entityTypeFields = entityType.getFields();
        IDataEntityProperty property = (IDataEntityProperty)entityTypeFields.get(colId);
        if (property == null) {
            FieldEdit fieldEdit = (FieldEdit)control;
            property = fieldEdit.getProperty();
        }
        if (control instanceof DateRangeEdit) {
            dr = (DateRangeEdit)control;
            IDataEntityProperty property1 = (IDataEntityProperty)entityTypeFields.get(dr.getStartDateFieldKey());
            if (property1 != null) {
                fields.put(dr.getStartDateFieldKey(), property1);
            } else {
                fields.put(dr.getStartDateFieldKey(), property);
            }
            IDataEntityProperty property2 = (IDataEntityProperty)entityTypeFields.get(dr.getEndDateFieldKey());
            if (property2 != null) {
                fields.put(dr.getEndDateFieldKey(), property2);
            } else {
                fields.put(dr.getStartDateFieldKey(), property);
            }
        } else if (control instanceof TimeRangeEdit) {
            dr = (TimeRangeEdit)control;
            IDataEntityProperty property1 = (IDataEntityProperty)entityTypeFields.get(dr.getStartDateFieldKey());
            if (property1 != null) {
                fields.put(dr.getStartDateFieldKey(), property1);
            } else {
                fields.put(dr.getStartDateFieldKey(), property);
            }
            IDataEntityProperty property2 = (IDataEntityProperty)entityTypeFields.get(dr.getEndDateFieldKey());
            if (property2 != null) {
                fields.put(dr.getEndDateFieldKey(), property2);
            } else {
                fields.put(dr.getStartDateFieldKey(), property);
            }
        } else {
            fields.put(colId, property);
        }
    }

    public static SXSSFCell creatHeaderCell(String caption, CellStyle cellStyle, SXSSFSheet sheet, SXSSFRow row, int columnIndex) {
        int colWidth = 0;
        SXSSFCell cell = EntryExcelGenerateHelper.createCell(row, columnIndex, cellStyle);
        cell.setCellValue(caption);
        sheet.setColumnWidth(columnIndex, Math.min(256 * Math.max(colWidth / 8, Math.max(caption.length(), 8)) * 2, 30720));
        return cell;
    }
}

